/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.gorod.server.action;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.gorod.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.gorod.server.bean.GorodParams;
import ru.bitel.bgbilling.modules.gorod.server.bean.Register;
import ru.bitel.bgbilling.modules.gorod.server.bean.RegisterItem;
import ru.bitel.bgbilling.modules.gorod.server.bean.RegisterItemManager;
import ru.bitel.bgbilling.modules.gorod.server.bean.RegisterMacrosProcessor;
import ru.bitel.bgbilling.modules.gorod.server.bean.RegisterManager;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.directories.address.server.bean.HouseDao;
import ru.bitel.oss.kernel.entity.common.bean.AddressStruct;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;

public class ActionGetRegister
extends ActionBase {
    private static Map<String, Pattern> insertPartPatterns = new HashMap<String, Pattern>(12);

    public void doAction() throws Exception {
        GorodParams params = new GorodParams((Preferences)this.moduleSetup);
        int id = this.getIntParameter("id", -1);
        if (this.mid <= 0 || id <= 0) {
            throw new BGIllegalArgumentException();
        }
        Register register = new RegisterManager(this.con, this.mid).getRegisterById(id);
        String registerPattern = params.getRegisterPattern(String.valueOf(register.getTagId()));
        RegisterMacrosProcessor summProcessor = new RegisterMacrosProcessor(params);
        List<RegisterItem> itemList = new RegisterItemManager(this.con, this.mid, (Preferences)this.moduleSetup).getRegisterItems(id);
        StringBuilder registerContent = new StringBuilder();
        BigDecimal totalSumm = BigDecimal.ZERO;
        int account = 0;
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        DecimalFormat format = new DecimalFormat("#############0.00", dfs);
        for (RegisterItem item : itemList) {
            AddressStruct addressStruct = this.getAddressStruct(params, item.contractID);
            registerPattern = this.insertPatternPart(registerPattern, "fio", item.fullname);
            registerPattern = this.insertPatternPart(registerPattern, "contractId", String.valueOf(item.contractID));
            registerPattern = this.insertPatternPart(registerPattern, "contractTitle", item.contract);
            if (!this.isEmptyAddress(addressStruct)) {
                if (params.isDropGFromAddress()) {
                    String city = addressStruct.getCity().replaceAll("^\\s*\u0433\\.\\s*", "");
                    registerPattern = this.insertPatternPart(registerPattern, "city", city);
                } else {
                    registerPattern = this.insertPatternPart(registerPattern, "city", addressStruct.getCity());
                }
                registerPattern = this.insertPatternPart(registerPattern, "street", addressStruct.getStreet());
                registerPattern = this.insertPatternPart(registerPattern, "house", addressStruct.getHouse());
                registerPattern = this.insertPatternPart(registerPattern, "frac", addressStruct.getFrac());
                registerPattern = this.insertPatternPart(registerPattern, "flat", addressStruct.getFlat());
            } else {
                String defaultAddress = params.getDefaultAddress().replace("${cid}", String.valueOf(item.contractID));
                registerPattern = this.insertPatternPart(registerPattern, "city", defaultAddress);
                registerPattern = this.insertPatternPart(registerPattern, "street", "");
                registerPattern = this.insertPatternPart(registerPattern, "house", "");
                registerPattern = this.insertPatternPart(registerPattern, "frac", "");
                registerPattern = this.insertPatternPart(registerPattern, "flat", "");
            }
            registerPattern = this.insertPatternPart(registerPattern, "dateFrom", TimeUtils.format((Date)TimeUtils.getStartMonth((Date)new Date()), (String)params.getDateFormat()));
            registerPattern = this.insertPatternPart(registerPattern, "dateTo", TimeUtils.format((Date)register.getDate().getTime(), (String)params.getDateFormat()));
            registerPattern = this.insertPatternPart(registerPattern, "account", String.valueOf(item.account));
            if (register.getType() == 7) {
                BigDecimal summ = summProcessor.getSumm(item.rest);
                registerPattern = this.insertPatternPart(registerPattern, "summ", String.valueOf(format.format(Utils.roundBigDecimalSumm((BigDecimal)summ))));
                totalSumm = totalSumm.add(summ);
            } else {
                registerPattern = this.insertPatternPart(registerPattern, "summ", "0");
            }
            account = item.account;
            registerContent.append(registerPattern + "\r\n");
            registerPattern = params.getRegisterPattern(String.valueOf(register.getTagId()));
        }
        int a = params.getHeaderAccount(register.getTagId());
        if (a >= 0) {
            account = a;
        }
        if (params.isNote()) {
            registerContent.insert(0, "\r\n");
            if (params.isNoteDate()) {
                registerContent.insert(0, TimeUtils.format((Date)new Date(System.currentTimeMillis()), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            registerContent.insert(0, "#NOTE ");
        }
        registerContent.insert(0, "\r\n");
        registerContent.insert(0, account);
        registerContent.insert(0, "#SERVICE ");
        registerContent.insert(0, "\r\n");
        registerContent.insert(0, register.getType());
        registerContent.insert(0, "#TYPE ");
        registerContent.insert(0, "\r\n");
        registerContent.insert(0, format.format(Utils.roundBigDecimalSumm((BigDecimal)totalSumm)));
        registerContent.insert(0, "#FILESUM ");
        try {
            this.getResponseOut().write(registerContent.toString().getBytes(params.getRegisterEncoding(String.valueOf(register.getTagId()))));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private AddressStruct getAddressStruct(GorodParams params, int conractId) throws BGException {
        AddressStruct result;
        block13: {
            result = null;
            try (ContractDao contractDao = new ContractDao(this.con, this.userId.intValue());){
                EntityAttrAddress entityAttrAddress = contractDao.optContractParameterAddress(conractId, params.getParamAddress()).orElse(null);
                if (entityAttrAddress == null) break block13;
                try (HouseDao houseDao = new HouseDao(this.con);){
                    House house = houseDao.get(entityAttrAddress.getHouseId());
                    if (house != null) {
                        result = new AddressStruct().setIndex(house.getPostIndex()).setCountry((String)house.optCountry().map(IdTitle::getTitle).orElse(null)).setCity((String)house.optCity().map(IdTitle::getTitle).orElse(null)).setArea((String)house.optArea().map(IdTitle::getTitle).orElse(null)).setQuarter((String)house.optQuarter().map(IdTitle::getTitle).orElse(null)).setStreet((String)house.optStreet().map(IdTitle::getTitle).orElse(null)).setHouse(String.valueOf(house.getHouse())).setFrac(house.getFrac()).setFlat(entityAttrAddress.getFlat()).setRoom(entityAttrAddress.getRoom()).setPod(String.valueOf(entityAttrAddress.getPod())).setFloor(String.valueOf(entityAttrAddress.getFloor())).setComment(entityAttrAddress.getComment());
                    }
                }
                catch (Exception ex) {
                    throw new BGException((Throwable)ex);
                }
            }
        }
        return result;
    }

    private boolean isEmptyAddress(AddressStruct addressStruct) {
        boolean result = false;
        if (addressStruct == null) {
            result = true;
        } else if (addressStruct.getCity().equals("") && addressStruct.getStreet().equals("") && addressStruct.getHouse().equals("") && addressStruct.getFlat().equals("")) {
            result = true;
        }
        return result;
    }

    private String insertPatternPart(String pattern, String key, String value) {
        Matcher m;
        StringBuilder result = new StringBuilder(pattern.length());
        Pattern p = insertPartPatterns.get(key);
        if (p == null) {
            p = Pattern.compile("\\[([\\w\u0430-\u044f\u0410-\u042f\\,\\.\\:\\;\\s\\[\\]\\(\\)\\\\/#]*)\\$\\{" + key + "\\}([\\w\u0430-\u044f\u0410-\u042f\\,\\.\\:\\;\\s\\[\\]\\(\\)\\\\/#]*)\\]");
            insertPartPatterns.put(key, p);
        }
        if ((m = p.matcher(pattern)).find()) {
            if (Utils.notBlankString((String)value)) {
                result.append(pattern.substring(0, m.start()));
                String prefix = m.group(1);
                if (prefix.startsWith(",") && result.length() == 0) {
                    prefix = prefix.substring(1);
                }
                result.append(prefix);
                result.append(value);
                result.append(m.group(2));
                result.append(pattern.substring(m.end()));
            } else {
                result.append(pattern.substring(0, m.start()));
                result.append(pattern.substring(m.end()));
            }
        } else {
            result.append(pattern);
        }
        return result.toString();
    }
}

