/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.modules.hd.server.bean.CPHosting;
import ru.bitel.common.Utils;

public class CPHostingManager
extends AbstarctDaoConstant {
    public CPHostingManager(Connection con, int moduleId) {
        super(con, "hd_cp_hosting", moduleId);
    }

    public CPHosting getHosting(int cpid) throws SQLException {
        CPHosting result = null;
        String query = "SELECT * FROM " + this.tableName + " WHERE cpid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, cpid);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.getHdServiceHostingFromRS(rs);
                }
            }
        }
        return result;
    }

    private CPHosting getHdServiceHostingFromRS(ResultSet rs) throws SQLException {
        CPHosting result = new CPHosting();
        result.setContractPackageId(rs.getInt("cpid"));
        result.setData(rs.getString("data"));
        result.setHostList(Utils.toList((String)rs.getString("host_name")));
        return result;
    }

    public List<CPHosting> getHostingList() throws SQLException {
        ArrayList<CPHosting> result = new ArrayList<CPHosting>();
        String query = "SELECT * FROM " + this.tableName;
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            if (rs.next()) {
                result.add(this.getHdServiceHostingFromRS(rs));
            }
        }
        return result;
    }

    public void deleteHosting(int contractPackageId) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE cpid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractPackageId);
            ps.executeUpdate();
        }
    }

    public void updateHosting(CPHosting hosting) throws SQLException {
        this.deleteHosting(hosting.getContractPackageId());
        String query = "INSERT INTO " + this.tableName + " (cpid, data, host_name) VALUES (?,?,?)";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, hosting.getContractPackageId());
            ps.setString(2, hosting.getData());
            ps.setString(3, Utils.toString(hosting.getHostList()));
            ps.executeUpdate();
        }
    }
}

