/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.action.web;

import jakarta.annotation.Resource;
import java.awt.BasicStroke;
import java.awt.Stroke;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficMaxDetail;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficMaxDetailReport;
import ru.bitel.bgbilling.modules.inet.common.bean.TrafficType;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.bgbilling.modules.inet.common.service.InetSessionService;
import ru.bitel.bgbilling.modules.inet.server.action.web.AbstractChartReport;
import ru.bitel.bgbilling.modules.inet.server.action.web.TimeSeriesEx;
import ru.bitel.bgbilling.modules.inet.server.bean.TrafficTypeDao;
import ru.bitel.bgbilling.modules.inet.server.tariff.max.TrafficMaxKey;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;
import ru.bitel.common.reports.Charts;

public class ActionTrafficMaxReport
extends AbstractChartReport {
    @Resource
    ModuleService moduleService;
    @Resource
    InetSessionService sessionService;
    @Resource
    InetServService servService;

    public void execute() throws Exception {
        int servId = this.req.getInt("inetServId", -1);
        int unit = this.req.getInt("unit", 0x100000);
        Period period = this.getPeriodByYearMonthDay();
        Set trafficTypeIds = Collections.emptySet();
        String[] trafficTypeIdsString = this.context.getRequest().getParameterValues("trafficTypeIds");
        if (trafficTypeIdsString != null) {
            trafficTypeIds = Utils.toIntegerSet((String)Utils.toString(Arrays.asList(trafficTypeIdsString)));
            trafficTypeIds.remove(0);
        }
        List inetServList = this.servService.inetServList(this.contractId, "dateTo, dateFrom");
        inetServList.stream().forEach(serv -> serv.setTitle(serv.getTitle() + " (" + TimeUtils.formatPeriod((Date)serv.getDateFrom(), (Date)serv.getDateTo()) + ")"));
        this.setResultParam("servs", inetServList);
        this.setResultParam("inetServId", servId);
        this.setResultParam("unit", unit);
        boolean byDay = !TimeUtils.dateEqual((Date)period.getDateFrom(), (Date)period.getDateTo());
        List result = this.sessionService.inetSessionTrafficMax(this.contractId, null, period.getDateFrom(), period.getDateTo(), (long)unit);
        String chart = this.chart(period.getDateFrom(), result, unit);
        this.setResultParam("chart", chart);
        if (byDay) {
            Calendar calendar = period.getDateFromCalendar();
            int last = calendar.getActualMaximum(5);
            ArrayList<Integer> days = new ArrayList<Integer>();
            for (int i = 1; i <= last; ++i) {
                days.add(i);
            }
            this.setResultParam("days", days);
        }
        this.setResult(result);
    }

    private void add(String title, List<TimeSeriesEx> timeSeriesList, Map<Long, TimeSeriesEx> timeSeriesMap, long treeNodeId, RegularTimePeriod timePeriod, long amount, long unit, String suffix) {
        TimeSeriesEx timeSeries = timeSeriesMap.get(treeNodeId);
        if (timeSeries == null) {
            timeSeries = new TimeSeriesEx(title + suffix);
            timeSeriesMap.put(treeNodeId, timeSeries);
            timeSeriesList.add(timeSeries);
        }
        timeSeries.addOrPlus(timePeriod, (double)amount / (double)unit);
    }

    private void add(Map<Integer, TrafficType> trafficTypeMap, List<TimeSeriesEx> timeSeriesList, Map<Integer, TimeSeriesEx> timeSeriesMap, int trafficTypeId, RegularTimePeriod timePeriod, long amount, long unit, String suffix) {
        TimeSeriesEx timeSeries = timeSeriesMap.get(trafficTypeId = -trafficTypeId - 1);
        if (timeSeries == null) {
            TrafficType trafficType = trafficTypeMap.get(trafficTypeId);
            timeSeries = new TimeSeriesEx(String.valueOf(trafficType != null ? trafficType.getTitle() : Integer.valueOf(trafficTypeId)) + suffix);
            timeSeriesMap.put(trafficTypeId, timeSeries);
            timeSeriesList.add(timeSeries);
        }
        timeSeries.addOrPlus(timePeriod, (double)amount / (double)unit);
    }

    private String chart(Date dateFrom, List<TrafficMaxDetailReport> trafficMaxList, long unit) throws BGException {
        String result = null;
        String unitTitle = this.getUnitTitle(unit);
        Map trafficTypeMap = null;
        try (TrafficTypeDao trafficTypeDao = new TrafficTypeDao(this.con, this.moduleId);){
            trafficTypeMap = TrafficType.newMap(trafficTypeDao.list());
        }
        ArrayList<TimeSeriesEx> timeSeriesList = new ArrayList<TimeSeriesEx>();
        HashMap<Integer, TimeSeriesEx> timeSeriesMapTraffic = new HashMap<Integer, TimeSeriesEx>();
        HashMap<Long, TimeSeriesEx> timeSeriesMapMax = new HashMap<Long, TimeSeriesEx>();
        Day currentTimePeriod = null;
        GregorianCalendar utilCalendar = new GregorianCalendar();
        utilCalendar.setTime(dateFrom);
        for (TrafficMaxDetailReport trafficMaxDetailReport : trafficMaxList) {
            block14: for (TrafficMaxDetail detail : trafficMaxDetailReport.getTrafficMaxDetailList()) {
                Day timePeriod;
                long maxKey = detail.getMaxKey();
                int mode = TrafficMaxKey.getMode(maxKey);
                TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)utilCalendar);
                utilCalendar.set(5, detail.getDay());
                Object suffix = "";
                switch (mode) {
                    case 1: {
                        timePeriod = new Day(utilCalendar.getTime());
                        suffix = " (" + unitTitle + "/\u0437\u0430 \u0443\u0447\u0435\u0442\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434 \u043d\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u0434\u0435\u043d\u044c)";
                        break;
                    }
                    case 2: {
                        timePeriod = new Day(utilCalendar.getTime());
                        suffix = " (" + unitTitle + "/\u0437\u0430 \u043c\u0435\u0441\u044f\u0446 \u043d\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u0434\u0435\u043d\u044c)";
                        break;
                    }
                    case 3: {
                        timePeriod = new Day(utilCalendar.getTime());
                        suffix = " (" + unitTitle + "/\u0434\u0435\u043d\u044c)";
                        break;
                    }
                    case 4: {
                        utilCalendar.set(11, detail.getHour());
                        timePeriod = new Hour(utilCalendar.getTime());
                        suffix = " (" + unitTitle + "/\u0447\u0430\u0441)";
                        break;
                    }
                    default: {
                        continue block14;
                    }
                }
                if (Utils.isBlankString((String)unitTitle)) {
                    suffix = "";
                }
                if (currentTimePeriod != null && !currentTimePeriod.next().equals(timePeriod)) {
                    RegularTimePeriod prev;
                    RegularTimePeriod next = currentTimePeriod.next();
                    if (next.equals(prev = timePeriod.previous())) {
                        for (TimeSeriesEx timeSeries : timeSeriesList) {
                            timeSeries.addOrPlus(next, 0.0);
                        }
                    } else {
                        for (TimeSeriesEx timeSeries : timeSeriesList) {
                            timeSeries.addOrPlus(next, 0.0);
                            timeSeries.addOrPlus(prev, 0.0);
                        }
                    }
                }
                currentTimePeriod = timePeriod;
                this.add(trafficTypeMap, timeSeriesList, timeSeriesMapTraffic, trafficMaxDetailReport.getTrafficTypeId1(), (RegularTimePeriod)timePeriod, detail.getAmount1(), unit, (String)suffix);
                this.add(trafficTypeMap, timeSeriesList, timeSeriesMapTraffic, trafficMaxDetailReport.getTrafficTypeId2(), (RegularTimePeriod)timePeriod, detail.getAmount2(), unit, (String)suffix);
                this.add(trafficMaxDetailReport.getTitle(), timeSeriesList, timeSeriesMapMax, trafficMaxDetailReport.getTreeNodeId(), (RegularTimePeriod)timePeriod, detail.getAmountMax(), unit, (String)suffix);
            }
        }
        for (TimeSeriesEx timeSeriesEx : timeSeriesList) {
            timeSeriesEx.addOrPlus(currentTimePeriod.next(), 0.0);
        }
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        for (TimeSeries timeSeries : timeSeriesList) {
            dataset.addSeries(timeSeries);
        }
        try {
            XYStepRenderer xYStepRenderer = new XYStepRenderer();
            ArrayList<BasicStroke> arrayList = new ArrayList<BasicStroke>();
            arrayList.add(new BasicStroke(1.0f, 1, 1));
            arrayList.add(new BasicStroke(1.0f, 1, 1));
            arrayList.add(new BasicStroke(3.0f, 2, 1, 1.0f, new float[]{5.0f, 10.0f}, 10.0f));
            ArrayList<BasicStroke> strokeList = new ArrayList<BasicStroke>();
            for (int i = 0; i < 10; ++i) {
                strokeList.addAll(arrayList);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
            ChartUtils.writeChartAsPNG((OutputStream)baos, (JFreeChart)Charts.createTimeSeriesChart((XYItemRenderer)xYStepRenderer, (XYDataset)dataset, (DrawingSupplier)Charts.getDrawingSupplier(null, (Stroke[])strokeList.toArray(new Stroke[strokeList.size()]))), (int)800, (int)300, (ChartRenderingInfo)new ChartRenderingInfo(), (boolean)true, (int)0);
            result = this.addChart(baos);
            baos = null;
        }
        catch (IOException iOException) {
            throw new BGException((Throwable)iOException);
        }
        for (TimeSeries timeSeries : timeSeriesList) {
            timeSeries.clear();
        }
        timeSeriesList.clear();
        timeSeriesMapTraffic.clear();
        timeSeriesMapMax.clear();
        return result;
    }
}

