/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroupAttr;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractParameterService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.common.Utils;

public class FindContractUtils {
    public static int findContractByParameter(Connection con, int parameterId, String value) throws BGException {
        int result;
        block25: {
            result = 0;
            if (parameterId > 0 && !Utils.isEmptyString((String)value)) {
                try {
                    ServerContext serverContext = (ServerContext)ServerContext.get();
                    ContractParameterService contractParameterService = (ContractParameterService)serverContext.getService(ContractParameterService.class, 0);
                    ContractParameterGroupAttr contractParameterGroupAttr = contractParameterService.contractParameterGroupAttrGet(parameterId);
                    contractParameterGroupAttr.getType();
                    int type = Optional.ofNullable(contractParameterGroupAttr).map(a -> a.getType()).orElse(-1);
                    if (type == 1) {
                        try (ContractDao contractDao = new ContractDao(con, 0);){
                            result = contractDao.getContractIdByTextParameter(parameterId, value);
                            break block25;
                        }
                    }
                    if (type != 10) break block25;
                    String query = "SELECT cid FROM contract_parameter_type_phone_item WHERE pid=? AND phone=?";
                    try (PreparedStatement ps = con.prepareStatement(query);){
                        ps.setInt(1, parameterId);
                        ps.setString(2, value);
                        try (ResultSet rs = ps.executeQuery();){
                            while (rs.next()) {
                                if (result > 0) {
                                    result = -1;
                                    break;
                                }
                                result = rs.getInt(1);
                            }
                        }
                    }
                    if (result == 0) {
                        throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430, \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0443\u0434\u043e\u0432\u043b\u0435\u0442\u0432\u043e\u0440\u044f\u044e\u0449\u0438\u0445 \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u043c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c [\u043d\u043e\u043c\u0435\u0440=" + value + "]");
                    }
                    if (result < 0) {
                        throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430, \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0443\u0434\u043e\u0432\u043b\u0435\u0442\u0432\u043e\u0440\u044f\u044e\u0449\u0438\u0445 \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u043c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c [\u043d\u043e\u043c\u0435\u0440=" + value + "]");
                    }
                }
                catch (Exception ex) {
                    throw new BGException((Throwable)ex);
                }
            }
        }
        return result;
    }

    public static int findContractByEmail(Connection con, String email) {
        int result = 0;
        if (!Utils.isEmptyString((String)email)) {
            String query = "SELECT DISTINCT cid FROM contract_parameter_3 WHERE email=? LIMIT 1";
            try (PreparedStatement ps = con.prepareStatement(query);){
                ps.setString(1, email);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        result = rs.getInt(1);
                    }
                }
            }
            catch (SQLException ex) {
                BGLogger.error((Throwable)ex);
            }
        }
        return result;
    }

    public static int findContractByVoice(Connection con, int moduleId, String phone) {
        int result = 0;
        if (moduleId > 0 && !Utils.isEmptyString((String)phone)) {
            String query = "SELECT DISTINCT cid FROM user_login_" + moduleId + " WHERE (number=?) AND (date1 IS NULL OR date1<=NOW()) AND (date2 IS NULL OR date2>=NOW())";
            try (PreparedStatement ps = con.prepareStatement(query);){
                ps.setString(1, phone);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        result = rs.getInt(1);
                    }
                }
            }
            catch (SQLException ex) {
                BGLogger.error((Throwable)ex);
            }
        }
        return result;
    }

    public static int findContractByTitle(Connection con, String title) {
        int result = 0;
        if (!Utils.isEmptyString((String)title)) {
            try (PreparedStatement ps = con.prepareStatement("SELECT id FROM contract WHERE title=?");){
                ps.setString(1, title);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        result = rs.getInt(1);
                    }
                }
            }
            catch (SQLException ex) {
                BGLogger.error((Throwable)ex);
            }
        }
        return result;
    }

    public static int findContractByCerbercrypt(Connection con, int moduleId, String card) {
        int result = 0;
        int _card = Utils.parseInt((String)card, (int)-1);
        if (moduleId > 0 && _card > 0) {
            String query = "SELECT DISTINCT cid FROM user_card_" + moduleId + " WHERE number=?";
            try (PreparedStatement ps = con.prepareStatement(query);){
                ps.setInt(1, _card);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        result = rs.getInt(1);
                    }
                }
            }
            catch (SQLException ex) {
                BGLogger.error((Throwable)ex);
            }
        }
        return result;
    }

    public static int findContractByMPSLogin(Connection con, int moduleId, String _login) {
        int result = 0;
        int login = Utils.parseInt((String)_login, (int)-1);
        if (login <= 0) {
            return 0;
        }
        if (moduleId > 0 && login > 0) {
            String query = "SELECT cid FROM mps_login_" + moduleId + " WHERE id=?";
            try (PreparedStatement ps = con.prepareStatement(query);){
                ps.setInt(1, login);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        result = rs.getInt(1);
                    }
                }
            }
            catch (SQLException ex) {
                BGLogger.error((Throwable)ex);
            }
        }
        return result;
    }

    public static int findContractByInetLogin(Connection con, int moduleId, String inetLogin) {
        int result = -1;
        if (moduleId > 0 && !Utils.isEmptyString((String)inetLogin)) {
            String query = "SELECT DISTINCT contractId FROM inet_serv_" + moduleId + " WHERE login=? AND (dateFrom IS NULL OR dateFrom<=NOW()) AND (dateTo IS NULL OR dateTo>=NOW())";
            try (PreparedStatement ps = con.prepareStatement(query);){
                ps.setString(1, inetLogin);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        result = rs.getInt(1);
                    }
                }
            }
            catch (SQLException ex) {
                BGLogger.error((Throwable)ex);
            }
        }
        return result;
    }
}

