/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.edo.server.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class EdoFnsXmlGenerator
extends ArrayList<Object> {
    public void A(String name, String value) {
        this.A(name, value, false);
    }

    public void A(String name, String value, int maxlen) {
        if (Utils.notBlankString((String)value) && value.length() > maxlen) {
            value = value.substring(0, maxlen);
        }
        this.A(name, value);
    }

    public void A(String name, String value, boolean addEmpty) {
        if (Utils.notBlankString((String)value) || addEmpty) {
            this.add(new A_el(name, value));
        }
    }

    public void P(String name, String value) {
        this.P(name, value, false);
    }

    public void P(String name, String value, boolean addEmpty) {
        if (Utils.notBlankString((String)value) || addEmpty) {
            this.add(new P_el(name, value));
        }
    }

    public void S(String name, EdoFnsXmlGenerator value) {
        this.S(name, value, false);
    }

    public void S(String name, EdoFnsXmlGenerator value, boolean addEmpty) {
        if (Utils.notEmptyCollection((Collection)value) || addEmpty) {
            this.add(new S_el(name, value));
        }
    }

    private void dictToXml(Element xmlnode, Object dictSnode) {
        for (Object e : (EdoFnsXmlGenerator)dictSnode) {
            if (e instanceof A_el) {
                A_el a_el = (A_el)e;
                xmlnode.setAttribute(a_el.name, (String)a_el.value);
                continue;
            }
            if (e instanceof P_el) {
                P_el p_el = (P_el)e;
                Element newP = xmlnode.getOwnerDocument().createElement(p_el.name);
                xmlnode.appendChild(newP);
                newP.setTextContent((String)p_el.value);
                continue;
            }
            if (!(e instanceof S_el)) continue;
            S_el s_el = (S_el)e;
            Element newS = xmlnode.getOwnerDocument().createElement(s_el.name);
            xmlnode.appendChild(newS);
            this.dictToXml(newS, s_el.value);
        }
    }

    public byte[] serialize(String encoding) throws TransformerException, IOException, ParserConfigurationException, BGException {
        if (this.size() != 1 || !(this.get(0) instanceof S_el)) {
            throw new BGException("\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u043e\u0434\u0438\u043d \u043a\u043e\u0440\u043d\u0435\u0432\u043e\u0439 S-\u044d\u043b\u0435\u043c\u0435\u043d\u0442");
        }
        DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
        dFactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = dFactory.newDocumentBuilder();
        Document xmldoc = docBuilder.newDocument();
        S_el s_el = (S_el)this.get(0);
        Element xmlrootEl = xmldoc.createElement(s_el.name);
        xmldoc.appendChild(xmlrootEl);
        this.dictToXml(xmlrootEl, s_el.value);
        Properties properties = XMLUtils.getSerializeProperties((String)encoding, (boolean)true);
        try (ByteArrayOutputStream os = new ByteArrayOutputStream(65536);){
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperties(properties);
            transformer.transform(new DOMSource(xmldoc), new StreamResult(os));
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    private static class A_el
    extends _el<String> {
        public A_el(String name, String value) {
            super(name, value);
        }

        @Override
        public String toString() {
            return "@" + this.name + "=" + (String)this.value;
        }
    }

    private static class P_el
    extends _el<String> {
        public P_el(String name, String value) {
            super(name, value);
        }
    }

    private static class S_el
    extends _el<EdoFnsXmlGenerator> {
        public S_el(String name, EdoFnsXmlGenerator value) {
            super(name, value);
        }
    }

    public static class S
    extends EdoFnsXmlGenerator {
    }

    private static class _el<T> {
        String name;
        T value;

        public _el(String name, T value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return this.name + "=" + String.valueOf(this.value);
        }
    }
}

