/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.onpay.server.action.web;

import bitel.billing.server.ActionResultContentType;
import java.math.BigDecimal;
import java.net.URLEncoder;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractPaymentAction;
import ru.bitel.bgbilling.modules.onpay.common.bean.Transaction;
import ru.bitel.bgbilling.modules.onpay.server.bean.Constants;
import ru.bitel.bgbilling.modules.onpay.server.bean.TransactionManager;
import ru.bitel.common.io.Base64;
import ru.bitel.common.model.SearchResult;

@WebAction(title="Onpay")
public class ActionDoTransaction
extends AbstractPaymentAction {
    public ActionDoTransaction() {
        super("onpay");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws Exception {
        this.paymentForm(this.moduleName, Constants.class, null);
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws BGException {
        SearchResult searchResult = new SearchResult(this.getPage(), new String[]{"createDate:1", "transactionDate:1"});
        new TransactionManager(this.con, this.moduleId).searchTransactionList((SearchResult<Transaction>)searchResult, 0, this.contractId);
        this.setResultParam("transactions", searchResult.getList());
        this.requestDispatcher("include", "payment_transactions");
    }

    public void failure() throws Exception {
        this.execute();
        throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0430");
    }

    public void success() throws Exception {
        this.execute();
        throw new BGMessageException("\u041f\u043b\u0430\u0442\u0435\u0436 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436")
    public void pay() throws Exception {
        super.pay();
        super.payCheckSum();
        if (this.sum.compareTo(BigDecimal.ZERO) <= 0) {
            this.execute();
            throw new BGMessageException("\u0421\u0443\u043c\u043c\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0443\u043b\u044f");
        }
        String contractTitle = this.getContractTitle();
        StringBuilder redirectUrl = new StringBuilder();
        redirectUrl.append(this.moduleSetup.get("onpay.gate.url", this.moduleSetup.get("REDIRECT_URL", "https://onpay.ru/Payment/Init")));
        redirectUrl.append("?");
        this.addRequestParamPair(redirectUrl, "LMI_MERCHANT_ID", this.moduleSetup.get("onpay.merchant.id", this.moduleSetup.get("LMI_MERCHANT_ID")));
        this.addRequestParamPair(redirectUrl, "LMI_PAYMENT_AMOUNT", this.sum.toPlainString());
        this.addRequestParamPair(redirectUrl, "LMI_CURRENCY", this.moduleSetup.get("onpay.currecy", this.moduleSetup.get("LMI_CURRENCY", "RUB")));
        this.addRequestParamPair(redirectUrl, "LMI_PAYMENT_NO", contractTitle);
        String desc = this.moduleSetup.get("onpay.payment.desc", this.moduleSetup.get("LMI_PAYMENT_DESC", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}"));
        this.addRequestParamPair(redirectUrl, "LMI_PAYMENT_DESC", desc.replace("{CONTRACT_TITLE}", contractTitle));
        desc = this.moduleSetup.get("onpay.payment.desc.base64", this.moduleSetup.get("LMI_PAYMENT_DESC_BASE64", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}"));
        this.addRequestParamPair(redirectUrl, "LMI_PAYMENT_DESC_BASE64", desc == null ? null : Base64.encodeUTF8((String)desc.replace("{CONTRACT_TITLE}", contractTitle)));
        this.addRequestParamPair(redirectUrl, "LMI_SIM_MODE", this.moduleSetup.get("onpay.sim.mode", this.moduleSetup.get("LMI_SIM_MODE")));
        this.addRequestParamPair(redirectUrl, "LMI_PAYMENT_CONFIRMATION_URL", this.moduleSetup.get("onpay.payment.confirmation.url", this.moduleSetup.get("LMI_PAYMENT_CONFIRMATION_URL")));
        this.addRequestParamPair(redirectUrl, "LMI_PAYMENT_NOTIFICATION_URL", this.moduleSetup.get("onpay.payment.notification.url", this.moduleSetup.get("LMI_PAYMENT_NOTIFICATION_URL")));
        this.addRequestParamPair(redirectUrl, "LMI_SUCCESS_URL", this.moduleSetup.get("onpay.success.url", this.moduleSetup.get("LMI_SUCCESS_URL")));
        this.addRequestParamPair(redirectUrl, "LMI_FAILURE_URL", this.moduleSetup.get("onpay.failure.url", this.moduleSetup.get("LMI_FAILURE_URL")));
        this.addRequestParamPair(redirectUrl, "LMI_PAYER_PHONE_NUMBER", this.moduleSetup.get("onpay.payer.phone.number", this.moduleSetup.get("LMI_PAYER_PHONE_NUMBER")));
        this.addRequestParamPair(redirectUrl, "LMI_PAYER_EMAIL", this.moduleSetup.get("onpay.payer.email", this.moduleSetup.get("LMI_PAYER_EMAIL")));
        this.setResultParam("contentType", ActionResultContentType.binary);
        this.context.getResponse().sendRedirect(redirectUrl.toString());
    }

    private void addRequestParamPair(StringBuilder request, String name, String value) throws Exception {
        if (value != null) {
            request.append(name);
            request.append("=");
            request.append(URLEncoder.encode(value, "UTF-8"));
            request.append("&");
        }
    }
}

