/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client.contract;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.Box;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.bill.common.bean.DocTypes;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.DocumentType;
import ru.bitel.bgbilling.modules.bill.common.service.BillService;
import ru.bitel.common.client.AbstractBGUPanel;

public class ContractDocTypeEditor
extends BGUPanel {
    private JPanel editorPanel = new JPanel();
    private DocumentType type;
    private BGControlPanelListSelect selectList = new BGControlPanelListSelect();
    private BGControlPanelListSelect avaliableList = new BGControlPanelListSelect();

    public ContractDocTypeEditor(boolean invoice) {
        this.editorPanel.setVisible(false);
        this.type = invoice ? DocumentType.INVOICE : DocumentType.BILL;
    }

    protected void jbInit() throws Exception {
        Dimension minDimension = new Dimension(400, 300);
        this.selectList.setBorder((Border)new TitledBorder("\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435"));
        this.selectList.setMinimumSize(minDimension);
        this.selectList.setPreferredSize(minDimension);
        this.avaliableList.setBorder((Border)new TitledBorder("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435"));
        this.avaliableList.setMinimumSize(minDimension);
        this.avaliableList.setPreferredSize(minDimension);
        BGButton addButton = new BGButton("<");
        addButton.setColumns(5);
        addButton.addActionListener(e -> this.performAction("new"));
        BGButton delButton = new BGButton(">");
        delButton.addActionListener(e -> this.performAction("delete"));
        JPanel controlPanel = new JPanel(new GridBagLayout());
        controlPanel.add(Box.createVerticalStrut(50), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        controlPanel.add((Component)addButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        controlPanel.add((Component)delButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        controlPanel.add(Box.createGlue(), new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.selectList, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(controlPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.avaliableList, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> this.tryCall(() -> {
            DocTypes docTypes = ((BillService)((ClientContext)this.getContext()).getWebService(BillService.class, ((ClientContext)this.getContext()).getModuleId())).documentTypes(((ClientContext)this.getContext()).getContractId(), this.type);
            this.selectList.getList().setData(ClientUtils.toBGUListItemList((List)docTypes.getSelectList()));
            this.avaliableList.getList().setData(ClientUtils.toBGUListItemList((List)docTypes.getAvaliableList()));
        }));
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            String selectedItems = this.avaliableList.getListValues();
            if (!selectedItems.isEmpty()) {
                Request request = new Request().setModuleId(((ClientContext)this.getContext()).getModuleId()).setModule(((ClientContext)this.getContext()).getModule()).setContractId(((ClientContext)this.getContext()).getContractId()).setAction("ContractDocTypeAdd").setAttribute("selectedItems", selectedItems);
                if (ClientUtils.checkStatus((Document)((ClientContext)this.getContext()).getDocument(request))) {
                    this.performAction("refresh");
                }
            }
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            String selectedItems = this.selectList.getListValues();
            if (selectedItems != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                Request request = new Request().setModule(((ClientContext)this.getContext()).getModule()).setAction("ContractDocTypeDelete").setContractId(((ClientContext)this.getContext()).getContractId()).setModuleId(((ClientContext)this.getContext()).getModuleId()).setAttribute("selectedItems", selectedItems);
                if (ClientUtils.checkStatus((Document)((ClientContext)this.getContext()).getDocument(request))) {
                    this.performAction("refresh");
                }
            }
        });
    }
}

