/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.card.common.bean.Dealer;
import ru.bitel.bgbilling.modules.card.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.card.server.bean.CardAction;
import ru.bitel.bgbilling.modules.card.server.bean.CardActionCardManager;
import ru.bitel.bgbilling.modules.card.server.bean.CardActionManager;
import ru.bitel.bgbilling.modules.card.server.bean.CardDao;
import ru.bitel.bgbilling.modules.card.server.bean.CardSeriesManager;
import ru.bitel.bgbilling.modules.card.server.bean.DealerDao;
import ru.bitel.common.Utils;

public class ActionCardActionUndo
extends ActionBase {
    public void doAction() throws Exception {
        int id = this.getIntParameter("id", -1);
        if (id <= 0 || this.mid <= 0) {
            throw new BGIllegalArgumentException();
        }
        CardActionManager actionManager = new CardActionManager(this.con, this.mid);
        CardActionCardManager actionCardManager = new CardActionCardManager(this.con, this.mid);
        CardDao cardManager = new CardDao(this.con, this.mid);
        CardSeriesManager seriesManager = new CardSeriesManager(this.con, this.mid);
        CardAction action = actionManager.getActionById(id);
        if (action == null) {
            throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u043f\u0440\u043e\u0432\u043e\u0434\u043a\u0430 " + id);
        }
        Dealer dealer = new DealerDao(this.con, this.mid).get(action.getDealerId());
        if (dealer == null) {
            throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0434\u0438\u043b\u0435\u0440 " + action.getDealerId());
        }
        if (!actionCardManager.checkCanUndo(action)) {
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043a\u0430\u0440\u0442\u044b \u043f\u043e\u043c\u0435\u043d\u044f\u043b\u0438 \u0441\u0442\u0430\u0442\u0443\u0441, \u043f\u0440\u043e\u0432\u043e\u0434\u043a\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430!");
        }
        List<Long> cards = actionCardManager.getCards(action.getId());
        String cardsString = Utils.toString(cards);
        Set<Integer> seriesSet = seriesManager.getCardSeries(cardsString);
        if (action.getType() == 1) {
            cardManager.updateCardStatus(cardsString, 0);
        } else {
            cardManager.updateCardStatus(cardsString, 1);
        }
        actionCardManager.updateCards(action.getId(), new ArrayList<Long>());
        actionManager.deleteAction(action.getId());
        for (int seriesId : seriesSet) {
            seriesManager.updateSeriesFree(seriesId);
        }
    }
}

