/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.fias.server.service;

import jakarta.jws.WebService;
import java.sql.Connection;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.plugins.fias.common.bean.bgbean.FiasCity;
import ru.bitel.bgbilling.plugins.fias.common.bean.bgbean.FiasStreet;
import ru.bitel.bgbilling.plugins.fias.common.service.FiasSyncService;
import ru.bitel.bgbilling.plugins.fias.server.bean.AddressLoadManager;
import ru.bitel.bgbilling.plugins.fias.server.bean.HouseLoadManager;
import ru.bitel.bgbilling.plugins.fias.server.util.FiasUtil;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Result;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.fias.common.service.FiasSyncService")
public class FiasSyncServiceImpl
extends AbstractService
implements FiasSyncService {
    private AddressLoadManager getFiasAddressManager(Connection con) {
        return new AddressLoadManager(con);
    }

    public Result<FiasCity> getCityList() throws BGException {
        AddressLoadManager fm = this.getFiasAddressManager(this.getConnection());
        List<FiasCity> list = fm.getCityList();
        return new Result(list);
    }

    public void syncCity(List<FiasCity> citys) throws BGException {
        this.tryCall(() -> {
            FiasUtil.syncCityList(citys);
            AddressLoadManager lm = new AddressLoadManager(this.getConnection());
            lm.clearFiasTable();
            for (FiasCity city : citys) {
                if (Utils.isEmptyString((String)city.getAoguid())) continue;
                lm.updateCity(city);
            }
        });
    }

    public void changeBillingCityName(int cityId, String name) throws BGException {
        AddressLoadManager lm = new AddressLoadManager(this.getConnection());
        lm.updateCityBgTitle(cityId, name);
    }

    public void syncStreet(List<FiasStreet> streets) throws BGException {
        this.tryCall(() -> {
            FiasUtil.syncStreetList(streets);
            AddressLoadManager lm = new AddressLoadManager(this.getConnection());
            lm.clearFiasTable();
            for (FiasStreet street : streets) {
                lm.updateStreet(street);
            }
        });
    }

    public void changeBillingStreetName(List<FiasStreet> streets) throws BGException {
        AddressLoadManager lm = new AddressLoadManager(this.getConnection());
        lm.updateStreetBgTitle(streets);
    }

    public Result<FiasStreet> getStreetList(FiasCity city) throws BGException {
        return (Result)this.tryReturn(() -> {
            AddressLoadManager fm = this.getFiasAddressManager(this.getConnection());
            List<FiasStreet> list = fm.getStreetList(city);
            return new Result(list);
        });
    }

    public void syncHouse(List<FiasCity> citys, boolean loadNew) throws BGMessageException, BGException {
        this.tryCall(() -> {
            Connection con = this.getConnection();
            try {
                con.setAutoCommit(true);
            }
            catch (Exception ex) {
                this.logError(ex);
            }
            HouseLoadManager manager = new HouseLoadManager(con);
            manager.syncHouse(citys, loadNew);
        });
    }
}

