/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.directory;

import bitel.billing.module.admin.TransferManager;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.bushe.swing.event.EventBus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.label.common.service.ContractLabelService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;

public class ContractGroupEditor
extends BGUPanel {
    private BGButton syncDirectoryContractLabelAngGroup = new BGButton("\u0421\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0438 \u043c\u0435\u0442\u043e\u043a \u0438 \u0433\u0440\u0443\u043f\u043f");
    private BGButton syncContractLabelAngGroup = new BGButton("\u0421\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043c\u0435\u0442\u043a\u0438 \u0438 \u0433\u0440\u0443\u043f\u043f\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432");
    private JCheckBox contractsBox = new JCheckBox("\u0440\u0430\u0441\u0441\u0447\u0438\u0442\u044b\u0432\u0430\u0442\u044c \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432");
    private BGUTable table;
    private ContractGroupTableModel tableModel;
    private JLabel groupMaskLabel = new JLabel();
    private JButton copyToClipboardButton = new JButton("\u0421\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432 \u0431\u0443\u0444\u0435\u0440 \u043e\u0431\u043c\u0435\u043d\u0430");
    private long groupMask = 0L;

    public ContractGroupEditor() {
        this.tableModel = new ContractGroupTableModel(ContractGroupEditor.class.getName());
    }

    @Override
    protected void jbInit() throws Exception {
        JPanel groupMaskPanel = new JPanel(new FlowLayout());
        groupMaskPanel.add(this.groupMaskLabel);
        groupMaskPanel.add(this.copyToClipboardButton);
        groupMaskPanel.setVisible(false);
        this.table = new BGUTable(this.tableModel);
        this.table.setSelectionMode(2);
        this.table.getSelectionModel().addListSelectionListener(e -> {
            List selected = this.tableModel.getSelectedRows();
            List selectedGroupIds = selected.stream().map(elem -> Integer.valueOf(elem.getAttribute("f0"))).collect(Collectors.toList());
            this.groupMask = Utils.enumToMask(Utils.toString(selectedGroupIds));
            this.groupMaskLabel.setText("\u0411\u0438\u0442\u043e\u0432\u0430\u044f \u043c\u0430\u0441\u043a\u0430 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0445 \u0433\u0440\u0443\u043f\u043f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0440\u0430\u0432\u043d\u0430 " + this.groupMask);
            groupMaskPanel.setVisible(true);
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (SwingUtilities.isLeftMouseButton(event) && event.getClickCount() == 2) {
                    ContractGroupEditor.this.performAction("editItem");
                }
            }

            @Override
            public void mousePressed(MouseEvent event) {
                if (SwingUtilities.isRightMouseButton(event) && ContractGroupEditor.this.table.getSelectedRow() == ContractGroupEditor.this.table.rowAtPoint(event.getPoint())) {
                    ContractGroupEditor.this.getPopupMenu().show(ContractGroupEditor.this.table, event.getX(), event.getY());
                }
            }
        });
        this.table.enableSearchField();
        this.copyToClipboardButton.addActionListener(e -> {
            StringSelection selection = new StringSelection(String.valueOf(this.groupMask));
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(selection, null);
            BGToolTip.showMessage(this.copyToClipboardButton, "\u0411\u0438\u0442\u043e\u0432\u0430\u044f \u043c\u0430\u0441\u043a\u0430 \u0433\u0440\u0443\u043f\u043f \u0441\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0430 \u0432 \u0431\u0443\u0444\u0435\u0440 \u043e\u0431\u043c\u0435\u043d\u0430!");
        });
        this.contractsBox.addChangeListener(e -> {
            if (this.table.isEnabled()) {
                this.performAction("refresh");
            }
        });
        this.syncContractLabelAngGroup.addActionListener(e -> this.tryCall(() -> ((ClientContext)this.getContext()).getPort(ContractLabelService.class).syncLabelAndGroupContract(0)));
        this.syncDirectoryContractLabelAngGroup.addActionListener(e -> this.tryCall(() -> ((ClientContext)this.getContext()).getPort(ContractLabelService.class).syncLabelAndGroupDirectory()));
        JPanel controlPanel = new JPanel(new GridBagLayout());
        controlPanel.add((Component)this.syncContractLabelAngGroup, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        controlPanel.add((Component)this.syncDirectoryContractLabelAngGroup, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        controlPanel.add((Component)this.contractsBox, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        JPanel groupListPanel = new JPanel(new GridBagLayout());
        groupListPanel.setBorder(new BGTitleBorder(" \u0413\u0440\u0443\u043f\u043f\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 "));
        groupListPanel.add((Component)controlPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        groupListPanel.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        groupListPanel.add((Component)groupMaskPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)groupListPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> {
            Request request = new Request().setModule(((ClientContext)this.getContext()).getModule()).setAction("GetContractGroupList").setAttribute("contracts", this.contractsBox.isSelected());
            Document doc = TransferManager.getDocument(request);
            if (ClientUtils.checkStatus(doc)) {
                int row = this.table.getSelectedRow();
                ArrayList<Element> list = new ArrayList<Element>();
                for (Element element : XMLUtils.selectElements(doc, "//table/data/row")) {
                    list.add(element);
                }
                this.tableModel.setData(list, true);
                if (row > -1) {
                    this.table.setRowSelectionInterval(row, row);
                }
            }
        });
        (AbstractBGUPanel)this.new AbstractBGUPanel.BGDefaultAction("editItem", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c", e -> this.tableModel.optSelectedRow().ifPresentOrElse(rowElement -> new ContractGroupEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0433\u0440\u0443\u043f\u043f\u044b", (Element)rowElement).open(), () -> ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f!")));
    }

    @Override
    protected JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            JMenuItem addItem = new JMenuItem("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0443 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432");
            addItem.addActionListener(e -> this.deleteItem());
            this.popupMenu.add(addItem);
        }
        return this.popupMenu;
    }

    public void deleteItem() {
        if (this.tableModel.getSelectedRow() == null) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
        } else if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0413\u0440\u0443\u043f\u043f\u0430 \u0431\u0443\u0434\u0435\u0442 \u0443\u0434\u0430\u043b\u0435\u043d\u0430 \u0438\u0437 \u0432\u0441\u0435\u0445 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432. \u0423\u0434\u0430\u043b\u0438\u0442\u044c?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            Request request = new Request();
            request.setModule(((ClientContext)this.getContext()).getModule());
            request.setAction("DeleteContractGroup");
            request.setAttribute("groups", ((Element)this.tableModel.getSelectedRow()).getAttribute("f0"));
            ClientUtils.checkStatus(TransferManager.getDocument(request));
        }
    }

    class ContractGroupTableModel
    extends BGTableModel<Element> {
        public ContractGroupTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumn("ID", 50, 50, 50, "f0", true, DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u0410\u043a\u0442\u0438\u0432\u043d\u0430", Boolean.class, 80, 80, 80, "f1", true);
            this.addColumn("\u041f\u0440\u0430\u0432\u043a\u0430", Boolean.class, 80, 80, 80, "f3", true);
            this.addColumn("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435", 200, 250, 500, "f2", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "f4", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432", 100, 100, 100, "f5", true, DecimalTableCellRenderer.INTEGER());
        }

        @Override
        public Object getValue(Element value, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            if ("f0".equals(identifier)) {
                return Integer.valueOf(value.getAttribute("f0"));
            }
            if ("f1".equals(identifier)) {
                return Boolean.valueOf(value.getAttribute("f1"));
            }
            if ("f3".equals(identifier)) {
                return Boolean.valueOf(value.getAttribute("f3"));
            }
            if ("f5".equals(identifier)) {
                return Integer.valueOf(value.getAttribute("f5"));
            }
            return super.getValue(value, column);
        }
    }

    class ContractGroupEditorDialog
    extends BGEditorDialog<Element> {
        private String id;
        private JTextField groupTitle;
        private JTextField groupComment;
        private JCheckBox editableBox;
        private JCheckBox usedBox;

        public ContractGroupEditorDialog(String title, Element data) {
            super(title, data);
            this.id = "0";
            this.groupTitle = new JTextField(30);
            this.groupComment = new JTextField(30);
            this.editableBox = new JCheckBox("\u043f\u0440\u0430\u0432\u043a\u0430");
            this.usedBox = new JCheckBox("\u0430\u043a\u0442\u0438\u0432\u043d\u0430");
        }

        @Override
        public void doDialogPanel() {
            int index = 0;
            int top = 5;
            this.panel.add((Component)new JLabel("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, index, 1, 1, 0.0, 0.0, 13, 0, new Insets(top, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.groupTitle, new GridBagConstraints(1, index++, 1, 1, 1.0, 0.0, 10, 1, new Insets(top, 5, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, index, 1, 1, 0.0, 0.0, 13, 0, new Insets(top, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.groupComment, new GridBagConstraints(1, index++, 1, 1, 1.0, 0.0, 10, 1, new Insets(top, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.getUseEditPanel(), new GridBagConstraints(1, index++, 1, 1, 0.0, 0.0, 17, 0, new Insets(top, 5, 20, 0), 0, 0));
            this.id = ((Element)this.data).getAttribute("f0");
            this.groupTitle.setText(((Element)this.data).getAttribute("f2"));
            this.groupComment.setText(((Element)this.data).getAttribute("f4"));
            this.editableBox.setSelected(Boolean.valueOf(((Element)this.data).getAttribute("f3")));
            this.usedBox.setSelected(Boolean.valueOf(((Element)this.data).getAttribute("f1")));
        }

        private JPanel getUseEditPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.usedBox, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.editableBox, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
            return panel;
        }

        @Override
        public boolean doApply() throws Exception {
            if (this.groupTitle.getText().trim().length() == 0) {
                BGToolTip.showErrorMessage(this.groupTitle, "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435");
                return false;
            }
            Request request = new Request();
            request.setModule(((ClientContext)ContractGroupEditor.this.getContext()).getModule());
            request.setAction("UpdateContractGroup");
            request.setAttribute("id", this.id);
            request.setAttribute("title", this.groupTitle.getText().trim());
            request.setAttribute("enable", this.usedBox.isSelected() ? 1 : 0);
            request.setAttribute("editable", this.editableBox.isSelected() ? 1 : 0);
            request.setAttribute("comment", this.groupComment.getText().trim());
            if (ClientUtils.checkStatus(TransferManager.getDocument(request))) {
                ContractGroupEditor.this.performAction("refresh");
                EventBus.publish((Object)new UpdateContractTreeEvent(((ClientContext)ContractGroupEditor.this.getContext()).getModuleId(), ((ClientContext)ContractGroupEditor.this.getContext()).getContractId()));
            }
            return true;
        }
    }
}

