/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mobile.server;

import bitel.billing.server.ModuleBase;
import java.math.BigDecimal;
import java.sql.Connection;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ChargeType;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentType;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ChargeEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.ContractStatusChangedEvent;
import ru.bitel.bgbilling.kernel.event.events.system.HelpDeskMessageForContractEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.modules.mobile.common.bean.MobileContractNotification;
import ru.bitel.bgbilling.modules.mobile.common.service.MobileService;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

public class Module
extends ModuleBase
implements EventListener<Event> {
    private static final String[] PACKAGES = new String[]{"ru.bitel.bgbilling.modules.mobile.server"};
    private final Set<Integer> moduleIds = new HashSet<Integer>(8);

    public String[] getServerPackages() {
        return PACKAGES;
    }

    public void moduleAction(ServerContext ctx, int mid, Event event) throws Exception {
        System.out.println(event.getContractId() + "  " + event.getClass().getCanonicalName());
    }

    public void start(Connection con, BGModule module) throws Exception {
        boolean firstCall = this.moduleIds.size() == 0;
        this.moduleIds.add(module.getId());
        super.start(con, module);
        if (firstCall) {
            EventProcessor ep = EventProcessor.getInstance();
            ep.addListener((EventListener)this, PaymentEvent.class);
            ep.addListener((EventListener)this, ChargeEvent.class);
            ep.addListener((EventListener)this, ContractStatusChangedEvent.class);
            ep.addListener((EventListener)this, HelpDeskMessageForContractEvent.class);
        }
    }

    public void notify(Event ev, EventListenerContext ctx) throws Exception {
        Object text = null;
        boolean storable = true;
        int contractId = ev.getContractId();
        Contract contract = null;
        Set moduleSet = ContractRuntimeMap.getInstance().getContractRuntime(ctx.getConnection(), Integer.valueOf(contractId)).getModuleIds();
        for (Integer moduleId : this.moduleIds) {
            if (!moduleSet.contains(moduleId)) continue;
            if (contract == null) {
                contract = ContractDao.getContract((Connection)ctx.getConnection(), (int)contractId);
            }
            if (contract == null) {
                this.getLogger().error("Contract not found!");
                return;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(moduleId);
            Long groupMask = moduleSetup.getLong("push.notification.allow.groupMask", 0L);
            if (groupMask != 0L && (contract.getGroups() & groupMask) == 0L) continue;
            if (ev instanceof PaymentEvent || ev instanceof ChargeEvent || ev instanceof ContractStatusChangedEvent) {
                BigDecimal sum = null;
                params.put("menuItem", "balance");
                if (ev instanceof PaymentEvent) {
                    PaymentType type;
                    if (!moduleSetup.getBoolean("push.notification.payment", false)) continue;
                    event = (PaymentEvent)ev;
                    if (event.isEditMode() || event.getPayment().getSum().compareTo(BigDecimal.ZERO) <= 0) {
                        return;
                    }
                    List ids = moduleSetup.getIntegerList("push.notification.payment.allow.ids", null);
                    if (ids != null && !ids.contains(event.getPayment().getTypeId())) continue;
                    text = moduleSetup.get("push.notification.payment.text", "\u0411\u0430\u043b\u0430\u043d\u0441 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 @contractTitle \u0431\u044b\u043b \u043f\u043e\u043f\u043e\u043b\u043d\u0435\u043d \u043d\u0430 @sum\u20bd. \u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0431\u0430\u043b\u0430\u043d\u0441: @balance\u20bd.");
                    sum = event.getPayment().getSum();
                    if (((String)text).indexOf("@type") >= 0 && (type = (PaymentType)ctx.getDirectory(PaymentType.class, 0).get(event.getPayment().getTypeId())) != null) {
                        text = ((String)text).replaceAll("@type", type.getTitle());
                    }
                } else if (ev instanceof ChargeEvent) {
                    ChargeType type;
                    if (!moduleSetup.getBoolean("push.notification.charge", false)) continue;
                    event = (ChargeEvent)ev;
                    if (event.isEditMode() || event.getCharge().getSum().compareTo(BigDecimal.ZERO) <= 0) {
                        return;
                    }
                    List ids = moduleSetup.getIntegerList("push.notification.charge.allow.ids", null);
                    if (ids != null && !ids.contains(event.getCharge().getTypeId())) continue;
                    String defChargeText = "\u0421\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0441 \u0431\u0430\u043b\u0430\u043d\u0441\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 @contractTitle \u0432 \u0440\u0430\u0437\u043c\u0435\u0440\u0435 @sum\u20bd. \u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0431\u0430\u043b\u0430\u043d\u0441: @balance\u20bd.";
                    String defPaybackText = "\u041f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435 @contractTitle \u0432 \u0440\u0430\u0437\u043c\u0435\u0440\u0435 @sum \u20bd. \u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0431\u0430\u043b\u0430\u043d\u0441: @balance\u20bd.";
                    text = event.getCharge().isPayback() ? moduleSetup.get("push.notification.payback.text", defPaybackText) : moduleSetup.get("push.notification.charge.text", defChargeText);
                    sum = event.getCharge().getSum();
                    if (((String)text).indexOf("@type") >= 0 && (type = (ChargeType)ctx.getDirectory(ChargeType.class, 0).get(event.getCharge().getTypeId())) != null) {
                        text = ((String)text).replaceAll("@type", type.getTitle());
                    }
                } else if (ev instanceof ContractStatusChangedEvent) {
                    Set userIds;
                    String users;
                    if (!moduleSetup.getBoolean("push.notification.status.change", false)) continue;
                    event = (ContractStatusChangedEvent)ev;
                    int statusCode = event.getStatus().getStatus();
                    List ids = moduleSetup.getIntegerList("push.notification.status.change.allow.codes", null);
                    if (ids != null && !ids.contains(statusCode) || Utils.notBlankString((String)(users = moduleSetup.get("push.notification.status.change.allow.users", null))) && ("onlyManagers".equals(users) ? event.getUserId() < 1 : !(userIds = Utils.toIntegerSet((String)users)).contains(event.getUserId()))) continue;
                    text = moduleSetup.get("push.notification.status.change.text", "\u0414\u043e\u0433\u043e\u0432\u043e\u0440 @contractTitle: \u0431\u044b\u043b \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0441\u0442\u0430\u0442\u0443\u0441 - @status.");
                    text = moduleSetup.get("push.notification.status.change." + statusCode + ".text", (String)text);
                    StatusCache statusCache = StatusCache.getInstance();
                    text = ((String)text).replaceAll("@status", statusCache.getStatusTitle(statusCode));
                    params.put("menuItem", "status");
                }
                params.put("action", "ContractUpdate");
                try (BalanceUtils bu = new BalanceUtils(ctx.getConnection());){
                    String balance = Utils.formatCostByGrouping((BigDecimal)bu.getBalance(LocalDate.now(), contractId), (int)3, (int)2);
                    text = ((String)text).replaceAll("@balance", balance);
                }
                text = ((String)text).replaceAll("@contractTitle", contract.getTitle());
                if (sum != null) {
                    text = ((String)text).replaceAll("@sum", Utils.formatCostByGrouping((BigDecimal)sum, (int)3, (int)2));
                }
            } else if (ev instanceof HelpDeskMessageForContractEvent) {
                HelpDeskMessageForContractEvent event = (HelpDeskMessageForContractEvent)ev;
                text = event.getMsgTitle();
                if (Utils.notBlankString((String)event.getBody())) {
                    text = (String)text + " " + (event.getBody().length() > 50 ? event.getBody().substring(0, 50) : event.getBody());
                }
                storable = false;
                params.put("menuItem", "helpDesk");
                params.put("messageId", String.valueOf(event.getMessageId()));
                params.put("topicId", String.valueOf(event.getTopicId()));
            }
            if (Utils.isBlankString(text)) continue;
            MobileService mobileService = (MobileService)ctx.getService(MobileService.class, moduleId.intValue());
            try {
                mobileService.sendPushNotification(new MobileContractNotification().setContractId(contractId).setStorable(storable).setText((String)text).setParams(params));
            }
            catch (Exception e2) {
                if (e2 instanceof BGMessageException) {
                    return;
                }
                if (e2 instanceof BGException && "contractNotPossibleSend".equals(((BGException)e2).getTag())) {
                    return;
                }
                this.getLogger().error(e2.getMessage(), (Throwable)e2);
            }
        }
    }
}

