/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.collector;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.flow.FlowArray;
import ru.bitel.bgbilling.kernel.network.flow.FlowPacket;
import ru.bitel.bgbilling.kernel.network.flow.NetFlow9Template;
import ru.bitel.bgbilling.modules.inet.server.collector.FlowListenerWorkerContext;
import ru.bitel.bgbilling.modules.inet.server.collector.FlowListenerWorkerNetFlow9;
import ru.bitel.bgbilling.modules.inet.server.collector.InetFlowListener;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.worker.ThreadContextFactory;

final class InetFlow9Listener
extends InetFlowListener {
    private static final Logger logger = LogManager.getLogger();
    public final ConcurrentMap<Integer, NetFlow9Template> templates;

    public InetFlow9Listener(Setup setup, String host, int port, int threadCount, int byteBufferCapacity, int socketRCVBUF, ThreadContextFactory<FlowListenerWorkerContext<? extends FlowArray<?>>> contextFactory, ConcurrentMap<Integer, NetFlow9Template> templates) {
        super(setup, host, port, threadCount, byteBufferCapacity, socketRCVBUF, contextFactory);
        this.templates = templates;
    }

    @Override
    public void start() throws Exception {
        try {
            File stateFile = new File("data/state");
            stateFile = new File(stateFile, "netflow9." + this.port + ".templates.ser");
            if (stateFile.exists()) {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(stateFile));
                Map map = (Map)in.readObject();
                in.close();
                for (Map.Entry e : map.entrySet()) {
                    this.templates.putIfAbsent((Integer)e.getKey(), (NetFlow9Template)e.getValue());
                }
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        super.start();
    }

    @Override
    public void stop() throws Exception {
        try {
            File stateFile = new File("data/state");
            stateFile.mkdirs();
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(new File(stateFile, "netflow9." + this.port + ".templates.ser")));
            out.writeObject(new HashMap<Integer, NetFlow9Template>(this.templates));
            out.flush();
            out.close();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        super.stop();
    }

    @Override
    public void flush(long millis, List<FlowPacket> packetList, int overloadLevel) {
        super.updateStat(millis, packetList);
        if (overloadLevel > 2) {
            this.fallbackExecutorService.execute((Runnable)((Object)new FlowListenerWorkerNetFlow9(millis, packetList, overloadLevel, this.templates)));
        } else {
            this.executorService.execute((Runnable)((Object)new FlowListenerWorkerNetFlow9(millis, packetList, overloadLevel, this.templates)));
        }
    }
}

