/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.wm.server.bean;

import jakarta.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public final class WMRequest
extends BGLogger {
    private Preferences moduleSetup;
    private boolean prerequest;
    private String lmi_PAYEE_PURSE;
    private String lmi_PAYMENT_NO;
    private String lmi_MODE;
    private String lmi_SYS_INVS_NO;
    private String lmi_SYS_TRANS_NO;
    private String lmi_SYS_TRANS_DATE;
    private String lmi_SECRETKEY;
    private String lmi_PAYER_PURSE;
    private String lmi_PAYER_WM;
    private String lmi_LMI_PREREQUEST;
    private String lmi_PAYMENT_AMOUNT;
    private String lmi_HASH;
    private BigDecimal paymentAmount;
    private int paymentNo;
    private int mode;

    public String getLmi_LMI_PREREQUEST() {
        return this.lmi_LMI_PREREQUEST;
    }

    public String getLmi_PAYEE_PURSE() {
        return this.lmi_PAYEE_PURSE;
    }

    public String getLmi_PAYER_PURSE() {
        return this.lmi_PAYER_PURSE;
    }

    public String getLmi_PAYER_WM() {
        return this.lmi_PAYER_WM;
    }

    public String getLmi_SECRETKEY() {
        return this.lmi_SECRETKEY;
    }

    public String getLmi_SYS_INVS_NO() {
        return this.lmi_SYS_INVS_NO;
    }

    public String getLmi_SYS_TRANS_DATE() {
        return this.lmi_SYS_TRANS_DATE;
    }

    public String getLmi_SYS_TRANS_NO() {
        return this.lmi_SYS_TRANS_NO;
    }

    public static WMRequest loadRequest(Preferences moduleSetup, HttpServletRequest request) {
        WMRequest result = new WMRequest();
        result.moduleSetup = moduleSetup;
        result.lmi_LMI_PREREQUEST = request.getParameter("LMI_PREREQUEST");
        result.lmi_PAYEE_PURSE = request.getParameter("LMI_PAYEE_PURSE");
        result.lmi_PAYMENT_NO = request.getParameter("LMI_PAYMENT_NO");
        result.lmi_MODE = request.getParameter("LMI_MODE");
        result.lmi_SYS_INVS_NO = request.getParameter("LMI_SYS_INVS_NO");
        result.lmi_SYS_TRANS_NO = request.getParameter("LMI_SYS_TRANS_NO");
        result.lmi_SYS_TRANS_DATE = request.getParameter("LMI_SYS_TRANS_DATE");
        result.lmi_SECRETKEY = request.getParameter("LMI_SECRETKEY");
        result.lmi_PAYER_PURSE = request.getParameter("LMI_PAYER_PURSE");
        result.lmi_PAYER_WM = request.getParameter("LMI_PAYER_WM");
        result.lmi_PAYMENT_AMOUNT = request.getParameter("LMI_PAYMENT_AMOUNT");
        result.lmi_HASH = request.getParameter("LMI_HASH");
        result.prerequest = result.lmi_LMI_PREREQUEST != null;
        result.mode = Utils.parseInt((String)request.getParameter("LMI_MODE"), (int)-1);
        result.paymentNo = Utils.parseInt((String)request.getParameter("LMI_PAYMENT_NO"), (int)-1);
        result.paymentAmount = Utils.parseBigDecimal((String)request.getParameter("LMI_PAYMENT_AMOUNT"), (BigDecimal)BigDecimal.ONE.negate());
        if (result.checkAllParams()) {
            return result;
        }
        return null;
    }

    private boolean checkAllParams() {
        boolean result = true;
        if (!(this.prerequest || this.lmi_HASH != null && this.lmi_PAYEE_PURSE != null && this.lmi_SYS_INVS_NO != null && this.lmi_SYS_TRANS_NO != null && this.lmi_SYS_TRANS_DATE != null && this.lmi_PAYER_PURSE != null)) {
            result = false;
        }
        if (this.lmi_PAYMENT_NO == null || this.paymentNo <= 0 || this.lmi_MODE == null || this.lmi_PAYER_WM == null || this.lmi_PAYMENT_AMOUNT == null || this.paymentAmount.compareTo(BigDecimal.ZERO) <= 0) {
            result = false;
        }
        return result;
    }

    public boolean checkHash() {
        boolean result = false;
        if (!this.prerequest) {
            String digestType;
            String buffer = this.lmi_PAYEE_PURSE + this.lmi_PAYMENT_AMOUNT + this.lmi_PAYMENT_NO + this.lmi_MODE + this.lmi_SYS_INVS_NO + this.lmi_SYS_TRANS_NO + this.lmi_SYS_TRANS_DATE + this.moduleSetup.get("wm.secret", "") + this.lmi_PAYER_PURSE + this.lmi_PAYER_WM;
            String hash = Utils.getDigest((String)buffer, (String)"UTF-8", (String)(digestType = this.moduleSetup.get("wm.digest.type", "SHA-256")));
            if (hash.equals(this.lmi_HASH)) {
                result = true;
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("digestType = " + digestType);
                this.getLogger().debug("String for HASH = " + buffer);
                this.getLogger().debug("HASH calculate = " + hash);
                this.getLogger().debug("HASH from request = " + this.lmi_HASH);
                this.getLogger().debug("HASH compare result = " + result);
            }
        }
        return result;
    }

    public boolean checkRecieverPurse() {
        boolean result = false;
        String purse = this.moduleSetup.get("wm.payee.purse", "");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("purse from config = " + purse);
            this.getLogger().debug("purse from request = " + this.lmi_PAYEE_PURSE);
        }
        if (!Utils.isEmptyString((String)purse) && purse.equals(this.lmi_PAYEE_PURSE)) {
            result = true;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("checkRecieverPurse() = " + result);
        }
        return result;
    }

    public boolean isPrerequest() {
        return this.prerequest;
    }

    public void setPrerequest(boolean prerequest) {
        this.prerequest = prerequest;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public BigDecimal getPaymentAmount() {
        return this.paymentAmount;
    }

    public void setPaymentAmount(BigDecimal paymentAmount) {
        this.paymentAmount = paymentAmount;
    }

    public int getPaymentNo() {
        return this.paymentNo;
    }

    public void setPaymentNo(int paymentNo) {
        this.paymentNo = paymentNo;
    }
}

