/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.ws.server;

import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.InstanceResolver;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WSWebServiceContext;
import com.sun.xml.ws.server.AbstractMultiInstanceResolver;
import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import com.sun.xml.ws.transport.http.servlet.ServletAdapterList;
import jakarta.annotation.Resource;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.xml.ws.Provider;
import jakarta.xml.ws.WebServiceContext;
import jakarta.xml.ws.handler.MessageContext;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.service.server.ServiceInfo;
import ru.bitel.bgbilling.kernel.container.ws.server.JaxWSAdapter;
import ru.bitel.bgbilling.kernel.container.ws.server.ModuleKey;
import ru.bitel.bgbilling.kernel.dynamic.server.event.ScriptUpdatedEvent;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.system.ModuleConfigModifiedEvent;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.worker.ThreadContext;

public abstract class AbstractJaxWsHandler
extends JaxWSAdapter {
    protected final Setup setup;
    protected final boolean loggingEnabled;
    private ServletAdapterList adapterFactory;
    private Map<ModuleKey, ServletAdapter> adapterMap = new ConcurrentHashMap<ModuleKey, ServletAdapter>();
    protected static final Pattern patternSlash = Pattern.compile("/");

    public AbstractJaxWsHandler(ServletContext context) throws BGException {
        super(context);
        this.setup = Setup.getSetup();
        this.adapterFactory = new ServletAdapterList(context);
        String loggingEnabledParam = this.getLoggingEnabledParam();
        if (loggingEnabledParam == null) {
            loggingEnabledParam = "ws.log";
        }
        EventProcessor.getInstance().addListener(new EventListener<ScriptUpdatedEvent>(){

            @Override
            public void notify(ScriptUpdatedEvent e, EventListenerContext ctx) throws BGException {
                AbstractJaxWsHandler.this.clear();
            }
        }, ScriptUpdatedEvent.class);
        EventProcessor.getInstance().addListener(new EventListener<ModuleConfigModifiedEvent>(){

            @Override
            public void notify(ModuleConfigModifiedEvent e, EventListenerContext ctx) {
                if (e.getModuleId() == 0) {
                    AbstractJaxWsHandler.this.clear();
                }
            }
        }, ModuleConfigModifiedEvent.class);
        this.loggingEnabled = this.setup.getInt(loggingEnabledParam, this.setup.getInt("ws.log", 0)) > 0;
        Logger logger = LogManager.getLogger((String)"com.sun.xml.ws.server.sei.EndpointMethodHandler");
        Configurator.setLevel((String)logger.getName(), (Level)Level.OFF);
    }

    @Override
    protected ServletAdapter getTarget(String pathInfo, HttpServletRequest request) {
        ModuleKey moduleKey = this.getModuleKey(pathInfo);
        if (moduleKey != null) {
            return this.getTarget(moduleKey);
        }
        return null;
    }

    @Override
    protected ModuleKey getModuleKey(String pathInfo) {
        if (pathInfo != null) {
            String[] params = patternSlash.split(pathInfo);
            if (params.length >= 4) {
                String module = params[1];
                int mid = Utils.parseInt(params[2]);
                String service = params[3];
                return new ModuleKey(module, mid, service);
            }
            if (params.length >= 3) {
                String module = params[1];
                String service = params[2];
                return new ModuleKey(module, 0, service);
            }
        }
        return null;
    }

    protected abstract Class<?> findEndpointClass(ModuleKey var1);

    protected abstract String getUrlPatternName(ModuleKey var1, Class<?> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServletAdapter getTarget(ModuleKey moduleKey) {
        if (moduleKey.service != null && moduleKey.service.contains(".")) {
            return null;
        }
        ServletAdapter target = this.adapterMap.get(moduleKey);
        if (target == null && !this.adapterMap.containsKey(moduleKey)) {
            Class<?> implementorClass = this.findEndpointClass(moduleKey);
            this.getLogger().debug("getTarget: implementorClass = {}", implementorClass);
            if (implementorClass != null) {
                AbstractJaxWsHandler abstractJaxWsHandler = this;
                synchronized (abstractJaxWsHandler) {
                    target = (ServletAdapter)this.adapterFactory.createAdapter(moduleKey.service, this.getUrlPatternName(moduleKey, implementorClass), this.createWsEndpoint(implementorClass));
                }
                if (target == null) {
                    this.getLogger().warn("getTarget: Target not found for {} (but class exist)", (Object)moduleKey);
                }
            } else {
                this.getLogger().warn("getTarget: Class not found for {}", (Object)moduleKey);
            }
            this.getLogger().debug("getTarget: moduleKey = {}; target = {}", (Object)moduleKey, (Object)target);
            if (target != null) {
                this.adapterMap.put(moduleKey, target);
            }
        }
        return target;
    }

    protected void inject(Object t, WebServiceContext wsc, MessageContext mc) throws IllegalArgumentException, IllegalAccessException {
        for (Class<?> clazz = t.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field f : clazz.getDeclaredFields()) {
                Class<?> resourceClass;
                Resource r = f.getAnnotation(Resource.class);
                if (r == null) continue;
                Class<?> clazz2 = resourceClass = r.type() != Object.class ? r.type() : f.getType();
                if (WebServiceContext.class.isAssignableFrom(resourceClass)) {
                    if (!f.isAccessible() && (f.getModifiers() & 1) == 0) {
                        f.setAccessible(true);
                    }
                    f.set(t, wsc);
                    continue;
                }
                if (!ServletContext.class.isAssignableFrom(resourceClass)) continue;
                if (!f.isAccessible() && (f.getModifiers() & 1) == 0) {
                    f.setAccessible(true);
                }
                f.set(t, mc.get((Object)"jakarta.xml.ws.servlet.context"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        AbstractJaxWsHandler abstractJaxWsHandler = this;
        synchronized (abstractJaxWsHandler) {
            this.adapterMap.clear();
            this.servletContainer.getModule().getBoundEndpoints().clear();
            this.adapterFactory = new ServletAdapterList(this.servletContext);
        }
    }

    protected <T> Object invoke(String module, String midString, Integer userId, InstanceResolver<T> resolver, Class<T> clazz, WebServiceContext wsc, MessageContext mc, Packet p, Method m, Object[] args) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException {
        return this.invoke0(module, midString, userId, resolver, clazz, wsc, mc, p, m, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Object invoke0(String module, String midString, Integer userId, InstanceResolver<T> resolver, Class<T> clazz, WebServiceContext wsc, MessageContext mc, Packet p, Method m, Object[] args) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException {
        Object object;
        Object parent;
        block8: {
            int mid = Utils.parseInt(midString, 0);
            Object t = resolver.resolve(p);
            ServiceInfo<T> helper = ServiceInfo.getServiceHelper(clazz);
            long time = System.currentTimeMillis();
            this.inject(t, wsc, mc);
            parent = ThreadContext.get();
            ServerContext ctx = null;
            try {
                ctx = new ServerContext(this.setup, mid, userId);
                ctx.init();
                ThreadContext.set(ctx);
                Object result = helper.invoke(ctx, this.setup, t, m, args, mid, userId);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("executing " + clazz.getName() + "." + m.getName() + "; time => " + (System.currentTimeMillis() - time) + " ms.");
                }
                object = result;
                if (ctx == null) break block8;
                ctx.destroy();
            }
            catch (Throwable throwable) {
                try {
                    if (ctx != null) {
                        ctx.destroy();
                    }
                    ThreadContext.set(parent);
                    throw throwable;
                }
                catch (InvocationTargetException ex) {
                    Throwable cause = ex.getCause();
                    if (!(cause instanceof BGMessageException)) {
                        this.logError("error executing " + clazz.getName() + "." + m.getName(), ex);
                    }
                    throw ex;
                }
            }
        }
        ThreadContext.set(parent);
        return object;
    }

    protected <T> Object invoke(final String module, final String mid, Integer userId, final InstanceResolver<T> resolver, final Class<T> clazz, final WebServiceContext wsc, final MessageContext mc, final Packet p, final Method m, final Object[] args, Subject subject) throws InvocationTargetException {
        try {
            final int userId_ = userId;
            return Subject.doAs(subject, new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return AbstractJaxWsHandler.this.invoke0(module, mid, userId_, resolver, clazz, wsc, mc, p, m, args);
                }
            });
        }
        catch (PrivilegedActionException e) {
            InvocationTargetException invocationTargetException = (InvocationTargetException)e.getCause();
            if (!invocationTargetException.getCause().getClass().equals(Exception.class)) {
                throw new InvocationTargetException(new Exception(invocationTargetException.getCause()));
            }
            throw invocationTargetException;
        }
    }

    @Override
    protected <T> InstanceResolver<T> createInstanceResolver(Class<T> clazz) {
        InstanceResolver<T> i = AbstractJaxWsHandler.createFromInstanceResolverAnnotation(clazz);
        if (i == null) {
            return new ServiceInstanceResolver<T>(clazz);
        }
        return i;
    }

    protected String getLoggingEnabledParam() {
        return null;
    }

    @Override
    protected boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    private class ServiceInstanceResolver<T>
    extends AbstractMultiInstanceResolver<T> {
        public ServiceInstanceResolver(Class<T> clazz) {
            super(clazz);
        }

        public T resolve(Packet request) {
            return (T)ServiceInstanceResolver.createNewInstance((Class)this.clazz);
        }

        public Invoker createInvoker() {
            return new Invoker(){
                private WebServiceContext wsc;

                public void start(WSWebServiceContext wsc, WSEndpoint endpoint) {
                    ServiceInstanceResolver.this.start(wsc, endpoint);
                    this.wsc = wsc;
                }

                public void dispose() {
                    ServiceInstanceResolver.this.dispose();
                }

                public Object invoke(Packet p, Method m, Object ... args) throws InvocationTargetException, IllegalAccessException {
                    BGPluginServer plugin;
                    MessageContext mc = this.wsc.getMessageContext();
                    String pathInfo = (String)mc.get((Object)"jakarta.xml.ws.http.request.pathinfo");
                    Object mid = null;
                    String module = null;
                    if (pathInfo != null) {
                        String[] params = patternSlash.split(pathInfo);
                        if (params.length >= 6) {
                            module = params[2];
                            mid = params[3];
                        } else if (params.length >= 4) {
                            module = params[1];
                            mid = params[2];
                        } else if (params.length >= 3) {
                            module = params[1];
                        }
                    }
                    mid = (plugin = BGPluginManagerServer.getManager().getPlugin(module)) != null ? "p" + plugin.getPluginUID() : String.valueOf(Utils.parseInt(mid));
                    return AbstractJaxWsHandler.this.invoke(module, (String)mid, 0, ServiceInstanceResolver.this, ServiceInstanceResolver.this.clazz, this.wsc, mc, p, m, args);
                }

                public <T> T invokeProvider(Packet p, T arg) {
                    return (T)((Provider)ServiceInstanceResolver.this.resolve(p)).invoke(arg);
                }

                public String toString() {
                    return "Default Invoker over " + ((Object)((Object)ServiceInstanceResolver.this)).toString();
                }
            };
        }
    }
}

