/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.psb.server.action.web;

import java.math.BigDecimal;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractPaymentAction;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.autopayment.server.bean.ContractAutopaymentManager;
import ru.bitel.bgbilling.modules.psb.common.bean.Transaction;
import ru.bitel.bgbilling.modules.psb.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.psb.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.psb.server.bean.Constants;
import ru.bitel.bgbilling.modules.psb.server.bean.TransactionManager;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

@WebAction(title="\u041f\u0421\u0411")
public class ActionDoTransaction
extends AbstractPaymentAction {
    public ActionDoTransaction() {
        super("psb");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws Exception {
        this.setResultParam("gateUrl", this.moduleSetup.get("psb.gate.url", "https://3ds.payment.ru/cgi-bin/cgi_link"));
        this.paymentForm(this.moduleName, Constants.class, AutopaymentManager.class);
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws Exception {
        SearchParam searchParam = new SearchParam().setContractId(this.contractId).setStatus(this.getStatus((AbstractTransactionStatus)TransactionStatus.ALL));
        SearchResult searchResult = new SearchResult(this.getPage(), new String[]{"transactionDatetime:1"});
        new TransactionManager(this.con, this.moduleId).searchTransaction(searchResult, searchParam);
        this.setResultParam("transactions", searchResult.getList());
        this.requestDispatcher("include", "payment_transactions");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436")
    public void pay() throws Exception {
        super.pay();
        super.payCheckSum();
        if (this.sum.compareTo(BigDecimal.ZERO) == 1) {
            String[][] KEYS;
            Transaction transaction = new TransactionManager(this.con, this.moduleId).newTransaction(this.contractId, this.sum, false, false);
            this.setDataMapValues(transaction, this.moduleSetup.get("psb.email"), false, null);
            for (String[] paramName : KEYS = new String[][]{{"MERCH_NAME", "psb.merchant.name"}, {"MERCHANT", "psb.merchant"}, {"TERMINAL", "psb.terminal"}, {"EMAIL", "psb.email"}, {"BACKREF", "psb.back.url"}}) {
                if (this.getResultParam(paramName[0]) != null) continue;
                this.getLogger().error("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \"{}\"", (Object)paramName[1]);
            }
            String str = TransactionManager.buildSignData(this.getResult(), Constants.PARAMS);
            this.setResultParam("P_SIGN", TransactionManager.doSign(str, (ParameterMap)this.moduleSetup));
            if (this.getLogger().isDebugEnabled()) {
                StringBuilder params = new StringBuilder();
                for (String name : Constants.PARAMS) {
                    params.append(name).append(" = ").append(this.getResultParam(name)).append("\n");
                }
                this.getLogger().debug("TRANSACTION DATA:\n{}", (Object)params.toString());
            }
        } else {
            this.execute();
        }
    }

    @WebOperation(title="\u0410\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436")
    public void autopayment() throws Exception {
        AutopaymentMode mode;
        super.autopayment();
        boolean autopaymentEnable = this.moduleSetup.getBoolean("psb.autopayment.enable", false);
        if (autopaymentEnable && ContractAutopaymentManager.isContractAutopaymentEnabled((Connection)this.con, (int)this.moduleId, (int)this.contractId) && (mode = AutopaymentMode.getAutopaymentModeByCode((int)this.req.getInt("mode", 0))) != null) {
            Preferences modeDataMap;
            String customerAddress = ContractUtils.saveCustomerAddress((Connection)this.con, (int)this.moduleId, (int)this.contractId, (String)this.req.get("customerAddress"));
            AutopaymentManager autopaymentManager = new AutopaymentManager(this.con, this.moduleId);
            Autopayment autopayment = autopaymentManager.getCurrentAutopayment(this.contractId);
            if (autopayment != null) {
                if (autopayment.getMode() != AutopaymentMode.OFF) {
                    autopaymentManager.autopaymentOff(autopayment);
                }
                if (mode != autopayment.getMode()) {
                    autopayment.getPeriod().setLocalDateTimeTo(LocalDateTime.now());
                    autopaymentManager.updateAutopayment(autopayment);
                    autopayment = null;
                }
            }
            if (autopayment == null) {
                autopayment = new Autopayment().setContractId(this.contractId);
            }
            TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);
            Preferences preferences = modeDataMap = autopayment.getModeData() != null ? new Preferences(autopayment.getModeData(), "\n") : new Preferences();
            if (mode == AutopaymentMode.OFF) {
                autopayment.setMode(AutopaymentMode.OFF).setSum(BigDecimal.ZERO).setPeriod(new PeriodWithTime(LocalDateTime.now(), null)).setAccessToken(null);
            } else if (mode == AutopaymentMode.WEEK) {
                this.autopaymentWeek("PSB", modeDataMap, autopayment, Constants.class);
                Transaction transaction = transactionManager.newTransaction(this.contractId, autopayment.getSum(), false, true);
                modeDataMap.set("psb.autopayment.recurent.chain.id", String.valueOf(transaction.getId()));
                this.setDataMapValues(transaction, customerAddress, true, "7");
                String str = TransactionManager.buildSignData(this.getResult(), Constants.PARAMS_REG_CHAIN);
                this.setResultParam("P_SIGN", TransactionManager.doSign(str, (ParameterMap)this.moduleSetup));
            } else if (mode == AutopaymentMode.MONTH) {
                this.autopaymentMonth("PSB", modeDataMap, autopayment, Constants.class);
                Transaction transaction = transactionManager.newTransaction(this.contractId, autopayment.getSum(), false, true);
                modeDataMap.set("psb.autopayment.recurent.chain.id", String.valueOf(transaction.getId()));
                this.setDataMapValues(transaction, customerAddress, true, "28");
                String str = TransactionManager.buildSignData(this.getResult(), Constants.PARAMS_REG_CHAIN);
                this.setResultParam("P_SIGN", TransactionManager.doSign(str, (ParameterMap)this.moduleSetup));
            } else if (mode == AutopaymentMode.AUTO) {
                this.autopaymentAuto("PSB", modeDataMap, autopayment, Constants.class);
                Transaction transaction = transactionManager.newTransaction(this.contractId, autopayment.getSum(), false, true);
                modeDataMap.set("psb.autopayment.recurent.chain.id", String.valueOf(transaction.getId()));
                this.setDataMapValues(transaction, customerAddress, true, this.moduleSetup.get("psb.recur.freq", "1"));
                String str = TransactionManager.buildSignData(this.getResult(), Constants.PARAMS_REG_CHAIN);
                this.setResultParam("P_SIGN", TransactionManager.doSign(str, (ParameterMap)this.moduleSetup));
            }
            autopayment.setModeData(modeDataMap.toString());
            autopaymentManager.updateAutopayment(autopayment);
        }
    }

    private void setDataMapValues(Transaction transaction, String email, boolean addChainParameter, String recurFreq) {
        this.setResultParam("AMOUNT", TransactionManager.getFormatSum(transaction.getSum()));
        this.setResultParam("CURRENCY", "RUB");
        this.setResultParam("ORDER", new DecimalFormat("000000").format(transaction.getId()));
        this.setResultParam("MERCH_NAME", this.moduleSetup.get("psb.merchant.name"));
        this.setResultParam("MERCHANT", this.moduleSetup.get("psb.merchant"));
        this.setResultParam("TERMINAL", this.moduleSetup.get("psb.terminal"));
        this.setResultParam("EMAIL", email);
        this.setResultParam("TRTYPE", "1");
        this.setResultParam("TIMESTAMP", TransactionManager.getFormatTime(transaction.getCreateDate()));
        this.setResultParam("NONCE", TransactionManager.getNonce());
        this.setResultParam("BACKREF", this.moduleSetup.get("psb.back.url"));
        String psbNotifyUrl = this.moduleSetup.get("psb.notify.url");
        if (Utils.notBlankString((String)psbNotifyUrl)) {
            this.setResultParam("NOTIFY_URL", psbNotifyUrl);
        }
        Contract contract = (Contract)this.context.getRequest().getSession().getAttribute("contract_current");
        this.setResultParam("DESC", this.moduleSetup.get("psb.description", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116 {CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contract.getTitle()));
        if (addChainParameter) {
            this.setResultParam("RECUR_FREQ", recurFreq);
            String value = this.moduleSetup.get("psb.recur.exp", null);
            if (value == null || value.startsWith("d")) {
                int offcet = 500;
                if (value != null) {
                    offcet = Utils.parseInt((String)value.substring(1), (int)500);
                }
                GregorianCalendar cal = new GregorianCalendar();
                ((Calendar)cal).add(5, offcet);
                SimpleDateFormat dateFormat = new SimpleDateFormat("YYYYMMdd");
                value = dateFormat.format(cal);
            }
            this.setResultParam("RECUR_EXP", value);
        }
    }
}

