/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.search.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import jakarta.xml.ws.Holder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.search.common.ContractSearchable;
import ru.bitel.bgbilling.kernel.contract.search.common.ContractSearchableFilters;
import ru.bitel.bgbilling.kernel.contract.search.common.SearchImplementation;
import ru.bitel.bgbilling.kernel.contract.search.common.service.ContractSearchService;
import ru.bitel.bgbilling.kernel.contract.search.server.ContractSearchableClassesCache;
import ru.bitel.bgbilling.kernel.contract.search.server.ContractSearchableDao;
import ru.bitel.common.model.Page;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.search.common.service.ContractSearchService")
public class ContractSearchServiceImpl
extends AbstractService
implements ContractSearchService {
    private ContractSearchableDao contractSearchableDao;

    @PostConstruct
    public void init() {
        this.contractSearchableDao = new ContractSearchableDao(this.getConnection());
    }

    @Override
    public List<SearchImplementation> getSearches() throws BGException {
        this.reloadCache();
        List<SearchImplementation> result = ContractSearchableClassesCache.getInstance().getImplementationsWrapper();
        if (result.size() == 0) {
            this.getLogger().error("\u0412 \u043a\u044d\u0448\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0439 \u043f\u043e\u0438\u0441\u043a\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u043d\u0438 \u043e\u0434\u043d\u043e\u0439 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438");
        }
        return result;
    }

    @Override
    public List<SearchImplementation> getSelectedSearches() throws BGException {
        return this.tryReturn(() -> this.contractSearchableDao.getList());
    }

    @Override
    public List<SearchImplementation> getValidadedSearches(String searchData) throws BGException {
        return this.tryReturn(() -> {
            ArrayList<SearchImplementation> result = new ArrayList<SearchImplementation>();
            for (SearchImplementation implementation : this.contractSearchableDao.getList()) {
                if (!this.check(implementation, searchData)) continue;
                result.add(implementation);
            }
            return result;
        });
    }

    @Override
    public boolean check(SearchImplementation searchImplementation, String searchData) throws BGException {
        ContractSearchable implClass = ContractSearchableClassesCache.getInstance().getClass(searchImplementation.getPathToImplClass());
        return implClass != null && implClass.check(searchData);
    }

    @Override
    public List<JSONObject> search(SearchImplementation searchImplementation, String searchData, int typeContract, boolean showSubContracts, boolean showClosed, boolean showHidden, Holder<Page> pageHolder) throws BGException {
        return this.tryReturn(() -> {
            ContractSearchable implClass = ContractSearchableClassesCache.getInstance().getClass(searchImplementation.getPathToImplClass());
            return implClass != null ? implClass.search(searchData, searchImplementation.getModuleId(), new ContractSearchableFilters(typeContract, showSubContracts, showClosed, showHidden), pageHolder) : Collections.emptyList();
        });
    }

    @Override
    public JSONObject getTitles(SearchImplementation searchImplementation) throws BGException {
        ContractSearchable implClass = ContractSearchableClassesCache.getInstance().getClass(searchImplementation.getPathToImplClass());
        return implClass != null ? implClass.metadata() : new JSONObject();
    }

    @Override
    public SearchImplementation getSearchById(int id) throws BGException {
        return this.tryReturn(() -> (SearchImplementation)this.contractSearchableDao.get(id));
    }

    @Override
    public void updateSearch(SearchImplementation searchImplementation) throws BGException {
        this.tryCall(() -> this.contractSearchableDao.update(searchImplementation));
    }

    @Override
    public void updateSearchList(List<SearchImplementation> searchImplementationList) throws BGException {
        this.tryCall(() -> {
            for (SearchImplementation search : searchImplementationList) {
                this.contractSearchableDao.update(search);
            }
        });
    }

    @Override
    public void deleteSearch(SearchImplementation searchImplementation) throws BGException {
        this.tryCall(() -> this.contractSearchableDao.delete(searchImplementation.getId()));
    }

    @Override
    public void reloadCache() throws BGException {
        this.tryCall(() -> ContractSearchableClassesCache.getInstance().reloadSearchClasses());
    }
}

