/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.client;

import java.time.LocalDateTime;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonContractProductHistory;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.table.BGTableModel;

public final class MegafonContractProductHistoryTableModel
extends BGTableModel<MegafonContractProductHistory> {
    private Directory<UserInfo> userDirectory;

    public MegafonContractProductHistoryTableModel() {
        super("contractProductHistoryTable");
    }

    protected void initColumns() {
        this.addColumnId();
        this.addColumn("ID \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", -1, -1, -1, "contractId", true);
        this.addColumn("ID \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430", -1, -1, -1, "productId", true);
        this.addColumn("\u0421\u0442\u0430\u0440\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441", -1, -1, -1, "oldProductStatus", true);
        this.addColumn("\u041d\u043e\u0432\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441", -1, -1, -1, "newProductStatus", true);
        this.addColumn("ID \u043e\u043f\u0446\u0438\u0438", -1, -1, -1, "megafonOptionId", true);
        this.addColumn("MSISDN", -1, -1, -1, "msisdn", true);
        this.addColumn("\u0434\u043e\u043f. MSISDN", -1, -1, -1, "additionalMsisdn", true);
        this.addColumn("\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f \u0441\u043e\u0431\u044b\u0442\u0438\u044f", -1, -1, -1, "changeDate", true);
        this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", -1, -1, -1, "userId", true);
    }

    public Object getValue(MegafonContractProductHistory val, int column) throws Exception {
        return switch (column) {
            case 2 -> {
                if (val.getOldProductStatus() != null) {
                    yield val.getOldProductStatus().getComment();
                }
                yield "";
            }
            case 3 -> {
                if (val.getNewProductStatus() != null) {
                    yield val.getNewProductStatus().getComment();
                }
                yield "";
            }
            case 7 -> TimeUtils.format((LocalDateTime)val.getChangeDate(), (String)"dd.MM.yyyy HH:mm");
            case 8 -> this.getUserName(val.getUserId());
            default -> super.getValue((Object)val, column);
        };
    }

    private String getUserName(int userId) throws BGException {
        if (userId == 0) {
            return "\u0421\u0435\u0440\u0432\u0435\u0440";
        }
        if (this.userDirectory == null) {
            return "";
        }
        UserInfo user = (UserInfo)this.userDirectory.get(userId);
        return user != null ? user.getName() : "";
    }

    public void setUserDirectory(Directory<UserInfo> userDirectory) {
        this.userDirectory = userDirectory;
    }
}

