/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.common.bean;

import java.util.Optional;
import ru.bitel.bgbilling.modules.tv.common.bean.enums.AccessCode;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class AccessCodes {
    public static boolean isStateRelated(int accessCode) {
        switch (AccessCode.getAccessCode(accessCode)) {
            case SERVICE_LOCKED: 
            case CONTRACT_LOCKED: 
            case BALANCE_INSUFFICIENT: {
                return true;
            }
        }
        return false;
    }

    public static boolean isStateful(int accessCode) {
        switch (AccessCode.getAccessCode(accessCode)) {
            case SERVICE_LOCKED: 
            case CONTRACT_LOCKED: 
            case BALANCE_INSUFFICIENT: {
                return true;
            }
        }
        return false;
    }

    public static boolean isConnectionStateful(int accessCode) {
        switch (AccessCode.getAccessCode(accessCode)) {
            case MAC_DENY: 
            case IDENTIFIER_DENY: 
            case INVALID_ACCOUNT: 
            case INVALID_PIN: {
                return true;
            }
        }
        return false;
    }

    public static String toString(ParameterMap moduleSetup, int code) {
        String result = moduleSetup.get("error.code." + code, null);
        if (Utils.notBlankString((String)result)) {
            return result;
        }
        return Optional.ofNullable(AccessCode.getAccessCode(code)).map(a -> a.getTitle()).orElse("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u043e\u0448\u0438\u0431\u043a\u0438 [#" + code + "]");
    }
}

