/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.assistant.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantMaster;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;

public class AssistantMasterDao
extends AbstractIdDao<AssistantMaster> {
    private final String TABLE_ASSISTANT_MASTER_ACTION = "assistant_master_action";
    private final String TABLE_ASSISTANT_MASTER_USER_ROLE = "assistant_master_user_role";

    public AssistantMasterDao(Connection con) {
        super(con, "assistant_master");
    }

    public AssistantMaster get(int id, boolean loadIconData) throws SQLException {
        String query = "SELECT * FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    AssistantMaster assistantMaster = this.getFromRS(rs, loadIconData);
                    return assistantMaster;
                }
            }
        }
        return null;
    }

    public List<AssistantMaster> list() throws SQLException {
        return this.list("", "title", new Object[0]);
    }

    public List<AssistantMaster> assistantMasters(Set<String> modes, List<Integer> roleIds) throws SQLException {
        ArrayList<AssistantMaster> assistantMasters = new ArrayList<AssistantMaster>();
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace("assistantMasters: roleIds={}", (Object)Utils.toString(roleIds));
        }
        if (Utils.isEmptyCollection(roleIds)) {
            return assistantMasters;
        }
        String query = "SELECT DISTINCT m.* FROM " + this.tableName + " AS m LEFT JOIN assistant_master_user_role AS r ON r.master_id=m.id WHERE m.status=1 AND r.user_role_id IN (" + Utils.toString(roleIds) + ") ORDER BY `sort`";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace("assistantMasters: modes={}", (Object)Utils.toString(modes));
            }
            while (rs.next()) {
                boolean add;
                AssistantMaster assistantMaster = this.getFromRS(rs, true);
                if (this.getLogger().isTraceEnabled()) {
                    this.getLogger().trace("assistantMasters: assistantMaster={}", (Object)assistantMaster);
                }
                add = (add = Utils.isEmptyCollection(modes)) || modes.contains("contract") && assistantMaster.isShowClientContract();
                add = add || modes.contains("client") && assistantMaster.isShowClient();
                add = add || modes.contains("bot") && assistantMaster.isShowBotAssistant();
                add = add || modes.contains("mobile") && assistantMaster.isShowMobileAssistant();
                add = add || modes.contains("web") && assistantMaster.isShowWebAssistant();
                boolean bl = add = add || modes.contains("webLK") && assistantMaster.isShowWebLKAssistant();
                if (this.getLogger().isTraceEnabled()) {
                    this.getLogger().trace("assistantMasters: showMaster={}", (Object)add);
                }
                if (!add) continue;
                assistantMasters.add(assistantMaster);
            }
        }
        return assistantMasters;
    }

    protected AssistantMaster getFromRS(ResultSet rs) throws SQLException {
        return this.getFromRS(rs, false);
    }

    private AssistantMaster getFromRS(ResultSet rs, boolean loadIconData) throws SQLException {
        byte[] bytes;
        String config = rs.getString("config");
        JSONObject json = new JSONObject(config != null && !config.isEmpty() ? config : "{}");
        JSONObject showJson = json.optJSONObject("show");
        if (showJson == null) {
            showJson = new JSONObject();
        }
        AssistantMaster assistantMaster = new AssistantMaster().setId(rs.getInt("id")).setTitle(rs.getString("title")).setStatus(rs.getInt("status")).setConfig(config).setComment(rs.getString("comment")).setActionIds(Utils.toIntegerList((JSONArray)json.optJSONArray("actionIds"))).setRoleIds(Utils.toIntegerList((JSONArray)json.optJSONArray("roleIds"))).setStartActionId(json.optString("startActionId")).setShowClient(showJson.optBoolean("client")).setShowClientContract(showJson.optBoolean("contract")).setShowWebAssistant(showJson.optBoolean("web")).setShowMobileAssistant(showJson.optBoolean("mobile")).setShowWebLKAssistant(showJson.optBoolean("webLK")).setShowBotAssistant(showJson.optBoolean("bot"));
        if (loadIconData && (bytes = rs.getBytes("icon_data")) != null) {
            assistantMaster.setIconData(Base64.getEncoder().encodeToString(bytes));
        }
        return assistantMaster;
    }

    protected void updateImpl(AssistantMaster assistantMaster) throws SQLException {
        Objects.requireNonNull(assistantMaster);
        String config = assistantMaster.getConfig();
        JSONObject json = new JSONObject(config != null && !config.isEmpty() ? config : "{}");
        JSONObject showJson = Optional.ofNullable(json.optJSONObject("show")).orElse(new JSONObject()).put("client", assistantMaster.isShowClient()).put("contract", assistantMaster.isShowClientContract()).put("web", assistantMaster.isShowWebAssistant()).put("mobile", assistantMaster.isShowMobileAssistant()).put("webLK", assistantMaster.isShowWebLKAssistant()).put("bot", assistantMaster.isShowBotAssistant());
        json.put("actionIds", (Object)Utils.toJsonArray((List)assistantMaster.getActionIds()));
        json.put("roleIds", (Object)Utils.toJsonArray((List)assistantMaster.getRoleIds()));
        json.put("startActionId", (Object)assistantMaster.getStartActionId());
        json.put("show", (Object)showJson);
        assistantMaster.setConfig(json.toString());
        String querySet = "title=?, status=?, config=?, comment=?";
        try (PreparedStatement ps = this.prepareStatement((Idable)assistantMaster, querySet);){
            int index = 1;
            ps.setString(index++, assistantMaster.getTitle());
            ps.setInt(index++, assistantMaster.getStatus());
            ps.setString(index++, assistantMaster.getConfig());
            ps.setString(index++, assistantMaster.getComment());
            this.executeUpdate((Id)assistantMaster, index, ps);
        }
        String deleteQuery = "DELETE FROM assistant_master_user_role WHERE master_id=?";
        String insertQuery = "INSERT INTO assistant_master_user_role SET master_id=?, user_role_id=?";
        try (PreparedStatement psDelete = this.con.prepareStatement(deleteQuery);
             PreparedStatement psInsert = this.con.prepareStatement(insertQuery);){
            psDelete.setInt(1, assistantMaster.getId());
            psDelete.executeUpdate();
            psInsert.setInt(1, assistantMaster.getId());
            for (Integer userRoleId : assistantMaster.getRoleIds()) {
                psInsert.setInt(2, userRoleId);
                psInsert.executeUpdate();
            }
        }
        this.updateMasterActionLink(assistantMaster.getId(), assistantMaster.getActionIds());
    }

    public void updateIconData(int masterId, byte[] iconData) throws SQLException {
        String query = "UPDATE " + this.tableName + " SET icon_data=? WHERE id=?";
        try (PreparedStatement psUpdate = this.con.prepareStatement(query);){
            psUpdate.setBytes(1, iconData);
            psUpdate.setInt(2, masterId);
            psUpdate.executeUpdate();
        }
    }

    public void updateMasterActionLink(int masterId, List<Integer> actionIds) throws SQLException {
        String deleteQuery = "DELETE FROM assistant_master_action WHERE master_id=?";
        String insertQuery = "INSERT INTO assistant_master_action SET master_id=?, action_id=?";
        try (PreparedStatement psDelete = this.con.prepareStatement(deleteQuery);
             PreparedStatement psInsert = this.con.prepareStatement(insertQuery);){
            psDelete.setInt(1, masterId);
            psDelete.executeUpdate();
            psInsert.setInt(1, masterId);
            for (Integer actionId : actionIds) {
                psInsert.setInt(2, actionId);
                psInsert.executeUpdate();
            }
        }
    }

    public void updateMasterActionLink(int masterId, int actionId) throws BGException {
        try {
            String deleteQuery = "DELETE FROM assistant_master_action WHERE master_id=? AND action_id=?";
            String insertQuery = "INSERT INTO assistant_master_action SET master_id=?, action_id=?";
            try (PreparedStatement psDelete = this.con.prepareStatement(deleteQuery);
                 PreparedStatement psInsert = this.con.prepareStatement(insertQuery);){
                psDelete.setInt(1, masterId);
                psDelete.setInt(2, actionId);
                psDelete.executeUpdate();
                psInsert.setInt(1, masterId);
                psInsert.setInt(2, actionId);
                psInsert.executeUpdate();
                this.updateMasterActionIds(masterId);
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void deleteMasterActionLink(int masterId, int actionId) throws BGException {
        try {
            String deleteQuery = "DELETE FROM assistant_master_action WHERE master_id=? AND action_id=?";
            try (PreparedStatement psDelete = this.con.prepareStatement(deleteQuery);){
                psDelete.setInt(1, masterId);
                psDelete.setInt(2, actionId);
                psDelete.executeUpdate();
            }
            this.updateMasterActionIds(masterId);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private void updateMasterActionIds(int masterId) throws Exception {
        String selectQuery = "SELECT action_id FROM assistant_master_action WHERE master_id=?";
        try (PreparedStatement psSelect = this.con.prepareStatement(selectQuery);){
            ArrayList<Integer> actionIds = new ArrayList<Integer>();
            psSelect.setInt(1, masterId);
            try (ResultSet rs = psSelect.executeQuery();){
                while (rs.next()) {
                    actionIds.add(rs.getInt(1));
                }
            }
            AssistantMaster assistantMaster = (AssistantMaster)this.get(masterId);
            if (assistantMaster != null) {
                assistantMaster.setActionIds(actionIds);
                this.update(assistantMaster);
            }
        }
    }
}

