/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.notification;

import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailData;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Topic;
import ru.bitel.bgbilling.plugins.helpdesk.server.mail.MailMessageNotification;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class EmailNotification {
    public static void sendMessage(String email, Topic topic, String text) {
        BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.helpdesk");
        String subjectPattern = plugin.getSetup().get("default.comm.email.subject", "HelpDesk => \u041e\u043f\u0443\u0431\u043b\u0438\u043a\u043e\u0432\u0430\u043d \u043e\u0442\u0432\u0435\u0442 \u0432 \u0442\u0435\u043c\u0435: [{id}] {title}");
        EmailNotification.sendMessage(email, topic, subjectPattern, text);
    }

    public static void sendMessage(final String email, final Topic topic, String subjectPattern, final String text) {
        if (Utils.notBlankString((String)email)) {
            String msgTitle = subjectPattern;
            msgTitle = msgTitle.replaceAll("\\{id\\}", String.valueOf(topic.getId()));
            final String subject = msgTitle = msgTitle.replaceAll("\\{title\\}", topic.getTitle());
            new Thread(){

                @Override
                public void run() {
                    try {
                        MailMessageNotification mailData = new MailMessageNotification().setTopic(topic).setRecipients(email).setSubject(subject).addTextPart("text", text);
                        new MailMsg((Preferences)Setup.getSetup()).sendMessage((MailData)mailData);
                    }
                    catch (Exception ex) {
                        BGLogger.error((Throwable)ex);
                    }
                }
            }.start();
        }
    }
}

