/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean;

import java.sql.Connection;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.directory.api.server.ServerDirectoryFactory;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDevice;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDeviceType;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceDeviceDao;
import ru.bitel.bgbilling.modules.voice.server.event.VoiceDevicesReloadLocalEvent;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceTreeFilter;

public class VoiceDeviceMap
extends BGLogger
implements EventListener<Event> {
    private static final ConcurrentMap<Integer, VoiceDeviceMap> moduleMap = new ConcurrentHashMap<Integer, VoiceDeviceMap>();
    private final int moduleId;
    private volatile Map<Integer, VoiceDeviceMapItem> deviceMap;
    private final AtomicLong version = new AtomicLong();

    public static synchronized VoiceDeviceMap getInstance(int moduleId) throws BGException {
        VoiceDeviceMap result = (VoiceDeviceMap)((Object)moduleMap.get(moduleId));
        if (result == null) {
            result = new VoiceDeviceMap(moduleId);
            moduleMap.put(moduleId, result);
        }
        return result;
    }

    VoiceDeviceMap(int moduleId) throws BGException {
        this.moduleId = moduleId;
        EventProcessor.getInstance().addListener((EventListener)this, VoiceDevicesReloadLocalEvent.class, moduleId, null);
    }

    public long getVersion() {
        return this.version.get();
    }

    private Map<Integer, VoiceDeviceMapItem> load() throws Exception {
        this.getLogger().info("(Re)loading VoiceDeviceMap");
        Setup setup = Setup.getSetup();
        ModuleSetup moduleSetup = setup.getModuleSetup(Integer.valueOf(this.moduleId));
        try (ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)Setup.getSetup(), (boolean)true);){
            HashMap<String, String> bundleParams = new HashMap<String, String>();
            Object bundlePreferences = setup != null ? setup.getBundlePreferences() : null;
            for (Map.Entry e : bundlePreferences.entrySet()) {
                String key = (String)e.getKey();
                if ("db.driver".equals(key) || "db.url".equals(key) || "db.user".equals(key) || "db.pswd".equals(key) || "mq.url".equals(key) || "mq.user".equals(key) || "mq.pswd".equals(key)) continue;
                bundleParams.put((String)e.getKey(), (String)e.getValue());
            }
            bundlePreferences = bundleParams.size() == 0 ? null : new Preferences(bundleParams);
            VoiceDevice rootDevice = null;
            try (VoiceDeviceDao voiceDeviceDao = new VoiceDeviceDao(connectionSet.getConnection(), this.moduleId, 0);){
                rootDevice = (VoiceDevice)voiceDeviceDao.root(new DeviceTreeFilter().setLoadDeviceGroupLink(false));
            }
            Directory deviceTypeDir = ServerDirectoryFactory.newUnmodifiableDirectory(VoiceDeviceType.class, (Connection)connectionSet.getConnection(), (int)this.moduleId, (boolean)false);
            Map deviceTypeMap = Id.newMap((List)deviceTypeDir.list());
            GregorianCalendar closePeriod = new GregorianCalendar();
            TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)closePeriod);
            closePeriod.set(5, 1);
            ((Calendar)closePeriod).add(2, -6);
            HashMap<Integer, VoiceDeviceMapItem> idMap = new HashMap<Integer, VoiceDeviceMapItem>();
            this.loadDevice((Preferences)bundlePreferences, (ParameterMap)moduleSetup, (Map<Integer, VoiceDeviceMapItem>)idMap, deviceTypeMap, rootDevice, null, closePeriod.getTime());
            this.version.incrementAndGet();
            HashMap<Integer, VoiceDeviceMapItem> hashMap = idMap;
            return hashMap;
        }
    }

    private void loadDevice(Preferences bundlePreferences, ParameterMap moduleSetup, Map<Integer, VoiceDeviceMapItem> idMap, Map<Integer, VoiceDeviceType> deviceTypeMap, VoiceDevice voiceDevice, VoiceDeviceMapItem parent, Date closePeriod) throws BGException {
        int deviceTypeId = voiceDevice.getDeviceTypeId();
        VoiceDeviceType voiceDeviceType = deviceTypeMap.get(deviceTypeId);
        if (voiceDeviceType == null) {
            voiceDeviceType = (VoiceDeviceType)voiceDevice.getDeviceType();
        }
        Preferences vars = new Preferences();
        vars.set("deviceId", String.valueOf(voiceDevice.getId()));
        String stringConfig = voiceDevice.getConfig();
        Object config = null;
        if (Utils.notBlankString((String)stringConfig)) {
            config = new Preferences((ParameterMap)vars, stringConfig, "\n");
        }
        if (voiceDeviceType != null && Utils.notBlankString((String)voiceDeviceType.getConfig())) {
            config = config != null ? new Preferences((ParameterMap)vars, voiceDeviceType.getConfig(), "\n").inherit((ParameterMap)config) : new Preferences((ParameterMap)vars, voiceDeviceType.getConfig(), "\n");
        }
        if (parent != null) {
            config = config != null ? parent.config.inherit((ParameterMap)config) : parent.config;
        } else {
            if (config == null) {
                config = new Preferences((ParameterMap)vars, stringConfig, "\n");
            }
            if (moduleSetup != null) {
                config = moduleSetup.inherit((ParameterMap)config);
            }
            if (bundlePreferences != null) {
                config = bundlePreferences.inherit((ParameterMap)config);
            }
        }
        VoiceDeviceMapItem holder = new VoiceDeviceMapItem(this, parent, voiceDevice, (ParameterMap)config);
        idMap.put(voiceDevice.getId(), holder);
        VoiceDeviceMapItem iteratorParent = parent;
        while (iteratorParent != null) {
            iteratorParent.descendantIds0.add(voiceDevice.getId());
            iteratorParent = iteratorParent.parent;
        }
        List children = voiceDevice.getChildren();
        if (children != null && children.size() > 0) {
            for (VoiceDevice child : children) {
                if (child.getDateTo() != null && child.getDateTo().before(closePeriod)) {
                    this.getLogger().info("Skip load device:" + child.getId() + " and it children due to close period");
                    continue;
                }
                this.loadDevice(bundlePreferences, moduleSetup, idMap, deviceTypeMap, child, holder, closePeriod);
            }
        }
    }

    public void fix(ParameterMap params, Preferences fix, String prefixOld, String prefixNew) {
        for (Map.Entry e : params.entrySet()) {
            String paramKey = (String)e.getKey();
            if (!paramKey.startsWith(prefixOld)) continue;
            String suffix = paramKey.substring(prefixOld.length(), paramKey.length());
            fix.set(prefixNew + suffix, (String)e.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VoiceDeviceMapItem get(int deviceId) throws Exception {
        Map<Integer, VoiceDeviceMapItem> deviceMap = this.deviceMap;
        if (deviceMap == null) {
            VoiceDeviceMap voiceDeviceMap = this;
            synchronized (voiceDeviceMap) {
                deviceMap = this.deviceMap = this.load();
            }
        }
        return deviceMap.get(deviceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, VoiceDeviceMapItem> getMap() throws Exception {
        Map<Integer, VoiceDeviceMapItem> deviceMap = this.deviceMap;
        if (deviceMap == null) {
            VoiceDeviceMap voiceDeviceMap = this;
            synchronized (voiceDeviceMap) {
                deviceMap = this.deviceMap = this.load();
            }
        }
        return deviceMap;
    }

    public void notify(Event e, EventListenerContext ctx) throws BGException {
        this.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        VoiceDeviceMap voiceDeviceMap = this;
        synchronized (voiceDeviceMap) {
            this.deviceMap = null;
        }
    }

    public class VoiceDeviceMapItem {
        final VoiceDeviceMapItem parent;
        final VoiceDevice device;
        final ParameterMap config;
        final Set<Integer> descendantIds0;
        final Set<Integer> descendantIds;
        private final Set<Integer> ancestorAndThisIds0;
        private final Set<Integer> ancestorAndThisIds;
        final Set<Integer> ancestorIds;

        public VoiceDeviceMapItem(VoiceDeviceMap this$0, VoiceDeviceMapItem parent, VoiceDevice device, ParameterMap config) {
            this.parent = parent;
            this.device = device;
            this.config = config;
            this.descendantIds0 = new HashSet<Integer>();
            this.descendantIds = Collections.unmodifiableSet(this.descendantIds0);
            this.ancestorAndThisIds0 = new HashSet<Integer>();
            if (device.getId() > 0) {
                this.ancestorAndThisIds0.add(device.getId());
            }
            if (parent != null) {
                this.ancestorAndThisIds0.addAll(parent.ancestorAndThisIds);
            }
            this.ancestorAndThisIds = Collections.unmodifiableSet(this.ancestorAndThisIds0);
            this.ancestorIds = parent != null ? parent.ancestorAndThisIds : Collections.emptySet();
        }

        public VoiceDeviceMapItem getParent() {
            return this.parent;
        }

        public VoiceDevice getDevice() {
            return this.device;
        }

        public ParameterMap getConfig() {
            return this.config;
        }

        public Set<Integer> getDescendantIds() {
            return this.descendantIds;
        }

        public Set<Integer> getAncestorIds() {
            return this.ancestorIds;
        }

        public VoiceDeviceMapItem findRoot(Set<Integer> rootDeviceTypeId) {
            if (rootDeviceTypeId.contains(this.device.getDeviceTypeId())) {
                return this;
            }
            if (this.parent != null) {
                return this.parent.findRoot(rootDeviceTypeId);
            }
            return this;
        }
    }
}

