/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.assistant.server;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.json.JSONObject;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.plugin.server.inpoint.OnInitServer;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantAction;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantActionItem;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantMaster;
import ru.bitel.bgbilling.plugins.assistant.server.bean.AssistantActionDao;
import ru.bitel.bgbilling.plugins.assistant.server.bean.AssistantMasterDao;
import ru.bitel.bgbilling.server.util.Setup;

public class PluginServerListener
extends BGLogger
implements OnInitServer {
    public void onInitServer(String applicationName) {
        try (Connection connection = Setup.getSetup().getDBConnection();){
            AssistantActionDao assistantDao = new AssistantActionDao(connection);
            AssistantMasterDao assistantMasterDao = new AssistantMasterDao(connection);
            if (assistantMasterDao.list().size() == 0) {
                List<AssistantActionItem> actions = assistantDao.assistantActions(0);
                actions.addAll(assistantDao.assistantActions(1));
                for (AssistantActionItem assistantAstionItem : actions) {
                    String nextActionId;
                    AssistantAction assistantAction = assistantDao.get(assistantAstionItem.getId());
                    if (assistantAction.getDependent() == 1) continue;
                    HashSet<Integer> actionIds = new HashSet<Integer>();
                    actionIds.add(assistantAction.getId());
                    while ((nextActionId = new JSONObject(assistantAction.getConfig()).getJSONObject("options").optString("nextActionId", null)) != null) {
                        int id = actions.stream().filter(a -> a.getActionId().equals(nextActionId)).map(a -> a.getId()).findFirst().orElse(0);
                        if (id <= 0) continue;
                        actionIds.add(id);
                        assistantAction = assistantDao.get(id);
                    }
                    assistantMasterDao.update(new AssistantMaster().setTitle(assistantAction.getTitle()).setStartActionId(assistantAction.getActionId()).setRoleIds(assistantAction.getUserRoleIds()).setActionIds(new ArrayList(actionIds)));
                }
                connection.createStatement().executeUpdate("UPDATE `assistant_action` SET `dependent`=0 WHERE `dependent`=1");
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }
}

