/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.tariff;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import ru.bitel.bgbilling.kernel.tariff.server.tree.ServiceCost;
import ru.bitel.bgbilling.modules.tv.server.ProductManager;
import ru.bitel.bgbilling.modules.tv.server.runtime.ProductSpecRuntime;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class TvServiceCost
extends ServiceCost {
    public static final int PROLONGATION_REJECTED = 0;
    public static final int PROLONGATION_DELAYED = 1;
    public static final int PROLONGATION_APPROVED = 2;
    public static final int PROLONGATION_PROPORTIONAL = 3;
    private int productId;
    private int activationModeId;
    private Date activationTime;
    public Date prolongationTime;
    private ProductSpecRuntime productSpecRuntime;
    private ProductManager.Entry productItem;
    public int activationServiceId;
    public BigDecimal activationPrice = BigDecimal.ZERO;
    public boolean activationPriceExternal = false;
    public int prolongation = 0;
    public Date periodTimeFrom;
    public Date periodTimeTo;
    public int periodMode;
    public int periodAmount;
    public boolean periodAlign;
    public boolean periodProportional;
    public boolean ignoreBalance;
    public boolean dayToEndMonth;
    public BigDecimal ignoreBalanceSumma = BigDecimal.ZERO;
    public Set<Integer> contractStatusSet = new HashSet<Integer>();
    public Set<Integer> deviceStateSet = new HashSet<Integer>();

    public int getActivationModeId() {
        return this.activationModeId;
    }

    public Date getActivationTime() {
        return this.activationTime;
    }

    public int getProductId() {
        return this.productId;
    }

    public ProductManager.Entry getProductItem() {
        return this.productItem;
    }

    public ProductSpecRuntime getProductSpecRuntime() {
        return this.productSpecRuntime;
    }

    public TvServiceCost newCost() {
        TvServiceCost result = new TvServiceCost();
        result.productId = this.productId;
        result.activationModeId = this.activationModeId;
        result.activationTime = this.activationTime;
        result.productSpecRuntime = this.productSpecRuntime;
        result.productItem = this.productItem;
        result.serviceId = this.serviceId;
        result.serviceStart = this.serviceStart;
        result.serviceEnd = this.serviceEnd;
        result.amount = this.amount;
        result.prolongationTime = this.prolongationTime;
        result.periodTimeFrom = this.periodTimeFrom;
        result.periodTimeTo = this.periodTimeTo;
        result.cost = this.cost;
        if (this.activationPriceExternal) {
            result.activationPrice = this.activationPrice;
            result.activationPriceExternal = true;
        } else {
            result.activationPrice = this.activationPrice;
        }
        return result;
    }

    protected String paramsToString() {
        try {
            StringBuilder result = new StringBuilder().append("pp: ").append(this.productId).append(":").append(this.productItem != null ? this.productItem.productPeriodId : 0).append("; sid: ").append(this.serviceId).append("; periodFrom: ").append(TimeUtils.formatFullDate((Date)this.periodTimeFrom)).append("; periodTo: ").append(TimeUtils.formatFullDate((Date)this.periodTimeTo)).append("; serviceStart: ").append(TimeUtils.formatDate((LocalDate)this.serviceStart)).append("; serviceEnd: ").append(TimeUtils.formatDate((LocalDate)this.serviceEnd)).append("; accPeriodDays: ").append(this.accountingPeriodDays).append("; amount: ").append(this.amount).append("; cost: ").append(this.cost);
            if (this.ignoreBalanceSumma != BigDecimal.ZERO) {
                result.append("; ignoreBalanceSumma: ");
                result.append(this.ignoreBalanceSumma);
            }
            if (!this.contractStatusSet.isEmpty()) {
                result.append("; contractStatusSet: ");
                result.append(Utils.toString(this.contractStatusSet));
            }
            if (!this.deviceStateSet.isEmpty()) {
                result.append("; deviceStateSet: ");
                result.append(Utils.toString(this.deviceStateSet));
            }
            return result.toString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public TvServiceCost setActivationModeId(int activationModeId) {
        this.activationModeId = activationModeId;
        return this;
    }

    public TvServiceCost setActivationTime(Date activationTime) {
        this.activationTime = activationTime;
        return this;
    }

    public TvServiceCost setAmount(long amount) {
        super.setAmount(amount);
        return this;
    }

    public TvServiceCost setProductId(int id) {
        this.productId = id;
        return this;
    }

    public TvServiceCost setProductItem(ProductManager.Entry productItem) {
        this.productItem = productItem;
        return this;
    }

    public TvServiceCost setProductSpecRuntime(ProductSpecRuntime productSpecRuntime) {
        this.productSpecRuntime = productSpecRuntime;
        return this;
    }

    public TvServiceCost setServiceId(int serviceId) {
        super.setServiceId(serviceId);
        return this;
    }

    public TvServiceCost setServiceStart(LocalDate serviceStart) {
        super.setServiceStart(serviceStart);
        return this;
    }

    public TvServiceCost setServiceEnd(LocalDate serviceEnd) {
        super.setServiceEnd(serviceEnd);
        return this;
    }
}

