/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.dynamic.client;

import bitel.billing.module.common.BGTabbedPane;
import bitel.billing.module.common.BSHEditor;
import bitel.billing.module.common.ClosableTabbedPaneUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.text.BadLocationException;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTabPanel;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.dynamic.client.DynamicClassEditDialog;
import ru.bitel.bgbilling.kernel.dynamic.client.DynamicCodeTree;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.CompilationMessage;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.CompilationResult;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.DynamicClass;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.GeneratorOptions;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.RunMessage;
import ru.bitel.bgbilling.kernel.dynamic.common.service.DynamicCodeService;
import ru.bitel.bgbilling.kernel.dynamic.common.templates.CustomTemplate;
import ru.bitel.bgbilling.kernel.dynamic.common.templates.GeneratorTemplate;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGLogViewer;
import ru.bitel.common.client.BGTextDialog;
import ru.bitel.common.client.table.BGTableModel;

public class DynamicCodeLibraryPanel
extends BGUTabPanel {
    public static final String TAB_ID = "dynamic_library_panel";
    private static final String SAVE_CODE = "save_code";
    public static final String COMPILE = "compile";
    private static final String RECOMPILE_ALL = "recompile_all";
    private static final String RUN = "run";
    private BGTabbedPane sourceTabbedPane = new BGTabbedPane();
    private DynamicCodeTree codeTree = new DynamicCodeTree();
    private JButton recompileButton = new JButton("\u0421\u043a\u043e\u043c\u043f\u0438\u043b\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432\u0441\u0451");
    private JButton saveButton = new JButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
    private JButton compileButton = new JButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0438 \u0441\u043a\u043e\u043c\u043f\u0438\u043b\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
    private JToggleButton compilerMessagesButton = new JToggleButton("C\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u043f\u0438\u043b\u044f\u0442\u043e\u0440\u0430");
    private JPanel compilerMessagesPanel = new JPanel(new GridBagLayout());
    private BGSplitPaneNoBorder codeAndMessagesSplit;
    private JTabbedPane messagesTabbedPane = new JTabbedPane();
    private CompilerMessageTable errorTable;
    private CompilerMessageTable warningTable;
    private RunMessagePane consoleTable;
    private DynamicCodeService dynCodeService;
    private boolean hasErrors = false;
    boolean first = true;

    public DynamicCodeLibraryPanel() {
        this(new ClientContext("kernel.dynamic", 0, 0, ""));
    }

    public DynamicCodeLibraryPanel(ClientContext ctx) {
        super(ctx, TAB_ID, "\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u043c \u043a\u043e\u0434\u043e\u043c");
    }

    protected void jbInit() {
        this.dynCodeService = (DynamicCodeService)((ClientContext)this.getContext()).getPort(DynamicCodeService.class);
        this.setLayout(new GridBagLayout());
        JPanel treePanePanel = new JPanel(new GridBagLayout());
        JScrollPane codeTreeScrollPane = new JScrollPane((Component)((Object)this.codeTree));
        codeTreeScrollPane.getVerticalScrollBar().setUnitIncrement(30);
        treePanePanel.add((Component)codeTreeScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        treePanePanel.setBorder(BorderFactory.createTitledBorder("\u0418\u0435\u0440\u0430\u0440\u0445\u0438\u044f \u043a\u043b\u0430\u0441\u0441\u043e\u0432"));
        JPanel leftPanel = new JPanel(new GridBagLayout());
        leftPanel.add((Component)treePanePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        leftPanel.add((Component)this.recompileButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.errorTable = new CompilerMessageTable();
        this.messagesTabbedPane.addTab("\u041e\u0448\u0438\u0431\u043a\u0438", new JScrollPane((Component)((Object)this.errorTable)));
        this.warningTable = new CompilerMessageTable();
        this.messagesTabbedPane.addTab("\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f", new JScrollPane((Component)((Object)this.warningTable)));
        this.consoleTable = new RunMessagePane();
        this.messagesTabbedPane.addTab("\u0412\u044b\u0432\u043e\u0434", new JScrollPane((Component)((Object)this.consoleTable)));
        this.compilerMessagesPanel.add((Component)this.messagesTabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.compilerMessagesPanel.setVisible(false);
        this.compilerMessagesPanel.setBorder(BorderFactory.createTitledBorder("\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u043f\u0438\u043b\u044f\u0442\u043e\u0440\u0430"));
        JButton runButton = new JButton("Run (F9)");
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        buttonsPanel.add((Component)this.compilerMessagesButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        buttonsPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        buttonsPanel.add((Component)this.saveButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        buttonsPanel.add((Component)this.compileButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        buttonsPanel.add((Component)runButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.add((Component)this.sourceTabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.sourceTabbedPane.setUI((TabbedPaneUI)new ClosableTabbedPaneUI(ClosableTabbedPaneUI.TabCloseButtonAlign.RIGHT));
        this.codeAndMessagesSplit = new BGSplitPaneNoBorder(0, (Component)topPanel, (Component)this.compilerMessagesPanel, 300L);
        JPanel rightPanel = new JPanel(new GridBagLayout());
        rightPanel.add((Component)this.codeAndMessagesSplit, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        rightPanel.add((Component)buttonsPanel, new GridBagConstraints(0, 10, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        BGSplitPaneNoBorder mainSplitPane = new BGSplitPaneNoBorder(1, (Component)leftPanel, (Component)rightPanel, 400L);
        this.add((Component)mainSplitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.sourceTabbedPane.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                if (SwingUtilities.isRightMouseButton(event) && DynamicCodeLibraryPanel.this.sourceTabbedPane.getUI().tabForCoordinate((JTabbedPane)DynamicCodeLibraryPanel.this.sourceTabbedPane, event.getX(), event.getY()) >= 0) {
                    DynamicCodeLibraryPanel.this.getPopupMenu().show((Component)DynamicCodeLibraryPanel.this.sourceTabbedPane, event.getX(), event.getY());
                }
            }
        });
        this.sourceTabbedPane.addChangeListener(e -> {
            ClassTabPanel selectedTab = (ClassTabPanel)((Object)((Object)this.sourceTabbedPane.getSelectedTab()));
            if (selectedTab != null) {
                this.codeTree.setSelectedClass(selectedTab.getClassName());
                this.compilerMessagesPanel.setVisible(selectedTab.getTabResult() != null);
                if (selectedTab.getTabResult() != null) {
                    this.showError(selectedTab.getTabResult(), true);
                }
                if (!selectedTab.isHasErrors() && selectedTab.getMessageList() != null) {
                    this.showConsole(selectedTab.getMessageList());
                }
            }
        });
        this.recompileButton.addActionListener(e -> {
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u043f\u0435\u0440\u0435\u043a\u043e\u043c\u043f\u0438\u043b\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432\u0441\u0435 \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 0) == 0) {
                this.performAction(RECOMPILE_ALL);
            }
        });
        this.compilerMessagesButton.addActionListener(e -> this.setMessagesVisible(this.compilerMessagesButton.isSelected()));
        this.saveButton.addActionListener(e -> this.performAction(SAVE_CODE));
        this.codeTree.addActionListener(e -> this.performAction("edit"));
        this.compileButton.addActionListener(e -> {
            this.performAction(SAVE_CODE);
            this.performAction(COMPILE);
        });
        runButton.addActionListener(e -> this.performAction(RUN));
        this.performAction("refresh");
    }

    protected void setMessagesVisible(boolean selected) {
        this.compilerMessagesButton.setSelected(selected);
        this.compilerMessagesPanel.setVisible(selected);
        if (!selected) {
            this.codeAndMessagesSplit.setDividerSize(0);
            this.codeAndMessagesSplit.setDividerLocation(1.0);
        } else {
            this.codeAndMessagesSplit.setDividerSize(5);
            this.codeAndMessagesSplit.setDividerLocation(0.7);
        }
        this.codeAndMessagesSplit.revalidate();
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            this.codeTree.recreateTree(this.dynCodeService.getDynamicClasses());
            ClassTabPanel selectedTab = (ClassTabPanel)((Object)((Object)this.sourceTabbedPane.getSelectedTab()));
            int pos = -1;
            if (this.first) {
                this.codeAndMessagesSplit.setDividerLocation(0.0);
                this.first = false;
            } else if (selectedTab != null && selectedTab.hasFocus()) {
                pos = selectedTab.sourceEditor.getTextPane().getCaretPosition();
                String serverSource = this.getSource(selectedTab.getClassName());
                if (!selectedTab.isTextChanged()) {
                    if (!serverSource.equals(selectedTab.getClassSource())) {
                        selectedTab.setClassSource(serverSource);
                    }
                } else if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412 \u043e\u043a\u043d\u0435 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0430 \u0435\u0441\u0442\u044c \u043d\u0435\u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u044b\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f. \u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u043e\u043a\u043d\u0430 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0430?", "\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435", 0) == 0) {
                    selectedTab.setClassSource(serverSource);
                    selectedTab.setInitialSource(serverSource);
                    selectedTab.setTextChanged(false);
                }
            }
            if (pos > 0 && selectedTab.getClassSource().length() > pos) {
                selectedTab.sourceEditor.getTextPane().setCaretPosition(pos);
                selectedTab.sourceEditor.getTextPane().requestFocus();
            }
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            GeneratorOptions options;
            String source = null;
            if (e.getSource() != null && e.getSource() instanceof GeneratorOptions) {
                options = (GeneratorOptions)e.getSource();
            } else {
                DynamicClassEditDialog classEditDialog = new DynamicClassEditDialog(null, this.codeTree.getPackage(), true);
                if (classEditDialog.showDialog().equals("ok")) {
                    options = classEditDialog.getGeneratorOptions();
                    GeneratorTemplate selectedTemplate = classEditDialog.getSelectedTemplate();
                    if (selectedTemplate instanceof CustomTemplate) {
                        if (selectedTemplate.getExtension().equals("java")) {
                            source = options.getRawResourceData();
                            this.performAction(COMPILE);
                        } else if (Utils.isBlankString((String)selectedTemplate.getExtension())) {
                            options.setFullClassName(options.getFullClassName() + ":");
                        }
                    }
                } else {
                    return;
                }
            }
            String className = options.getFullClassName();
            if (Utils.isEmptyString((String)className) || '.' == className.charAt(className.length() - 1)) {
                return;
            }
            if (this.dynCodeService.isClassExists(className)) {
                throw new BGMessageException("\u0422\u0430\u043a\u043e\u0439 \u043a\u043b\u0430\u0441\u0441 \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!");
            }
            if (source == null) {
                source = this.dynCodeService.generateCode(options);
            }
            this.saveSource(className, source);
            this.performAction("refresh");
            ClassTabPanel tabClassPanel = new ClassTabPanel(DynamicClass.getResourceFileSimpleName(options.getFullClassName()), className, source);
            this.sourceTabbedPane.addTab((BGTabPanel)tabClassPanel);
            this.sourceTabbedPane.setSelectedComponent((Component)((Object)tabClassPanel));
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            String selectedClass = null;
            if (e.getSource() != null && e.getSource() instanceof GeneratorOptions) {
                selectedClass = ((GeneratorOptions)e.getSource()).getFullClassName();
            } else {
                String selected = this.codeTree.getSelectedClass();
                if (Utils.notBlankString((String)selected)) {
                    selectedClass = selected;
                }
            }
            if (selectedClass != null) {
                try {
                    ClassTabPanel tabClassPanel = new ClassTabPanel(DynamicClass.getResourceFileSimpleName(selectedClass), selectedClass, this.getSource(selectedClass));
                    BGTabPanel tabPanel = this.sourceTabbedPane.getTab(selectedClass);
                    if (tabPanel == null) {
                        this.sourceTabbedPane.addTab((BGTabPanel)tabClassPanel);
                    } else {
                        this.sourceTabbedPane.setSelectedComponent((Component)((Object)tabClassPanel));
                    }
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        });
        new AbstractBGUPanel.DefaultAction(SAVE_CODE, ""){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                if (e.getSource() instanceof String) {
                    ClassTabPanel tab2Save;
                    String tabId = (String)e.getSource();
                    if (Utils.notBlankString((String)tabId) && (tab2Save = (ClassTabPanel)DynamicCodeLibraryPanel.this.sourceTabbedPane.getTab(tabId)) != null) {
                        DynamicCodeLibraryPanel.this.saveSource(tab2Save.getClassName(), tab2Save.getClassSource());
                        tab2Save.setTextChanged(false);
                        tab2Save.setInitialSource(tab2Save.getClassSource());
                    }
                } else {
                    ClassTabPanel selectedTab = (ClassTabPanel)((Object)DynamicCodeLibraryPanel.this.sourceTabbedPane.getSelectedTab());
                    if (selectedTab != null) {
                        String initialSource;
                        int pos = selectedTab.sourceEditor.getTextPane().getCaretPosition();
                        String serverSource = DynamicCodeLibraryPanel.this.getSource(selectedTab.getClassName());
                        if (!serverSource.equals(initialSource = selectedTab.getInitialSource())) {
                            String message = "\u0421\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u043a\u043b\u0430\u0441\u0441\u0430 " + selectedTab.getClassName() + " \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0435 c\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0438\u043b\u043e\u0441\u044c.\n\u0415\u0441\u043b\u0438 \u043d\u0430\u0436\u043c\u0435\u0442\u0435 \u0414\u0410, \u0442\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u0441\u044f \u0441\u0435\u0440\u0432\u0435\u0440\u043d\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f \u043a\u043b\u0430\u0441\u0441\u0430, \u043d\u043e \u0431\u0443\u0434\u0443\u0442 \u043f\u043e\u0442\u0435\u0440\u044f\u043d\u044b \u0432\u0441\u0435 \u0432\u0430\u0448\u0438 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f.\n\u0415\u0441\u043b\u0438 \u043d\u0430\u0436\u043c\u0435\u0442\u0435 \u041d\u0415\u0422, \u0442\u043e \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u043a\u043b\u0430\u0441\u0441\u0430 \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0435 \u043f\u0435\u0440\u0435\u0442\u0440\u0435\u0442\u0441\u044f \u0442\u0435\u043c, \u0447\u0442\u043e \u0432 \u0434\u0430\u043d\u043d\u044b\u0439 \u043c\u043e\u043c\u0435\u043d\u0442 \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432 \u043e\u043a\u043d\u0435 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0430.\n\u0425\u043e\u0442\u0438\u0442\u0435 \u0437\u0430\u043c\u0435\u043d\u0438\u0442\u044c \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u043d\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0435\u0439?";
                            int userChoice = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), message, "\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435", 1);
                            if (userChoice == 0) {
                                selectedTab.setClassSource(serverSource);
                            } else if (userChoice == 2) {
                                return;
                            }
                        }
                        if (selectedTab.isTextChanged()) {
                            DynamicCodeLibraryPanel.this.saveSource(selectedTab.getClassName(), selectedTab.getClassSource());
                            selectedTab.setTextChanged(false);
                            selectedTab.setInitialSource(selectedTab.getClassSource());
                            if (pos > 0 && selectedTab != null && selectedTab.getClassSource().length() > pos) {
                                selectedTab.sourceEditor.getTextPane().setCaretPosition(pos);
                                selectedTab.sourceEditor.getTextPane().requestFocus();
                            }
                        }
                    }
                }
            }
        };
        new AbstractBGUPanel.DefaultAction(COMPILE, ""){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                ClassTabPanel selectedTab = (ClassTabPanel)((Object)DynamicCodeLibraryPanel.this.sourceTabbedPane.getSelectedTab());
                if (selectedTab != null) {
                    CompilationResult result = DynamicCodeLibraryPanel.this.dynCodeService.compile(selectedTab.getClassName());
                    selectedTab.setTabResult(result);
                    DynamicCodeLibraryPanel.this.performAction("refresh");
                    DynamicCodeLibraryPanel.this.showError(result, true);
                }
            }
        };
        new AbstractBGUPanel.DefaultAction(RECOMPILE_ALL, ""){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                DynamicCodeLibraryPanel.this.setCursor(new Cursor(3));
                Window waitwindow = null;
                try {
                    waitwindow = ClientUtils.showWaitWindow((String)"\u041a\u043e\u043c\u043f\u0438\u043b\u0438\u0440\u0443\u0435\u0442\u0441\u044f \u0432\u0441\u0451...");
                    CompilationResult result = DynamicCodeLibraryPanel.this.dynCodeService.recompileAll();
                    DynamicCodeLibraryPanel.this.performAction("refresh");
                    DynamicCodeLibraryPanel.this.showError(result, false);
                }
                finally {
                    waitwindow.dispose();
                    DynamicCodeLibraryPanel.this.setCursor(new Cursor(0));
                }
            }
        };
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            String className = this.codeTree.getSelectedClass();
            if (Utils.isBlankString((String)className)) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u043b\u0430\u0441\u0441 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f!");
                return;
            }
            String[] classesNames = new String[]{className};
            Object[] deleteClasses = (String[])Arrays.stream(classesNames).filter(i -> !i.contains(":")).toArray(String[]::new);
            Object[] deleteFiles = (String[])Arrays.stream(classesNames).filter(i -> i.contains(":")).toArray(String[]::new);
            CompilationResult result = null;
            Object msg = "";
            if (deleteClasses.length > 0 && deleteFiles.length > 0) {
                msg = "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c: \"" + className + "\"?\n\u0412 \u0441\u043f\u0438\u0441\u043a\u0435 \u0444\u0430\u0439\u043b\u043e\u0432 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 java-\u043a\u043b\u0430\u0441\u0441\u044b, \u0447\u0442\u043e \u043f\u0440\u0438\u0432\u0435\u0434\u0435\u0442 \u043a \u043f\u0435\u0440\u0435\u043a\u043e\u043c\u043f\u0438\u043b\u044f\u0446\u0438\u0438 \u0432\u0441\u0435\u0445 \u043e\u0441\u0442\u0430\u0432\u0448\u0438\u0445\u0441\u044f \u043a\u043b\u0430\u0441\u0441\u043e\u0432. \u0412 \u0441\u043b\u0443\u0447\u0430\u0435 \u043e\u0448\u0438\u0431\u043a\u0438 \u043a\u043e\u043c\u043f\u0438\u043b\u044f\u0446\u0438\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 java-\u043a\u043b\u0430\u0441\u0441\u043e\u0432 \u043d\u0435 \u0431\u0443\u0434\u0435\u0442 \u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u043e, \u043e\u0441\u0442\u0430\u043b\u044c\u043d\u044b\u0435 \u0444\u0430\u0439\u043b\u044b \u0431\u0443\u0434\u0443\u0442 \u0443\u0434\u0430\u043b\u0435\u043d\u044b.";
            } else {
                if (deleteFiles.length > 0) {
                    msg = "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0444\u0430\u0439\u043b\u044b: \"" + Utils.toString((Object[])deleteFiles, (String)", ") + "\"";
                }
                if (deleteClasses.length > 0) {
                    msg = "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c java \u043a\u043b\u0430\u0441\u0441\u044b: \"" + Utils.toString((Object[])deleteClasses, (String)", ") + "\"?\n\u042d\u0442\u043e \u043f\u0440\u0438\u0432\u0435\u0434\u0435\u0442 \u043a \u043f\u0435\u0440\u0435\u043a\u043e\u043c\u043f\u0438\u043b\u044f\u0446\u0438\u0438 \u0432\u0441\u0435\u0445 \u043e\u0441\u0442\u0430\u0432\u0448\u0438\u0445\u0441\u044f \u043a\u043b\u0430\u0441\u0441\u043e\u0432. \u0412 \u0441\u043b\u0443\u0447\u0430\u0435 \u043e\u0448\u0438\u0431\u043a\u0438 \u043a\u043e\u043c\u043f\u0438\u043b\u044f\u0446\u0438\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u0431\u0443\u0434\u0435\u0442 \u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u043e.";
                }
            }
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), msg, "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f", 0) != 0) {
                return;
            }
            if (deleteFiles.length > 0) {
                result = this.dynCodeService.deleteFiles((String[])deleteFiles);
            }
            if (deleteClasses.length > 0) {
                result = this.dynCodeService.deleteClasses((String[])deleteClasses);
            }
            this.showError(result, false);
            if (!this.hasErrors) {
                this.sourceTabbedPane.remove((Component)((Object)new ClassTabPanel(null, className, null)));
            }
            this.performAction("refresh");
        });
        new AbstractBGUPanel.DefaultAction(RUN, "", KeyStroke.getKeyStroke(120, 0)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                block6: {
                    DynamicCodeLibraryPanel.this.setCursor(new Cursor(3));
                    try {
                        ClassTabPanel selectedTab = (ClassTabPanel)((Object)DynamicCodeLibraryPanel.this.sourceTabbedPane.getSelectedTab());
                        DynamicCodeLibraryPanel.this.consoleTable.setText("");
                        DynamicCodeLibraryPanel.this.performAction(DynamicCodeLibraryPanel.SAVE_CODE);
                        DynamicCodeLibraryPanel.this.performAction(DynamicCodeLibraryPanel.COMPILE);
                        if (DynamicCodeLibraryPanel.this.hasErrors) break block6;
                        Window waitwindow = null;
                        try {
                            waitwindow = ClientUtils.showWaitWindow((String)String.format("\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 %s...", selectedTab.getClassName()));
                            List<RunMessage> result = DynamicCodeLibraryPanel.this.dynCodeService.run(selectedTab.getClassName(), new String[]{"TODO?"});
                            selectedTab.setMessageList(result);
                            DynamicCodeLibraryPanel.this.showConsole(result);
                            DynamicCodeLibraryPanel.this.performAction("refresh");
                        }
                        finally {
                            waitwindow.dispose();
                        }
                    }
                    finally {
                        DynamicCodeLibraryPanel.this.setCursor(new Cursor(0));
                    }
                }
            }
        };
    }

    private String getSource(String className) {
        try {
            return this.dynCodeService.getSource(className);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
            return "";
        }
    }

    private void saveSource(String className, String source) throws Exception {
        this.dynCodeService.updateSource(className, source);
    }

    public void onOpening() {
        this.performAction("refresh");
    }

    private void highlighErrorLine(ClassTabPanel selectedTab, List<CompilationMessage> errors) {
        if (selectedTab == null) {
            return;
        }
        try {
            for (CompilationMessage error : errors) {
                if (error.getLine() <= 0L) continue;
                selectedTab.sourceEditor.addHighlightLine((int)error.getLine(), Color.YELLOW);
            }
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    private void showError(CompilationResult result, boolean isOneTabContext) {
        ClassTabPanel selectedTab = (ClassTabPanel)((Object)this.sourceTabbedPane.getSelectedTab());
        this.errorTable.setData(result.getErrors());
        this.warningTable.setData(result.getWarnings());
        for (JPanel tabs : this.sourceTabbedPane.getTabs()) {
            ((ClassTabPanel)((Object)tabs)).sourceEditor.removeAllHighlights();
        }
        if (result.getErrors().size() > 0) {
            if (selectedTab != null && isOneTabContext) {
                this.highlighErrorLine(selectedTab, result.getErrors());
            }
            this.messagesTabbedPane.setSelectedIndex(0);
            this.setMessagesVisible(true);
            this.hasErrors = true;
        } else {
            this.hasErrors = false;
        }
        if (selectedTab != null && isOneTabContext) {
            selectedTab.setHasErrors(this.hasErrors);
        }
    }

    private void showConsole(List<RunMessage> result) {
        this.consoleTable.setData(result);
        this.messagesTabbedPane.setSelectedIndex(2);
        this.setMessagesVisible(true);
    }

    protected void getPopupMenuItems() {
        this.popupMenu.add("\u0417\u0430\u043a\u0440\u044b\u0442\u044c").addActionListener(e -> {
            ClassTabPanel selectedTab = (ClassTabPanel)((Object)((Object)this.sourceTabbedPane.getSelectedTab()));
            if (selectedTab != null) {
                if (selectedTab.isTextChanged() && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0435 \u0435\u0441\u0442\u044c \u043d\u0435\u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u044b\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f. \u0425\u043e\u0442\u0438\u0442\u0435 \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u043f\u0435\u0440\u0435\u0434 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0435\u043c \u0432\u043a\u043b\u0430\u0434\u043a\u0438?", "\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435", 0) == 0) {
                    this.performAction(SAVE_CODE);
                }
                this.sourceTabbedPane.removeTab((Component)((Object)selectedTab));
            }
        });
        this.popupMenu.add("\u0417\u0430\u043a\u0440\u044b\u0442\u044c \u043e\u0441\u0442\u0430\u043b\u044c\u043d\u044b\u0435").addActionListener(e -> {
            this.confirmSaveBeforeClose();
            ClassTabPanel selectedTab = (ClassTabPanel)((Object)((Object)this.sourceTabbedPane.getSelectedTab()));
            this.sourceTabbedPane.removeAll();
            this.sourceTabbedPane.addTab((BGTabPanel)selectedTab);
        });
        this.popupMenu.add("\u0417\u0430\u043a\u0440\u044b\u0442\u044c \u0432\u0441\u0435").addActionListener(e -> {
            this.confirmSaveBeforeClose();
            this.sourceTabbedPane.removeAll();
        });
    }

    private void confirmSaveBeforeClose() {
        block5: {
            ClassTabPanel tab;
            boolean hasUnsaved = false;
            for (Component comp : this.sourceTabbedPane.getComponents()) {
                if (!(comp instanceof ClassTabPanel) || !(tab = (ClassTabPanel)((Object)comp)).isTextChanged()) continue;
                hasUnsaved = true;
                break;
            }
            if (!hasUnsaved) break block5;
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0421\u0440\u0435\u0434\u0438 \u043e\u0442\u043a\u0440\u044b\u0442\u044b\u0445 \u0432\u043a\u043b\u0430\u0434\u043e\u043a \u0435\u0441\u0442\u044c \u043d\u0435\u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435. \u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0438\u0445 \u043f\u0435\u0440\u0435\u0434 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0435\u043c?", "\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435", 0) == 0) {
                for (Component comp : this.sourceTabbedPane.getComponents()) {
                    if (comp == null || !(comp instanceof ClassTabPanel) || !(tab = (ClassTabPanel)((Object)comp)).isTextChanged()) continue;
                    this.performAction(tab.getClassName(), SAVE_CODE, SAVE_CODE);
                }
            } else {
                for (Component comp : this.sourceTabbedPane.getComponents()) {
                    if (comp == null || !(comp instanceof ClassTabPanel) || !(tab = (ClassTabPanel)((Object)comp)).isTextChanged()) continue;
                    tab.setTextChanged(false);
                }
            }
        }
    }

    private static class CompilerMessageTable
    extends BGUTable {
        private BGTableModel<CompilationMessage> model = (BGTableModel)this.getModel();

        private static BGTableModel<CompilationMessage> getMessageModel() {
            BGTableModel<CompilationMessage> model = new BGTableModel<CompilationMessage>(""){

                protected void initColumns() {
                    this.addColumn("\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", -1, -1, -1, "message");
                    this.addColumn("\u041a\u043b\u0430\u0441\u0441", 130, 160, -1, "source");
                    this.addColumn("\u0421\u0442\u0440", 30, 45, 60, "line");
                    this.addColumn("\u0421\u0442\u043b\u0431", 30, 45, 60, "column");
                }
            };
            return model;
        }

        public CompilerMessageTable() {
            super(CompilerMessageTable.getMessageModel());
            this.setAutoRowHeight(true);
            ClientUtils.addOpenAction((Component)((Object)this), e -> this.tableClick());
        }

        public void setData(List<CompilationMessage> data) {
            this.model.setData(data);
        }

        private void tableClick() {
            CompilationMessage message = (CompilationMessage)this.model.getSelectedRow();
            if (message == null) {
                return;
            }
            if (this.getSelectedColumn() == 0) {
                BGTextDialog.showDialog((String)message.getMessage(), (int)800, (int)480);
            } else if (this.getSelectedColumn() == 1) {
                BGTextDialog.showDialog((String)message.getSource(), (int)800, (int)480);
            }
        }
    }

    private static class RunMessagePane
    extends BGLogViewer {
        public RunMessagePane() {
            this.setEditable(false);
            this.addStyle(RunMessage.RunMessageType.ERR.name(), Color.red);
            this.addStyle(RunMessage.RunMessageType.INFO.name(), new Color(204, 204, 204), false, true);
        }

        public void setData(List<RunMessage> result) {
            this.setText("");
            for (RunMessage msg : result) {
                this.append(msg.getMessage(), msg.getMessageType().name());
            }
        }
    }

    private class ClassTabPanel
    extends BGTabPanel {
        private BSHEditor sourceEditor;
        private JTextField classNameTextField;
        private String initialSource;
        private boolean textChanged;
        private CompilationResult tabResult;
        private List<RunMessage> messageList;
        private boolean hasErrors;

        public ClassTabPanel(String tabTitle, String fullClassName, String src) {
            super(fullClassName, tabTitle);
            this.sourceEditor = new BSHEditor();
            this.classNameTextField = new JTextField();
            this.textChanged = false;
            this.hasErrors = false;
            this.setLayout(new GridBagLayout());
            this.sourceEditor.setText(src);
            this.setInitialSource(src);
            this.classNameTextField.setText(fullClassName);
            this.classNameTextField.setEditable(false);
            this.classNameTextField.setBorder(BorderFactory.createEmptyBorder());
            this.classNameTextField.setFont(this.classNameTextField.getFont().deriveFont(1));
            JPanel tabClassPanel = new JPanel(new GridBagLayout());
            tabClassPanel.add((Component)this.classNameTextField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            tabClassPanel.add((Component)this.sourceEditor, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.add(tabClassPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.sourceEditor.getTextPane().getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.changeFlag(e);
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.changeFlag(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.changeFlag(e);
                }

                private void changeFlag(DocumentEvent e) {
                    try {
                        String text = e.getDocument().getText(0, e.getDocument().getLength());
                        ClassTabPanel.this.setTextChanged(!text.equals(ClassTabPanel.this.initialSource));
                    }
                    catch (BadLocationException ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
            });
        }

        public void updateTabTitle() {
            Object tabTitle = this.getTabTitle();
            if (this.textChanged && !((String)tabTitle).contains("*")) {
                tabTitle = (String)tabTitle + "*";
            } else if (!this.textChanged && ((String)tabTitle).contains("*")) {
                tabTitle = ((String)tabTitle).substring(0, this.getTabTitle().indexOf("*"));
            }
            this.setTabTitle((String)tabTitle);
        }

        public String getClassName() {
            return this.classNameTextField.getText();
        }

        public String getClassSource() {
            return this.sourceEditor.getText();
        }

        public void setClassSource(String classSrc) {
            this.sourceEditor.setText(classSrc);
            this.setInitialSource(classSrc);
        }

        public String getInitialSource() {
            return this.initialSource;
        }

        public void setInitialSource(String source) {
            this.initialSource = source;
        }

        public boolean isTextChanged() {
            return this.textChanged;
        }

        public void setTextChanged(boolean textChanged) {
            this.textChanged = textChanged;
            this.updateTabTitle();
        }

        public CompilationResult getTabResult() {
            return this.tabResult;
        }

        public void setTabResult(CompilationResult tabResult) {
            this.tabResult = tabResult;
        }

        public List<RunMessage> getMessageList() {
            return this.messageList;
        }

        public void setMessageList(List<RunMessage> messageList) {
            this.messageList = messageList;
        }

        public boolean isHasErrors() {
            return this.hasErrors;
        }

        public void setHasErrors(boolean hasErrors) {
            this.hasErrors = hasErrors;
        }

        public boolean onClosing() {
            if (this.isTextChanged()) {
                int dialogResult = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0435 \u0435\u0441\u0442\u044c \u043d\u0435\u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u044b\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f. \u0425\u043e\u0442\u0438\u0442\u0435 \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u043f\u0435\u0440\u0435\u0434 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0435\u043c \u0432\u043a\u043b\u0430\u0434\u043a\u0438?", "\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435", 1);
                switch (dialogResult) {
                    case 0: {
                        DynamicCodeLibraryPanel.this.performAction(DynamicCodeLibraryPanel.SAVE_CODE);
                        break;
                    }
                    case 2: {
                        return false;
                    }
                }
            }
            DynamicCodeLibraryPanel.this.setMessagesVisible(false);
            return super.onClosing();
        }

        public void onOpening() {
            DynamicCodeLibraryPanel.this.setMessagesVisible(false);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof ClassTabPanel) {
                return this.getClassName().equals(((ClassTabPanel)((Object)obj)).getClassName());
            }
            return false;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public String toString() {
            return "Class name: " + this.getClassName();
        }

        public boolean hasFocus() {
            return this.sourceEditor.hasFocus();
        }
    }
}

