/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.simplepay.server.action.web;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Date;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractPaymentAction;
import ru.bitel.bgbilling.modules.simplepay.common.bean.Transaction;
import ru.bitel.bgbilling.modules.simplepay.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.simplepay.server.bean.Constants;
import ru.bitel.bgbilling.modules.simplepay.server.bean.TransactionManager;
import ru.bitel.common.Utils;
import ru.bitel.common.model.SearchResult;

@WebAction(title="Simplepay")
public class ActionDoTransaction
extends AbstractPaymentAction {
    public ActionDoTransaction() {
        super("simplepay");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws Exception {
        this.setResultParam("gateUrl", this.moduleSetup.get("simplepay.url.payment", "https://api.simplepay.pro/sp/payment"));
        this.setResultParam("commissionType", this.moduleSetup.getInt("simplepay.commission.type", 0));
        this.setResultParam("commissionPercent", this.moduleSetup.getDouble("simplepay.commission.percent", 0.0));
        this.paymentForm(this.moduleName, Constants.class, null);
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws Exception {
        SearchResult searchResult = new SearchResult(this.getPage(), new String[]{"createDate:1", "transactionDate:1"});
        new TransactionManager(this.con, this.moduleId).searchTransaction((SearchResult<Transaction>)searchResult, this.contractId, null, this.getStatus((AbstractTransactionStatus)TransactionStatus.ALL));
        this.setResultParam("transactions", searchResult.getList());
        this.requestDispatcher("include", "payment_transactions");
    }

    public void success() throws Exception {
        int transactionId = this.req.getInt("sp_order_id", 0);
        if (transactionId > 0) {
            new TransactionManager(this.con, this.moduleId).doCheckRequest(transactionId);
        }
        this.execute();
    }

    public void fail() throws Exception {
        int transactionId = this.req.getInt("sp_order_id", 0);
        if (transactionId > 0) {
            new TransactionManager(this.con, this.moduleId).doCheckRequest(transactionId);
        }
        this.execute();
    }

    @WebOperation(title="\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430")
    public void pay() throws Exception {
        super.pay();
        super.payCheckSum();
        int commissionType = this.moduleSetup.getInt("simplepay.commission.type", 0);
        if (commissionType == 2) {
            BigDecimal percent = this.moduleSetup.getBigDecimal("simplepay.commission.percent", BigDecimal.ZERO).add(new BigDecimal(100)).divide(new BigDecimal(100));
            this.sum = this.sum.multiply(percent);
        } else if (commissionType == 3) {
            BigDecimal percent100 = new BigDecimal(100);
            BigDecimal commissionPercent = this.moduleSetup.getBigDecimal("simplepay.commission.percent", BigDecimal.ZERO);
            BigDecimal percentSum = this.sum.divide(percent100.add(commissionPercent.negate()).divide(percent100), 4, RoundingMode.HALF_UP).multiply(commissionPercent).divide(percent100, 2, RoundingMode.HALF_UP);
            this.sum = this.sum.add(percentSum);
        }
        String description = "";
        description = this.moduleSetup.get("simplepay.description", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0431\u0430\u043b\u0430\u043d\u0441\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", this.getContractTitle());
        Transaction transaction = new Transaction().setSum(this.sum).setContractId(this.contractId).setCreateDate(new Date());
        new TransactionManager(this.con, this.moduleId).update(transaction);
        this.setResultParam("gateUrl", this.moduleSetup.get("simplepay.url.payment", "https://api.simplepay.pro/sp/payment"));
        this.setResultParam("formFields", new String[]{"sp_merchant_id", "sp_outlet_id", "sp_order_id", "sp_amount", "sp_lifetime", "sp_description", "sp_salt", "sp_sig"});
        this.setResultParam("sp_merchant_id", this.moduleSetup.get("simplepay.merchant.id", ""));
        this.setResultParam("sp_outlet_id", this.moduleSetup.get("simplepay.outlet.id", ""));
        this.setResultParam("sp_order_id", String.valueOf(transaction.getId()));
        this.setResultParam("sp_amount", new DecimalFormat("###########0.00").format(this.sum).replace(",", "."));
        this.setResultParam("sp_lifetime", this.moduleSetup.get("simplepay.lifetime", "86400"));
        this.setResultParam("sp_description", description);
        this.setResultParam("sp_salt", Utils.getDigest((String)String.valueOf(System.currentTimeMillis()), (String)"UTF-8"));
        String scriptName = this.moduleSetup.get("simplepay.url.payment", "https://api.simplepay.pro/sp/payment");
        String[] keys = new String[]{"sp_merchant_id", "sp_amount", "sp_order_id", "sp_description", "sp_lifetime", "sp_salt", "sp_outlet_id"};
        String secretKey = this.moduleSetup.get("simplepay.merchant.secret.key", this.moduleSetup.get("simplepay.secret.key", ""));
        this.setResultParam("sp_sig", TransactionManager.getSign(scriptName, keys, this.getResult(), secretKey));
    }
}

