/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client;

import bitel.billing.module.common.TransferData;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import jakarta.activation.DataSource;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.DialogTypeSelection;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGControlPanelPluginControls;
import ru.bitel.bgbilling.client.common.BGFileChooser;
import ru.bitel.bgbilling.client.common.BGFileFilter;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.field.BGIntTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.bill.client.BillDoc;
import ru.bitel.bgbilling.modules.bill.client.bean.XMLTreePanel;
import ru.bitel.bgbilling.modules.bill.client.viewer.FOStylesheet;
import ru.bitel.bgbilling.modules.bill.client.viewer.JRStylesheet;
import ru.bitel.bgbilling.modules.bill.client.viewer.Stylesheet;
import ru.bitel.bgbilling.modules.bill.common.bean.DocumentSendParameters;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.DocumentType;
import ru.bitel.bgbilling.modules.bill.common.service.BillService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.BGEmailDialog;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Pair;

public class ServiceConfigBillViewer
extends ServiceConfigTabbedPanel {
    private double currentScale = 1.5;
    private boolean toList = false;
    private JComboBox<String> scale = new JComboBox();
    private List<BillDoc> documentList = new ArrayList<BillDoc>();
    private BGIntTextField printBlockSize = new BGIntTextField();
    private BGIntTextField printStartBlock = new BGIntTextField();
    private BGIntTextField printDocFrom = new BGIntTextField();
    private BGIntTextField printDocTo = new BGIntTextField();
    private final BGButtonPanel buttonPanel = new BGButtonPanel(new BGButtonPanel.ButtonItem[]{BGButtonPanel.SAVE_M, BGButtonPanel.EMAIL_M});
    private BGControlPanelPages documentPanel = new BGControlPanelPages();
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private CardLayout viewLayout = new CardLayout();
    private JPanel viewPanel = new JPanel(this.viewLayout);
    private Stylesheet stylesheet = null;
    private FOStylesheet foStylesheet;
    private JRStylesheet jrStylesheet;
    private BGButton xmlButton = new BGButton("XML", "xml");
    private JPanel bodyPanel = new JPanel(new CardLayout());
    private JSplitPane xmlPanel = new JSplitPane(1);
    private JTextArea xmlText = new JTextArea();
    BGButton saveXmlButton = new BGButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c XML");
    XMLTreePanel xmlTreePanel = new XMLTreePanel(this.saveXmlButton);
    private PrintPopup printPopup = null;
    private BGUList<IdTitle> docListNav = new BGUList();
    private BGControlPanelPluginControls bgPluginnedPanel;

    public ServiceConfigBillViewer() {
        this(false);
    }

    public ServiceConfigBillViewer(boolean toList) {
        this.toList = toList;
        this.tryCall(() -> this.jbInit());
        this.documentPanel.setKey(((Object)((Object)this)).getClass().getName());
    }

    private TransferData.HTTPDataSource getDoc(int num) {
        if (num >= 0 && num < this.documentList.size()) {
            return this.getDataSource(this.getRequest(this.documentList.get(num)));
        }
        return null;
    }

    private Stylesheet getFOStylesheet() {
        if (this.foStylesheet == null) {
            this.foStylesheet = new FOStylesheet();
            this.foStylesheet.scale(this.currentScale);
            this.viewPanel.add((Component)this.foStylesheet.getComponent(), "fo");
            this.xmlReset();
        }
        return this.foStylesheet;
    }

    private Stylesheet getJRStylesheet() {
        if (this.jrStylesheet == null) {
            this.jrStylesheet = new JRStylesheet();
            this.jrStylesheet.scale(this.currentScale);
            this.viewPanel.add((Component)this.jrStylesheet.getComponent(), "jr");
        }
        return this.jrStylesheet;
    }

    public void showDocument(int num) {
        TransferData.HTTPDataSource dataSource = this.getDoc(num);
        if (dataSource == null || dataSource.isError()) {
            if (this.stylesheet != null) {
                this.stylesheet.clear();
            }
            this.bgPluginnedPanel.invokeSetData(new Object[]{"showDocument", null});
            return;
        }
        if (dataSource.isContentTypeTextXml()) {
            this.stylesheet = this.getFOStylesheet();
            this.stylesheet.showDocument((DataSource)dataSource);
            this.viewLayout.show(this.viewPanel, "fo");
        } else {
            this.stylesheet = this.getJRStylesheet();
            this.stylesheet.showDocument((DataSource)dataSource);
            this.viewLayout.show(this.viewPanel, "jr");
        }
        this.pagePanel.setPageCount(Math.max(this.stylesheet.getPageCount(), 1));
        this.documentPanel.setPageIndex(num + 1);
        this.docListNav.setSelectedIndex(num);
        this.bgPluginnedPanel.invokeSetData(new Object[]{"showDocument", this.documentList.get(num)});
    }

    public void printBlock() {
        int documentCount = this.documentList.size();
        int blockSize = (int)this.printBlockSize.getValue();
        int fromBlock = (int)this.printStartBlock.getValue();
        if (blockSize <= 0) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0411\u043b\u043e\u043a \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u0440\u0430\u0437\u043c\u0435\u0440");
            return;
        }
        fromBlock = Math.max(fromBlock, 1);
        int blockCount = Utils.pageCount((int)documentCount, (int)blockSize);
        for (int blocknum = fromBlock - 1; blocknum < blockCount; ++blocknum) {
            int curBlockSize = Math.min(blockSize, documentCount - blocknum * blockSize);
            PrinterJob job = this.getPrinterJob(blocknum * blockSize, curBlockSize);
            job.setJobName("\u0411\u043b\u043e\u043a \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 " + (blocknum + 1) + " \u0438\u0437 " + blockCount + " (\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432: " + curBlockSize + ")");
            this.printStartBlock.setValue((long)(blocknum + 1));
            if (!job.printDialog()) break;
            try {
                job.print();
                continue;
            }
            catch (PrinterException pe) {
                if (pe.getMessage().contains("page or printable")) continue;
                ClientUtils.showErrorMessageDialog((Throwable)pe);
                continue;
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
        }
    }

    public void printRange() {
        int documentCount = this.documentList.size();
        int docFrom = (int)this.printDocFrom.getValue();
        int docTo = (int)this.printDocTo.getValue();
        docFrom = Math.max(docFrom, 1);
        int curBlockSize = (docTo = Math.min(docTo, documentCount)) - docFrom + 1;
        if (curBlockSize <= 0) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0434\u043b\u044f \u043f\u0435\u0447\u0430\u0442\u0438 \u043d\u0435\u0442");
            return;
        }
        PrinterJob job = this.getPrinterJob(docFrom - 1, curBlockSize);
        job.setJobName("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b " + docFrom + " \u2014 " + docTo + " (\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432: " + curBlockSize + ")");
        HashPrintRequestAttributeSet printRequestAttributeSet = new HashPrintRequestAttributeSet();
        printRequestAttributeSet.add(DialogTypeSelection.NATIVE);
        if (job.printDialog(printRequestAttributeSet)) {
            this.parallelPrint(job);
        }
    }

    private void parallelPrint(PrinterJob job) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.submit(() -> {
            try {
                job.print();
            }
            catch (PrinterException pe) {
                if (!pe.getMessage().contains("page or printable")) {
                    ClientUtils.showErrorMessageDialog((Throwable)pe);
                }
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
        });
    }

    protected PrinterJob getPrinterJob(final int fromDocument, final int countDocument) {
        final PrinterJob printerjob = PrinterJob.getPrinterJob();
        printerjob.setPageable(new Pageable(){
            private final Map<Integer, PageFormat> pageFormats = new HashMap<Integer, PageFormat>();
            private final int[] billIndex;
            private int currentIndex;
            private int lastPage;
            private Stylesheet currentStylesheet;
            {
                this.billIndex = new int[ServiceConfigBillViewer.this.documentList.size() + 1];
            }

            @Override
            public int getNumberOfPages() {
                return -1;
            }

            @Override
            public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
                if (pageIndex < this.lastPage) {
                    throw new IndexOutOfBoundsException("reverse print?");
                }
                PageFormat currentPageFormat = this.pageFormats.get(pageIndex);
                if (currentPageFormat == null) {
                    for (int i = 0; i < countDocument; ++i) {
                        if (pageIndex != 0 && (this.billIndex[i] > pageIndex || this.billIndex[i + 1] != 0 && this.billIndex[i + 1] <= pageIndex)) continue;
                        TransferData.HTTPDataSource ds = ServiceConfigBillViewer.this.getDoc(fromDocument + i);
                        if (ds == null || ds.isError()) break;
                        this.currentStylesheet = ds.isContentTypeTextXml() ? new FOStylesheet() : new JRStylesheet();
                        this.currentIndex = this.billIndex[i];
                        currentPageFormat = this.currentStylesheet.getPageFormat((DataSource)ds, printerjob, pageIndex - this.billIndex[i]);
                        this.billIndex[i + 1] = this.billIndex[i] + this.currentStylesheet.getNumberOfPages();
                        break;
                    }
                }
                if (currentPageFormat == null) {
                    throw new IndexOutOfBoundsException("end of pages (total " + pageIndex + ")");
                }
                this.pageFormats.put(pageIndex, currentPageFormat);
                this.lastPage = pageIndex;
                return currentPageFormat;
            }

            @Override
            public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
                return new Printable(){

                    @Override
                    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
                        return currentStylesheet.print(graphics, pageFormat, pageIndex - currentIndex);
                    }
                };
            }
        });
        return printerjob;
    }

    public Pair<List<Integer>, List<Integer>> getBillInvoiceIds() {
        ArrayList<Integer> billList = new ArrayList<Integer>();
        ArrayList<Integer> invoiceList = new ArrayList<Integer>();
        for (int i = 0; i < this.documentList.size(); ++i) {
            BillDoc billDoc = this.documentList.get(i);
            if (billDoc.type == DocumentType.BILL) {
                billList.add(billDoc.docId);
                continue;
            }
            invoiceList.add(billDoc.docId);
        }
        return new Pair(billList, invoiceList);
    }

    public BillDoc getCurrentViewedDoc() {
        int num = this.documentPanel.getPageIndex() - 1;
        if (num < this.documentList.size()) {
            return this.documentList.get(num);
        }
        return null;
    }

    public void sendToEmail() {
        this.tryCall(() -> {
            Pair<List<Integer>, List<Integer>> bii = this.getBillInvoiceIds();
            ((BillService)this.getContext().getWebService(BillService.class)).sendDocsForAll(new DocumentSendParameters((List)bii.getFirst(), (List)bii.getSecond(), DocumentSendParameters.SendingDataType.ALL));
            ClientUtils.showMessageDialog((Object)"\u0417\u0430\u0434\u0430\u0447\u0430 \u0440\u0430\u0441\u0441\u044b\u043b\u043a\u0438 \u043f\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0430 \u0432 \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0449\u0438\u043a");
        });
    }

    private void jbInit() throws Exception {
        ActionListener actionListener = e -> {
            String actionCommand = e.getActionCommand();
            if ("email".equals(actionCommand)) {
                this.sendToEmail();
            } else if ("xml".equals(actionCommand)) {
                this.xmlButton_actionPerformed(e);
            } else if ("print".equals(actionCommand)) {
                BGButton button = (BGButton)e.getSource();
                this.getPrintPopup().show((Component)button, 0, button.getHeight() + 1);
            }
        };
        this.xmlButton.addActionListener(actionListener);
        int index = 0;
        JPanel topPanel = new JPanel(new GridBagLayout());
        if (this.toList) {
            topPanel.add((Component)this.getToListButton(), new GridBagConstraints(index++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 25), 0, 0));
        }
        topPanel.add((Component)this.buttonPanel, new GridBagConstraints(index++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)this.xmlButton, new GridBagConstraints(index++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 25, 0, 0), 0, 0));
        topPanel.add((Component)new BGButton("\u0420\u0430\u0437\u043e\u0441\u043b\u0430\u0442\u044c \u043d\u0430 \u043f\u043e\u0447\u0442\u0443", "email", actionListener), new GridBagConstraints(index++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        topPanel.add((Component)new BGButton("\u041f\u0435\u0447\u0430\u0442\u044c...", "print", actionListener), new GridBagConstraints(index++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.bgPluginnedPanel = new BGControlPanelPluginControls(ServiceConfigBillViewer.class.getName(), (Component)((Object)this), new Object[0]);
        topPanel.add((Component)this.bgPluginnedPanel, new GridBagConstraints(index++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 25, 0, 0), 0, 0));
        topPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(index++, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
        topPanel.add((Component)this.getScalePanel(), new GridBagConstraints(index++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)this.getPagePanel("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442", (Component)this.documentPanel), new GridBagConstraints(index++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)this.getPagePanel("\u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430", (Component)this.pagePanel), new GridBagConstraints(index++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.xmlText.setEditable(false);
        this.xmlPanel.setLeftComponent(new JScrollPane(this.xmlText));
        this.xmlPanel.setRightComponent(this.xmlTreePanel);
        this.xmlPanel.setDividerSize(3);
        this.saveXmlButton.addActionListener(e -> {
            int num = this.documentPanel.getPageIndex() - 1;
            if (num < this.documentList.size()) {
                BillDoc billDoc = this.documentList.get(num);
                this.tryCall(() -> {
                    Request request = new Request().setModule(this.module).setAction("BillUpdateXml").setModuleId(this.getModuleId()).setAttribute("type", billDoc.getTypeString()).setAttribute("codes", billDoc.docId).setAttribute("xml", XMLUtils.serializeToString((Node)this.xmlTreePanel.getDocument(), (boolean)true));
                    Document doc = this.getDocument(request);
                    if (ClientUtils.checkStatus((Document)doc)) {
                        this.openDocuments(this.documentList, false);
                    }
                });
            }
        });
        JPanel leftNavPanel = new JPanel(new GridBagLayout());
        leftNavPanel.add((Component)new JScrollPane((Component)this.docListNav), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.bodyPanel.add((Component)this.viewPanel, "view");
        this.bodyPanel.add((Component)this.xmlPanel, "xml");
        this.viewPanel.setVisible(true);
        this.xmlPanel.setVisible(false);
        BGSplitPaneNoBorder bodySplit = new BGSplitPaneNoBorder(1, (Component)leftNavPanel, (Component)this.bodyPanel, 300L);
        this.setLayout(new GridBagLayout());
        this.add(topPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 1, 5), 0, 0));
        this.add((Component)bodySplit, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.scale.addActionListener(e -> {
            String scaleValue = (String)this.scale.getSelectedItem();
            if (scaleValue != null) {
                this.currentScale = Double.parseDouble(scaleValue) / 100.0;
                if (this.stylesheet != null) {
                    this.stylesheet.scale(this.currentScale);
                    this.xmlReset();
                }
            }
        });
        this.documentPanel.addToHandler(a -> {
            this.showDocument(this.documentPanel.getPageIndex() - 1);
            this.xmlReset();
        });
        this.pagePanel.addToHandler(a -> {
            if (this.stylesheet != null) {
                this.stylesheet.showPage(this.pagePanel.getPageIndex());
                this.xmlReset();
            }
        });
        this.currentScale = 1.5;
        this.scale.setSelectedItem("150");
        this.printBlockSize.setText("100");
        this.printStartBlock.setText("1");
        this.printDocFrom.setText("1");
        this.printDocTo.setText("100");
        this.buttonPanel.addActionListener(e -> {
            String actionCommand = e.getActionCommand();
            if (BGButtonPanel.EMAIL_M.getActionCommand().equals(actionCommand)) {
                BGEmailDialog dialog = new BGEmailDialog();
                dialog.addPropertyChangeListener(evt -> {
                    Request request;
                    if (evt.getPropertyName().equals("selectEmail") && ClientUtils.checkStatus((Document)this.getDocument(request = this.getRequest(this.documentPanel.getPageIndex() - 1).setAttribute("maildest", String.valueOf(evt.getNewValue()))))) {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041e\u0442\u0447\u0435\u0442 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 1);
                    }
                });
                dialog.loadEmailListFromContractParameter(this.getContractId(), 0);
                dialog.setVisible(true);
            } else if (BGButtonPanel.SAVE_M.getActionCommand().equals(actionCommand)) {
                BGFileChooser fc = new BGFileChooser((Component)((Object)this));
                FileFilter[] ff = fc.getChoosableFileFilters();
                if (ff != null) {
                    for (int i = 0; i < ff.length; ++i) {
                        fc.removeChoosableFileFilter(ff[i]);
                    }
                }
                fc.addChoosableFileFilter((FileFilter)new BGFileFilter("pdf", "PDF \u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442"));
                if (fc.showSaveDialog((Component)JOptionPane.getRootFrame()) == 0) {
                    File file;
                    Object path = fc.getSelectedFile().getAbsolutePath();
                    if (!((String)path).regionMatches(true, ((String)path).length() - 4, ".pdf", 0, 4)) {
                        path = (String)path + ".pdf";
                    }
                    if ((file = new File((String)path)).exists()) {
                        String text = "\u0424\u0430\u0439\u043b " + file.getName() + " \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442. \u0417\u0430\u043c\u0435\u043d\u0438\u0442\u044c?";
                        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), text, "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 0) != 0) {
                            return;
                        }
                    }
                    switch (this.stylesheet.getType()) {
                        case FO: {
                            Request request = this.getRequest(this.documentPanel.getPageIndex() - 1);
                            request.setAttribute("contentType", "application/pdf");
                            this.stylesheet.save(file, this.getInputStream(request));
                            break;
                        }
                        case JR: {
                            this.stylesheet.save(file, null);
                            break;
                        }
                    }
                }
            }
        });
        ClientUtils.addOpenAction(this.docListNav, e -> this.showDocument(this.docListNav.getSelectedIndex()));
        this.bgPluginnedPanel.invokeInitBGPanel("bill", this.getModuleId());
    }

    private BGButton getToListButton() {
        BGButton toListButton = new BGButton("\u041a \u0441\u043f\u0438\u0441\u043a\u0443");
        toListButton.addActionListener(e -> this.firePropertyChange("toList", true, false));
        return toListButton;
    }

    private JPanel getScalePanel() {
        this.scale.removeAllItems();
        this.scale.addItem("25");
        this.scale.addItem("50");
        this.scale.addItem("75");
        this.scale.addItem("100");
        this.scale.addItem("125");
        this.scale.addItem("150");
        this.scale.addItem("175");
        this.scale.addItem("200");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(" \u041c\u0430\u0441\u0448\u0442\u0430\u0431: "));
        panel.add(this.scale, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        panel.setPreferredSize(new Dimension(100, panel.getPreferredSize().height));
        return panel;
    }

    private JPanel getPrintBPanel(ActionListener actionListener) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder("\u041f\u0435\u0447\u0430\u0442\u044c \u0431\u043b\u043e\u043a\u0430\u043c\u0438"));
        panel.add((Component)new JLabel("\u0420\u0430\u0437\u043c\u0435\u0440 \u0431\u043b\u043e\u043a\u0430:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.printBlockSize, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u0441 \u0431\u043b\u043e\u043a\u0430:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        panel.add((Component)this.printStartBlock, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        panel.add((Component)new BGButton("\u041f\u0435\u0447\u0430\u0442\u044c", "printB", actionListener), new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 10), 0, 0));
        return panel;
    }

    private JPanel getPrintPPanel(ActionListener actionListener) {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                String name = mouseEvent.getComponent().getName();
                if ("showDocFrom".equals(name)) {
                    ServiceConfigBillViewer.this.showDocument((int)ServiceConfigBillViewer.this.printDocFrom.getValue() - 1);
                } else if ("showDocTo".equals(name)) {
                    ServiceConfigBillViewer.this.showDocument(Math.min((int)ServiceConfigBillViewer.this.printDocTo.getValue(), ServiceConfigBillViewer.this.documentList.size()) - 1);
                }
            }
        };
        JLabel showDocFrom = new JLabel("*");
        showDocFrom.setName("showDocFrom");
        showDocFrom.setToolTipText("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
        showDocFrom.addMouseListener(mouseAdapter);
        JLabel showDocTo = new JLabel("*");
        showDocTo.setName("showDocTo");
        showDocTo.setToolTipText("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
        showDocTo.addMouseListener(mouseAdapter);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder("\u041f\u0435\u0447\u0430\u0442\u044c \u043f\u043e \u043d\u043e\u043c\u0435\u0440\u0430\u043c (\u0432\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u043e)"));
        panel.add((Component)new JLabel("\u0421 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.printDocFrom, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 1), 0, 0));
        panel.add((Component)showDocFrom, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u043f\u043e:"), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        panel.add((Component)this.printDocTo, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 1), 0, 0));
        panel.add((Component)showDocTo, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 5, 5), 0, 0));
        panel.add((Component)new BGButton("\u041f\u0435\u0447\u0430\u0442\u044c", "printP", actionListener), new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getPagePanel(String borderTitle, Component component) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new TitledBorder(borderTitle));
        panel.add(component, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    public void openDocuments(List<BillDoc> docList, boolean insertMode) {
        if (insertMode) {
            HashMap<Integer, ArrayList<BillDoc>> billMap = new HashMap<Integer, ArrayList<BillDoc>>();
            for (BillDoc billDoc : docList) {
                ArrayList<BillDoc> billList = (ArrayList<BillDoc>)billMap.get(billDoc.cid);
                if (billList == null) {
                    billList = new ArrayList<BillDoc>(3);
                    billMap.put(billDoc.cid, billList);
                }
                billList.add(billDoc);
            }
            for (int i = 0; i < this.documentList.size(); ++i) {
                List billList;
                BillDoc doc = this.documentList.get(i);
                BillDoc nextDoc = null;
                if (i < this.documentList.size() - 1) {
                    nextDoc = this.documentList.get(i + 1);
                }
                if (nextDoc != null && doc.cid == nextDoc.cid || (billList = (List)billMap.remove(doc.cid)) == null) continue;
                this.documentList.addAll(i + 1, billList);
                i += billList.size();
            }
            if (billMap.size() > 0) {
                for (List billList : billMap.values()) {
                    this.documentList.addAll(billList);
                }
            }
        } else {
            this.documentList = docList;
        }
        List idTitles = this.documentList.stream().map(f -> new IdTitle(f.docId, f.number)).collect(Collectors.toList());
        int index = 0;
        for (IdTitle idTitle : idTitles) {
            idTitle.setTitle(++index + ") " + idTitle.getTitle());
        }
        this.docListNav.setData(idTitles);
        this.documentPanel.setPageIndex(1);
        this.pagePanel.setPageIndex(1);
        this.documentPanel.setPageCount(this.documentList.size());
        this.setContractId(docList.get((int)0).cid);
        this.showDocument(0);
        this.xmlReset();
    }

    private Request getRequest(int pageNum) {
        Request request = null;
        if (pageNum < this.documentList.size()) {
            request = this.getRequest(this.documentList.get(pageNum));
        }
        return request;
    }

    private Request getRequest(BillDoc billDoc) {
        return new Request().setModule(this.module).setAction("ViewDocs").setModuleId(this.getModuleId()).setAttribute("type", billDoc.getTypeString()).setAttribute("codes", billDoc.docId);
    }

    private void setXML() {
        int num = this.documentPanel.getPageIndex() - 1;
        this.saveXmlButton.setEnabled(false);
        if (num < this.documentList.size()) {
            BillDoc billDoc = this.documentList.get(num);
            Request req = new Request().setModule(this.module).setAction("ViewDocsXml").setModuleId(this.getModuleId()).setAttribute("type", billDoc.getTypeString()).setAttribute("codes", billDoc.docId);
            Document doc = this.getDocument(req);
            if (ClientUtils.checkStatus((Document)doc)) {
                this.tryCall(() -> {
                    this.xmlText.setText(XMLUtils.serializeToString((Node)doc, (boolean)true));
                    this.xmlText.setCaretPosition(0);
                    this.xmlTreePanel.setDocument(doc);
                });
            }
        }
    }

    private void xmlReset() {
        boolean visible = this.xmlPanel.isVisible();
        if (visible) {
            this.xmlButton.doClick();
        }
    }

    private void xmlButton_actionPerformed(ActionEvent e) {
        boolean visible = this.xmlPanel.isVisible();
        if (!visible) {
            this.setXML();
        }
        this.xmlPanel.setVisible(!visible);
        this.xmlPanel.setDividerLocation(0.5);
        this.viewPanel.setVisible(visible);
    }

    private PrintPopup getPrintPopup() {
        if (this.printPopup == null) {
            this.printPopup = new PrintPopup();
        }
        return this.printPopup;
    }

    private class PrintPopup
    extends JPopupMenu {
        public PrintPopup() {
            this.setLayout(new GridLayout(2, 1));
            this.add(ServiceConfigBillViewer.this.getPrintBPanel(e -> ServiceConfigBillViewer.this.printBlock()));
            this.add(ServiceConfigBillViewer.this.getPrintPPanel(e -> ServiceConfigBillViewer.this.printRange()));
            this.pack();
        }
    }
}

