/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.server.service;

import jakarta.jws.WebService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.email.common.bean.AttributeRow;
import ru.bitel.bgbilling.modules.email.common.bean.AttributeValue;
import ru.bitel.bgbilling.modules.email.common.bean.Domain;
import ru.bitel.bgbilling.modules.email.common.service.EmailService;
import ru.bitel.bgbilling.modules.email.server.bean.Account;
import ru.bitel.bgbilling.modules.email.server.bean.AccountAttribute;
import ru.bitel.bgbilling.modules.email.server.bean.AccountAttributeManager;
import ru.bitel.bgbilling.modules.email.server.bean.AccountManager;
import ru.bitel.bgbilling.modules.email.server.bean.AttributeValueManager;
import ru.bitel.bgbilling.modules.email.server.bean.DomainManager;
import ru.bitel.bgbilling.modules.email.server.bean.EmailUtils;
import ru.bitel.bgbilling.modules.email.server.bean.ForwardManager;
import ru.bitel.bgbilling.modules.email.server.event.AccountCreatedEvent;
import ru.bitel.bgbilling.modules.email.server.event.AccountUpdateEvent;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.bgbilling.server.util.PswdGen;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.email.common.service.EmailService")
public class EmailServiceImpl
extends AbstractService
implements EmailService {
    public Domain domainGet(int domainId) throws BGException {
        return (Domain)this.tryReturn(() -> new DomainManager(this.getConnection(), this.moduleId).get(domainId));
    }

    public void domainDelete(int domainId) throws BGException {
        this.tryCall(() -> {
            DomainManager domainManager = new DomainManager(this.getConnection(), this.moduleId);
            Domain domain = domainManager.get(domainId);
            domainManager.delete(domainId);
            domainManager.getServiceActivator(domain).removeDomain(domain);
        });
    }

    public int domainUpdate(Domain domain) throws BGException {
        if (domain != null && Utils.isBlankString((String)domain.getName())) {
            throw new BGMessageException("\u041f\u043e\u043b\u0435 '\u0434\u043e\u043c\u0435\u043d' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c.");
        }
        return (Integer)this.tryReturn(() -> {
            DomainManager domainManager = new DomainManager(this.getConnection(), this.moduleId);
            domainManager.update(domain);
            domainManager.list(null).forEach(d -> {
                try {
                    domainManager.getServiceActivator((Domain)d).updateDomain((Domain)d);
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
            });
            return domain.getId();
        });
    }

    public List<Domain> domainList(String orderBy) throws BGException {
        return (List)this.tryReturn(() -> new DomainManager(this.getConnection(), this.moduleId).list(orderBy));
    }

    public List<AccountAttribute> attributeList() throws BGException {
        return (List)this.tryReturn(() -> new AccountAttributeManager((ParameterMap)this.getModuleSetup()).getAttributeList());
    }

    public List<AttributeRow> attributeRows(int attributeId) throws BGException {
        return (List)this.tryReturn(() -> {
            Map<Integer, AccountAttribute> attributeMap = new AccountAttributeManager((ParameterMap)this.getModuleSetup()).getAttributeMap();
            return new AttributeValueManager(this.getConnection(), this.moduleId).getValueList(attributeId).stream().map(a -> new AttributeRow().setId(a.getAttributeId()).setTitle(Optional.ofNullable((AccountAttribute)((Object)((Object)((Object)attributeMap.get(a.getAttributeId()))))).map(b -> b.getTitle()).orElse("??? (ID#" + a.getAttributeId() + ")")).setValue(a.getAttributeValue())).toList();
        });
    }

    public void attributeValueUpdate(int attributeId, List<AttributeValue> valueList) throws BGException {
        this.tryCall(() -> {
            AttributeValueManager valueManager = new AttributeValueManager(this.getConnection(), this.moduleId);
            AccountManager accountManager = new AccountManager(this.getConnection(), this.moduleId);
            Account account = accountManager.getAccountById(attributeId);
            if (account != null) {
                if (valueList.size() > 0) {
                    account.setForwardList(new ForwardManager(this.getConnection(), this.moduleId).getForwardList(attributeId));
                    account.setAttributes(valueList);
                    DomainManager domainManager = new DomainManager(this.getConnection(), this.moduleId);
                    Domain domain = domainManager.get(account.getDomainId());
                    if (domain != null) {
                        if (TimeUtils.dateInRange((Date)new Date(), (Date)account.getDate1(), (Date)account.getDate2())) {
                            domainManager.getServiceActivator(domain).modify(account);
                        }
                        valueManager.updateValues(attributeId, valueList);
                    }
                } else {
                    valueManager.updateValues(attributeId, valueList);
                }
            }
        });
    }

    public List<KeyValue> quotaList() throws BGException {
        ArrayList<KeyValue> values = new ArrayList<KeyValue>();
        String[] quotas = this.getModuleSetup().get("quota.list", "").split(";");
        int size = quotas.length;
        for (int i = 0; i < size; ++i) {
            String[] quota_title = quotas[i].trim().split(":");
            if (quota_title.length != 2 || Utils.parseLong((String)quota_title[0], (long)-1L) < 0L) continue;
            values.add(new KeyValue(quota_title[0], quota_title[1]));
        }
        return values;
    }

    public Account accountGet(int id) throws BGException {
        return new AccountManager(this.getConnection(), this.moduleId).getAccountById(id);
    }

    public int accountUpdate(int contractId, Account account, boolean autoPassword) throws BGException {
        return (Integer)this.tryReturn(() -> {
            String password = account.getPassword();
            if (autoPassword) {
                password = PswdGen.generatePassword((ParameterMap)this.getModuleSetup());
            } else {
                String error = ContractUtils.checkPassword((ParameterMap)this.getModuleSetup(), (String)password, (String)password);
                if (error != null) {
                    throw new BGMessageException(error);
                }
            }
            AccountManager accountManager = new AccountManager(this.getConnection(), this.moduleId);
            Account oldAccount = accountManager.getAccountById(account.getId());
            Calendar closedDate = null;
            closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionUpdateAccount", (int)this.moduleId, (int)this.userId);
            if (closedDate != null) {
                Date oldDate1 = null;
                Date oldDate2 = null;
                if (account != null) {
                    oldDate1 = oldAccount.getDate1();
                    oldDate2 = oldAccount.getDate2();
                }
                ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, (Date)oldDate1, (Date)oldDate2, (Date)account.getDate1(), (Date)account.getDate2());
            }
            if (!EmailUtils.checkAccountName(account.getAccount(), (ParameterMap)this.getModuleSetup())) {
                throw new BGMessageException("\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430!");
            }
            DomainManager domainManager = new DomainManager(this.getConnection(), this.moduleId);
            Domain domain = domainManager.get(account.getDomainId());
            if (domain == null) {
                throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0434\u043e\u043c\u0435\u043d \u0441 \u043a\u043e\u0434\u043e\u043c:" + account.getDomainId());
            }
            account.setPassword(password);
            try {
                String error = accountManager.checkAccount(account);
                if (Utils.notBlankString((String)error)) {
                    throw new BGException(error);
                }
                Date thisDate = new Date();
                if (account.getId() < 1) {
                    if (TimeUtils.dateInRange((Date)thisDate, (Date)account.getDate1(), (Date)account.getDate2())) {
                        domainManager.getServiceActivator(domain).create(account);
                    }
                } else {
                    boolean oldActual = TimeUtils.dateInRange((Date)thisDate, (Date)oldAccount.getDate1(), (Date)oldAccount.getDate2());
                    boolean newActual = TimeUtils.dateInRange((Date)thisDate, (Date)account.getDate1(), (Date)account.getDate2());
                    if (!oldActual && newActual) {
                        domainManager.getServiceActivator(domain).create(account);
                    } else if (!newActual) {
                        domainManager.getServiceActivator(domain).cancel(account);
                    } else if (oldActual && newActual) {
                        domainManager.getServiceActivator(domain).modify(account);
                    }
                }
                account.setNeedOpenAndNeedClose(thisDate);
                accountManager.updateAccount(account);
                if (account.getId() < 1) {
                    this.context.publishAfterCommit((Event)new AccountCreatedEvent(this.userId, this.moduleId, contractId, account.getAccount() + "@" + domain.getName()));
                } else {
                    this.context.publishAfterCommit((Event)new AccountUpdateEvent(this.userId, this.moduleId, contractId, account.getAccount() + "@" + domain.getName()));
                }
            }
            catch (BGException e) {
                this.getLogger().error("Can't update account", (Throwable)e);
                throw e;
            }
            return account.getId();
        });
    }
}

