/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client.contract;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGIntTextField;
import ru.bitel.bgbilling.client.common.field.BGTextArea;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObject;
import ru.bitel.bgbilling.kernel.contract.object.common.service.ContractObjectService;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.table.client.ParamRowData;
import ru.bitel.bgbilling.modules.voice.client.contract.VoiceAccountNumberEditorDialog;
import ru.bitel.bgbilling.modules.voice.client.contract.VoiceBaseAccountEditor;
import ru.bitel.bgbilling.modules.voice.client.device.VoiceDevicePanel;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccount;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccountType;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDevice;
import ru.bitel.bgbilling.modules.voice.common.bean.enums.VoiceAccountStatus;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceAccountService;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceDeviceService;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.IdTitle;

public class VoiceAccountEditorForm
extends VoiceBaseAccountEditor {
    private ParamRowData paramDevice = new ParamRowData("device", "\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e", "");
    private ParamRowData paramNumber = new ParamRowData("number", "\u041d\u043e\u043c\u0435\u0440 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430", "");
    private ParamRowData paramLines = new ParamRowData("lines", "\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043b\u0438\u043d\u0438\u0439", "1");
    private ParamRowData paramPorts = new ParamRowData("ports", "\u041f\u043e\u0440\u0442\u044b", "");
    private ParamRowData paramLogin = new ParamRowData("login", "\u041b\u043e\u0433\u0438\u043d", "");
    private ParamRowData paramPassword = new ParamRowData("password", "\u041f\u0430\u0440\u043e\u043b\u044c", "");
    private ParamRowData paramAutoPassword = new ParamRowData("autoPassword", "\u0410\u0432\u0442\u043e\u043c. \u0433\u0435\u043d\u0435\u0440. \u043f\u0430\u0440\u043e\u043b\u044f", "");
    private static final String ACCOUNT_TYPE_CHANGED_ACTION = "account_type_changed";
    private VoiceDeviceService deviceService;
    private VoiceAccountService accountService;
    private Directory<VoiceAccountType> accountTypeDirectory;
    private final AtomicReference<VoiceAccount> currentAccount;
    private BGTextField accountId = new BGTextField(6);
    private BGUComboBox<VoiceAccountType> accountTypeCombobox = new BGUComboBox();
    private BGControlPanelPeriod period = new BGControlPanelPeriod();
    private BGUComboBox<IdTitle> status = new BGUComboBox();
    private BGTextArea comment = new BGTextArea(5, 100);
    private JComponent sessionCountLimitPanel;
    private BGIntTextField sessionCountLimit = new BGIntTextField();
    private BGUComboBox<ContractObject> contractObjectField;
    private JComponent contractObjectPanel;

    public VoiceAccountEditorForm(AtomicReference<VoiceAccount> currentAccount) throws BGException {
        this.currentAccount = currentAccount;
        this.setLayout(new BorderLayout());
        this.paramTableModel = new VoiceBaseAccountEditor.ParamTableModel(this);
        this.params = Arrays.asList(this.paramLines, this.paramPorts, this.paramLogin, this.paramPassword);
        this.accountService = (VoiceAccountService)((ClientContext)this.getContext()).getPort(VoiceAccountService.class);
        this.accountTypeDirectory = ((ClientContext)this.getContext()).getDirectory(VoiceAccountType.class);
        this.deviceService = (VoiceDeviceService)((ClientContext)this.getContext()).getPort(VoiceDeviceService.class);
    }

    protected void jbInit() throws Exception {
        ActionListener editorsListener = e -> {
            String command = e.getActionCommand();
            if ("device.selected".equals(command)) {
                VoiceDevicePanel panel = (VoiceDevicePanel)((Object)((Object)e.getSource()));
                VoiceDevice selectedDevice = (VoiceDevice)panel.getSelectedDevice();
                this.currentAccount.get().setDeviceId(selectedDevice.getId());
                this.paramDevice.setValue(this.getDeviceName(selectedDevice));
            }
            ((BGUPanel)e.getSource()).performActionClose();
        };
        BGEditor editor = new BGEditor("main");
        editor.addForm((JComponent)this.getMainPanel(), (Object)"main");
        editor.addForm((JComponent)BGSwingUtilites.wrapBorder((JPanel)((Object)new VoiceDevicePanel((ClientContext)this.getContext(), 2, editorsListener)), (String)"\u0412\u044b\u0431\u043e\u0440 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430"));
        this.setLayout(new BorderLayout());
        this.add((Component)editor, "Center");
    }

    private JPanel getMainPanel() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    ParamRowData paramRowData = (ParamRowData)VoiceAccountEditorForm.this.paramTableModel.getSelectedRow();
                    if (VoiceAccountEditorForm.this.paramDevice.equals(paramRowData)) {
                        VoiceAccountEditorForm.this.performAction("device.select", String.valueOf(VoiceAccountEditorForm.this.currentAccount.get().getDeviceId()));
                    } else if (VoiceAccountEditorForm.this.paramAutoPassword.equals(paramRowData)) {
                        boolean newValue = Boolean.valueOf(VoiceAccountEditorForm.this.paramAutoPassword.getValue()) == false;
                        VoiceAccountEditorForm.this.paramAutoPassword.setValue(String.valueOf(newValue));
                        VoiceAccountEditorForm.this.paramPassword.setValue(newValue ? "" : VoiceAccountEditorForm.this.currentAccount.get().getPassword());
                    } else if (VoiceAccountEditorForm.this.paramNumber.equals(paramRowData)) {
                        new VoiceAccountNumberEditorDialog("\u0412\u044b\u0431\u043e\u0440 \u043d\u043e\u043c\u0435\u0440\u0430 \u0438\u0437 \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432", VoiceAccountEditorForm.this.currentAccount.get(), (ClientContext)VoiceAccountEditorForm.this.getContext()).open();
                        if (VoiceAccountEditorForm.this.currentAccount.get().getNumber() > 0L) {
                            VoiceAccountEditorForm.this.paramNumber.setValue(String.valueOf(VoiceAccountEditorForm.this.currentAccount.get().getNumber()));
                        }
                    }
                    VoiceAccountEditorForm.this.paramTableModel.fireTableDataChanged();
                }
            }
        };
        FontUIResource font = (FontUIResource)UIManager.get("Table.font");
        font = new FontUIResource(font.deriveFont(font.getSize2D() + 2.0f));
        int fontHeight = this.getFontMetrics(font).getHeight() + 3;
        JPopupMenu paramTableDynamicPopupMenu = new JPopupMenu(){

            @Override
            public void show(Component invoker, int x, int y) {
                this.removeAll();
                VoiceAccountEditorForm.this.getPopupMenu(this);
                super.show(invoker, x, y);
            }
        };
        BGUTable paramTable = new BGUTable((TableModel)((Object)this.paramTableModel));
        paramTable.setFont((Font)font);
        paramTable.setRowHeight(fontHeight);
        paramTable.setSelectionMode(0);
        paramTable.addMouseListener((MouseListener)mouseAdapter);
        paramTable.setComponentPopupMenu(paramTableDynamicPopupMenu);
        paramTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\u007f') {
                    VoiceAccountEditorForm.this.deleteParamValue();
                }
            }
        });
        paramTable.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        JPanel topRowPanel = this.initTopRowPanel();
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.add((Component)topRowPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add((Component)new JScrollPane((Component)paramTable), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 3, 0, 3), 0, 0));
        this.contractObjectPanel = this.createObjectPanel();
        mainPanel.add((Component)this.contractObjectPanel, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 3, 3), 0, 0));
        mainPanel.add((Component)BGSwingUtilites.wrapBorder((JComponent)new JScrollPane((Component)this.comment), (String)"\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 3, 3, 3), 0, 0));
        return mainPanel;
    }

    private void getPopupMenu(JPopupMenu tableJPopupMenu) {
        ParamRowData _paramRowData = (ParamRowData)this.paramTableModel.getSelectedRow();
        String paramRowValue = _paramRowData != null ? _paramRowData.getValue() : null;
        tableJPopupMenu.add("\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440").addActionListener(e -> this.deleteParamValue());
        tableJPopupMenu.add("\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435").addActionListener(e -> {
            if (paramRowValue != null) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(paramRowValue), null);
            }
        });
    }

    private JComponent createObjectPanel() {
        JPanel objectPanel = new JPanel(new GridBagLayout());
        objectPanel.setBorder(BorderFactory.createTitledBorder("\u041e\u0431\u044a\u0435\u043a\u0442"));
        objectPanel.setVisible(false);
        this.contractObjectField = new BGUComboBox();
        objectPanel.add((Component)this.contractObjectField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 3, 3, 3), 0, 0));
        return objectPanel;
    }

    private JPanel initTopRowPanel() {
        this.accountId.setEditable(false);
        this.accountId.setHorizontalAlignment(0);
        JPanel topRowPanel = new JPanel(new GridBagLayout());
        topRowPanel.add((Component)BGSwingUtilites.wrapBorder(this.accountTypeCombobox, (String)"\u0422\u0438\u043f \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430"), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        topRowPanel.add((Component)BGSwingUtilites.wrapBorder((JComponent)this.accountId, (String)"ID#"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 3, 3), 0, 0));
        topRowPanel.add((Component)BGSwingUtilites.wrapBorder((JPanel)this.period, (String)"\u041f\u0435\u0440\u0438\u043e\u0434"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 3, 3), 0, 0));
        topRowPanel.add((Component)BGSwingUtilites.wrapBorder(this.status, (String)"\u0421\u0442\u0430\u0442\u0443\u0441"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 3, 3), 0, 0));
        this.sessionCountLimitPanel = BGSwingUtilites.wrapBorder((JComponent)this.sessionCountLimit, (String)"\u041a\u043e\u043b-\u0432\u043e \u0441\u0435\u0441\u0441\u0438\u0439");
        topRowPanel.add((Component)this.sessionCountLimitPanel, new GridBagConstraints(-1, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.accountTypeCombobox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.performAction(ACCOUNT_TYPE_CHANGED_ACTION);
            }
        });
        this.initStatusData();
        return topRowPanel;
    }

    private void initStatusData() {
        ArrayList<IdTitle> statusData = new ArrayList<IdTitle>();
        statusData.add(VoiceAccountStatus.STATUS_ON.toIdTitle());
        statusData.add(VoiceAccountStatus.STATUS_OFF.toIdTitle());
        this.status.setData(statusData);
    }

    public void newAccount(VoiceAccount voiceAccount) throws Exception {
        this.currentAccount.set(voiceAccount);
        this.currentAccount.get().setContractId(((ClientContext)this.getContext()).getContractId());
        this.loadData();
        this.paramTableModel.deleteRows();
        this.accountTypeCombobox.setEnabled(true);
        this.accountTypeCombobox.setSelectedIndex(this.accountTypeCombobox.getItemCount() == 2 ? 1 : 0);
        this.accountId.setText("");
        this.period.setLocalDateFrom(LocalDate.now());
        this.period.setLocalDateTo(null);
        this.comment.setText("");
        this.paramNumber.reset();
        this.paramLines.setValue("1");
        this.paramLogin.reset();
        this.paramDevice.reset();
        this.paramPassword.reset();
        this.paramAutoPassword.setValue("true");
    }

    public void editAccount(VoiceAccount voiceAccount) throws Exception {
        this.currentAccount.set(voiceAccount);
        if (this.currentAccount.get() == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435!");
            return;
        }
        this.loadData();
        VoiceAccountType accountType = (VoiceAccountType)this.accountTypeDirectory.get(this.currentAccount.get().getTypeId());
        this.accountTypeCombobox.setSelectedItem((Object)accountType);
        this.paramDevice.setValue(this.getDeviceName((VoiceDevice)this.deviceService.deviceGet(this.currentAccount.get().getDeviceId())));
        if (accountType.isCheckPassword()) {
            this.paramPassword.setValue(this.currentAccount.get().getPassword());
            this.paramAutoPassword.setValue("false");
        }
        this.accountId.setText(String.valueOf(this.currentAccount.get().getId()));
        this.accountTypeCombobox.setEnabled(false);
        this.period.setDateFrom(this.currentAccount.get().getDateFrom());
        this.period.setDateTo(this.currentAccount.get().getDateTo());
        this.comment.setText(this.currentAccount.get().getComment());
        this.status.setSelectedItem((Object)this.currentAccount.get().getStatus());
        this.paramLogin.setValue(this.currentAccount.get().getLogin());
        this.paramNumber.setValue(String.valueOf(this.currentAccount.get().getNumber()));
        this.paramLines.setValue(String.valueOf(this.currentAccount.get().getLineCount()));
        this.paramPorts.setValue(this.currentAccount.get().getPorts());
        this.sessionCountLimit.setValue((long)this.currentAccount.get().getSessionCountLimit());
        this.contractObjectField.setSelectedItem((Object)this.currentAccount.get().getContractObjectId());
        this.sessionCountLimit.setValue(accountType.isSessionCountLimitLock() ? (long)accountType.getSessionCountLimit() : (long)this.currentAccount.get().getSessionCountLimit());
        this.paramTableModel.fireTableDataChanged();
    }

    public boolean checkAccount() {
        VoiceAccountType selectedAccountType = (VoiceAccountType)this.accountTypeCombobox.getSelectedItem();
        if (selectedAccountType == null) {
            return true;
        }
        if (selectedAccountType.isNeedLines() && !this.paramLines.getValue().matches("^[0-9]+$")) {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \"\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043b\u0438\u043d\u0438\u0439\"");
            return false;
        }
        return true;
    }

    public void saveAccount() throws Exception {
        this.currentAccount.get().setComment(this.comment.getText());
        this.currentAccount.get().setDateFrom(this.period.getDateFrom());
        this.currentAccount.get().setDateTo(this.period.getDateTo());
        VoiceAccountType selectedType = (VoiceAccountType)this.accountTypeCombobox.getSelectedItem();
        if (selectedType != null) {
            this.currentAccount.get().setTypeId(selectedType.getId());
            if (selectedType.isCheckPassword()) {
                this.currentAccount.get().setPassword(this.paramPassword.getValue());
            }
        }
        this.currentAccount.get().setStatus(VoiceAccountStatus.getVoiceAccountStatus((int)((IdTitle)this.status.getSelectedItem()).getId()));
        this.currentAccount.get().setLogin(this.paramLogin.getValue());
        this.currentAccount.get().setPorts(this.paramPorts.getValue());
        this.currentAccount.get().setNumber(Utils.parseLong((String)this.paramNumber.getValue(), (long)0L));
        this.currentAccount.get().setLineCount(Utils.parseInt((String)this.paramLines.getValue(), (int)0));
        this.currentAccount.get().setSessionCountLimit((byte)this.sessionCountLimit.getValue());
        if (this.contractObjectField.getSelectedItem() != null) {
            this.currentAccount.get().setContractObjectId(((ContractObject)this.contractObjectField.getSelectedItem()).getId());
        }
        this.currentAccount.get().setId(this.accountService.voiceAccountUpdate(this.currentAccount.get()));
        if (Boolean.valueOf(this.paramAutoPassword.getValue()).booleanValue()) {
            this.accountService.voiceAccountPasswordGenerate(this.currentAccount.get().getId());
        }
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction(ACCOUNT_TYPE_CHANGED_ACTION, "\u0418\u0437\u043c\u0435\u043d\u0438\u043b\u0441\u044f \u0442\u0438\u043f \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceAccountType selectedAccountType = (VoiceAccountType)VoiceAccountEditorForm.this.accountTypeCombobox.getSelectedItem();
                if (selectedAccountType == null) {
                    return;
                }
                VoiceAccountEditorForm.this.paramTableModel.deleteRows();
                VoiceAccountEditorForm.this.addParamToParamTable(selectedAccountType.isNeedDevice(), VoiceAccountEditorForm.this.paramDevice);
                VoiceAccountEditorForm.this.addParamToParamTable(selectedAccountType.isNeedLogin(), VoiceAccountEditorForm.this.paramLogin);
                VoiceAccountEditorForm.this.addParamToParamTable(selectedAccountType.isCheckPassword(), VoiceAccountEditorForm.this.paramPassword);
                VoiceAccountEditorForm.this.addParamToParamTable(selectedAccountType.isCheckPassword(), VoiceAccountEditorForm.this.paramAutoPassword);
                VoiceAccountEditorForm.this.addParamToParamTable(selectedAccountType.isNeedPorts(), VoiceAccountEditorForm.this.paramPorts);
                VoiceAccountEditorForm.this.addParamToParamTable(selectedAccountType.isNeedPhone(), VoiceAccountEditorForm.this.paramNumber);
                VoiceAccountEditorForm.this.addParamToParamTable(selectedAccountType.isNeedLines(), VoiceAccountEditorForm.this.paramLines);
                VoiceAccountEditorForm.this.sessionCountLimitPanel.setVisible(!selectedAccountType.isSessionCountLimitLock());
                VoiceAccountEditorForm.this.contractObjectPanel.setVisible(selectedAccountType.isNeedObject());
                if (VoiceAccountEditorForm.this.currentAccount.get().getId() <= 0) {
                    VoiceAccountEditorForm.this.sessionCountLimit.setValue((long)selectedAccountType.getSessionCountLimit());
                    Preferences typeConfig = new Preferences(selectedAccountType.getConfig(), "\n\r");
                    int constDeviceId = typeConfig.getInt("const.device.id", -1);
                    if (constDeviceId > 0) {
                        VoiceAccountEditorForm.this.currentAccount.get().setDeviceId(constDeviceId);
                    }
                    if (selectedAccountType.isNeedDevice()) {
                        try {
                            VoiceDevice deviceSelected = (VoiceDevice)VoiceAccountEditorForm.this.deviceService.deviceGet(constDeviceId);
                            VoiceAccountEditorForm.this.paramDevice.setValue(deviceSelected != null ? VoiceAccountEditorForm.this.getDeviceName(deviceSelected) : "");
                        }
                        catch (BGException ex) {
                            ClientUtils.showErrorMessageDialog((Throwable)ex);
                        }
                    }
                    VoiceAccountEditorForm.this.currentAccount.get().setEntitySpecId(selectedAccountType.getEntitySpecId());
                    this.firePropertyChange("changeAccountType", 0, selectedAccountType.getEntitySpecId());
                }
                VoiceAccountEditorForm.this.paramTableModel.fireTableDataChanged();
            }
        };
    }

    private void loadObjects() {
        this.tryCall(() -> {
            int contractObjectId = ((ClientContext)this.getContext()).getObjectId();
            ArrayList<ContractObject> contractObjectList = ((ContractObjectService)((ClientContext)this.getContext()).getPort(ContractObjectService.class, 0)).contractObjectList(this.currentAccount.get().getContractId());
            contractObjectList = new ArrayList<ContractObject>(contractObjectId > 0 ? (Collection)contractObjectList.stream().filter(a -> a.getId() == contractObjectId).collect(Collectors.toList()) : contractObjectList);
            if (contractObjectId < 1) {
                contractObjectList.add(0, new ContractObject().setTitle("---"));
            }
            this.contractObjectField.setData(contractObjectList);
        });
    }

    private void loadData() throws Exception {
        ArrayList<VoiceAccountType> typeList = new ArrayList<VoiceAccountType>();
        VoiceAccountType emptyType = new VoiceAccountType();
        emptyType.setTitle("----------");
        typeList.add(emptyType);
        typeList.addAll(this.accountTypeDirectory.list());
        this.accountTypeCombobox.setData(typeList);
        this.loadObjects();
    }
}

