/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.worker;

import java.util.Iterator;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.MDC;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.worker.AccountingWorkerTask;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetConnectionStatus;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.jmx.MBeanAttribute;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.FrequencyCounter;

public class SessionFinishWorker
extends AccountingWorkerTask {
    private volatile int finishBatchSize;
    private volatile long lockTimeout;
    private final Accounting accounting;
    private final Iterable<? extends InetConnectionRuntime> sessions;
    private Iterator<? extends InetConnectionRuntime> iterator;
    private final FrequencyCounter checkedPerMinute = new FrequencyCounter(60L, TimeUnit.SECONDS);
    private final FrequencyCounter finishedPerMinute = new FrequencyCounter(60L, TimeUnit.SECONDS);

    public SessionFinishWorker(Accounting accounting, ScheduledExecutorService scheduledExecutorService, String name, ParameterMap params, ParameterMap defaultParams, Iterable<? extends InetConnectionRuntime> sessions) {
        super(scheduledExecutorService, name, params, defaultParams);
        this.accounting = accounting;
        this.sessions = sessions;
        int finishBatchSize = params.getInt("finishBatchSize", defaultParams.getInt("finishBatchSize", 0));
        if (finishBatchSize <= 0) {
            finishBatchSize = Integer.MAX_VALUE;
        }
        this.finishBatchSize = finishBatchSize;
        this.lockTimeout = params.getLong("lockTimeout", defaultParams.getLong("lockTimeout", 15000L));
        this.getLogger().info("Add finishing worker: delay={}, batchSize={}, finishBatchSize={}, lockTimeout={}", new Object[]{this.getDelay(), this.batchSize, finishBatchSize, this.lockTimeout});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runImpl() throws Exception {
        this.getLogger().debug("Run SessionFinishWorker...");
        if (this.iterator == null || !this.iterator.hasNext()) {
            this.iterator = this.sessions.iterator();
        }
        ConnectionSet connectionSet = ((ServerContext)this.context).getConnectionSet();
        try (BalanceDao balanceDao = new BalanceDao(connectionSet.getConnection());){
            long nowMillis = System.currentTimeMillis();
            long nowSeconds = nowMillis / 1000L;
            int count = 0;
            int countFinished = 0;
            int batchSize = this.batchSize;
            int finishBatchSize = this.finishBatchSize;
            while (count < batchSize && countFinished < finishBatchSize && this.iterator.hasNext()) {
                InetConnectionRuntime connectionRuntime = this.iterator.next();
                InetConnection connection = connectionRuntime.connection;
                try {
                    MDC.put((String)"worker", (String)("SessionFinishWorker-" + this.name));
                    MDC.put((String)"contractId", (String)String.valueOf(connectionRuntime.contractId));
                    MDC.put((String)"inetServId", (String)String.valueOf(connectionRuntime.inetServId));
                    MDC.put((String)"sessionId", (String)String.valueOf(connectionRuntime.sessionId));
                    if (this.getLogger().isTraceEnabled()) {
                        this.getLogger().trace("connectionRuntime.connection = {}", (Object)connectionRuntime.connection);
                    }
                    if (connection == null) {
                        this.getLogger().trace("skip connection (0)");
                        continue;
                    }
                    if (this.getLogger().isTraceEnabled()) {
                        this.getLogger().trace("connection.getConnectionStatus() = {} [{}]", (Object)connection.getConnectionStatus().name(), (Object)connection.getConnectionStatus());
                        this.getLogger().trace("accounting.getDisableServIds() = {}", (Object)Utils.toString(this.accounting.getDisableServIds()));
                    }
                    if (connection.getConnectionStatus() == InetConnectionStatus.STATUS_CLOSED && this.accounting.getDisableServIds().contains(connectionRuntime.inetServId)) {
                        if (!connectionRuntime.inetServRuntime.tryLock()) {
                            this.getLogger().trace("skip connection (1)");
                            continue;
                        }
                        this.getLogger().trace("connectionRuntime.inetServRuntime.tryLock() (1)");
                    } else if (this.lockTimeout > 0L) {
                        if (!connectionRuntime.inetServRuntime.tryLock(this.lockTimeout, TimeUnit.MILLISECONDS)) {
                            if (!this.getLogger().isTraceEnabled()) continue;
                            this.getLogger().trace("lockTimeout = {}", (Object)this.lockTimeout);
                            this.getLogger().trace("skip connection (2)");
                            continue;
                        }
                        if (this.getLogger().isTraceEnabled()) {
                            this.getLogger().trace("connectionRuntime.inetServRuntime.tryLock( {} ) (2)", (Object)this.lockTimeout);
                        }
                    } else {
                        this.getLogger().trace("connectionRuntime.inetServRuntime.lock() (3)");
                        connectionRuntime.inetServRuntime.lock();
                    }
                    try {
                        this.getLogger().trace("connectionRuntime.tryFinish");
                        if (connectionRuntime.tryFinish(this.accounting, connectionSet, balanceDao, nowSeconds, nowMillis)) {
                            ++countFinished;
                            if (this.getLogger().isTraceEnabled()) {
                                this.getLogger().trace("countFinished = {}", (Object)countFinished);
                            }
                        }
                        ++count;
                    }
                    finally {
                        connectionRuntime.inetServRuntime.unlock();
                        this.getLogger().trace("connectionRuntime.inetServRuntime.unlock()");
                    }
                }
                finally {
                    MDC.remove((String)"worker");
                    MDC.remove((String)"contractId");
                    MDC.remove((String)"inetServId");
                    MDC.remove((String)"sessionId");
                }
            }
            connectionSet.close();
            long nowMillis2 = System.currentTimeMillis();
            long duration = nowMillis2 - nowMillis;
            this.checkedPerMinute.add(nowMillis2, (long)count);
            this.finishedPerMinute.add(nowMillis2, (long)countFinished);
            this.processTimePerMinute.add(nowMillis2, duration);
            this.processTimePerTenMinutes.add(nowMillis2, duration);
            this.invokePerMinute.add(nowMillis2, 1L);
            this.invokePerTenMinutes.add(nowMillis2, 1L);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Finished " + countFinished + " " + this.name + " (checked " + count + ") sessions for " + duration + " ms.");
            }
        }
    }

    @MBeanAttribute
    public int getFinishBatchSize() {
        return this.finishBatchSize;
    }

    public void setFinishBatchSize(int finishBatchSize) {
        if (finishBatchSize <= 0) {
            finishBatchSize = Integer.MAX_VALUE;
        }
        this.finishBatchSize = finishBatchSize;
    }

    @MBeanAttribute
    public long getLockTimeout() {
        return this.lockTimeout;
    }

    public void setLockTimeout(long lockTimeout) {
        this.lockTimeout = lockTimeout;
    }

    @MBeanAttribute
    public long getCheckedPerMinute() {
        return this.checkedPerMinute.get(System.currentTimeMillis());
    }

    @MBeanAttribute
    public long getFinishedPerMinute() {
        return this.finishedPerMinute.get(System.currentTimeMillis());
    }
}

