/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.certificate.client;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.BGClient;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGScrollPane;
import ru.bitel.bgbilling.client.common.BGSelectFilePanel;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextArea;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.admin.certificate.common.bean.AliasEntry;
import ru.bitel.bgbilling.kernel.admin.certificate.common.bean.Ans1Block;
import ru.bitel.bgbilling.kernel.admin.certificate.common.bean.CertificateHolder;
import ru.bitel.bgbilling.kernel.admin.certificate.common.bean.OidMap;
import ru.bitel.bgbilling.kernel.admin.certificate.common.service.CertificateService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.GuiTitlable;

public class CertificateManagerPanel
extends BGUTabPanel {
    public static final String TAB_ID = "certificate";
    private boolean foundKeystore = false;
    private CardLayout cardLayout = new CardLayout();
    private JPanel cardPanel = new JPanel(this.cardLayout);
    private CertificatePanel certificatePanel = new CertificatePanel();
    private AliasTableModel aliasTableModel = new AliasTableModel();
    private JTextArea entryText = new JTextArea(10, 10);
    private BGUList<KeyValue> caCertList = new BGUList();

    public CertificateManagerPanel() {
        super(new ClientContext("admin", 0, 0, CertificateManagerPanel.class.getPackage().getName() + ".setup"), TAB_ID, "\u0421\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u044b");
    }

    protected void jbInit() {
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(1, (Component)this.getInfoPanel(), (Component)this.getCertificatePanel(), 400L);
        this.setLayout(new GridBagLayout());
        this.add((Component)splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.performAction("refresh");
    }

    public JPanel getInfoPanel() {
        this.entryText.setMargin(new Insets(3, 3, 3, 3));
        this.entryText.setLineWrap(true);
        this.entryText.setWrapStyleWord(false);
        BGUTable table = new BGUTable((TableModel)((Object)this.aliasTableModel));
        table.setSelectionMode(0);
        BGSwingUtilites.handleLDMouseClicked((Component)table, e -> this.tableMouseClicked((MouseEvent)e));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new BGScrollPane((Component)table, 300, 300), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.getCAPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        return panel;
    }

    private void tableMouseClicked(MouseEvent event) {
        AliasEntry aliasEntry = (AliasEntry)this.aliasTableModel.getSelectedRow();
        if (aliasEntry != null) {
            this.tryCall(() -> {
                String text = "";
                if (aliasEntry.getEntryType().equals((Object)AliasEntry.EntryType.CERTIFICATE)) {
                    CertificateHolder certificateHolder = ((CertificateService)((ClientContext)this.getContext()).getWebService(CertificateService.class, 0)).certificateGet(aliasEntry.getAlias(), 0);
                    CertificateFactory certificateFactory = CertificateFactory.getInstance(certificateHolder.getType());
                    this.certificatePanel.setCertificate(certificateFactory.generateCertificate(new ByteArrayInputStream(certificateHolder.getEncoded())));
                    this.certificatePanel.setPrivateKey(null);
                    this.cardLayout.show(this.cardPanel, TAB_ID);
                } else if (aliasEntry.getEntryType().equals((Object)AliasEntry.EntryType.KEY)) {
                    CertificateHolder certificateHolder = ((CertificateService)((ClientContext)this.getContext()).getWebService(CertificateService.class, 0)).certificateGet(aliasEntry.getAlias(), 0);
                    CertificateFactory certificateFactory = CertificateFactory.getInstance(certificateHolder.getType());
                    this.certificatePanel.setCertificate(certificateFactory.generateCertificate(new ByteArrayInputStream(certificateHolder.getEncoded())));
                    this.certificatePanel.setPrivateKey(((CertificateService)((ClientContext)this.getContext()).getWebService(CertificateService.class, 0)).keyGet(aliasEntry.getAlias()).toString());
                    this.cardLayout.show(this.cardPanel, TAB_ID);
                } else {
                    this.cardLayout.show(this.cardPanel, "empty");
                }
                this.entryText.setText(text);
            });
        }
    }

    private JPanel getCAPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041a\u043e\u0440\u043d\u0435\u0432\u044b\u0435 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u044b:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane((Component)this.caCertList), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    public JPanel getCertificatePanel() {
        this.entryText.setMargin(new Insets(5, 5, 5, 5));
        this.entryText.setEditable(false);
        this.cardPanel.add((Component)new JPanel(), "empty");
        this.cardPanel.add((Component)new JScrollPane(this.entryText), "text");
        this.cardPanel.add((Component)((Object)this.certificatePanel), TAB_ID);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.cardPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            CertificateService certificateService = (CertificateService)((ClientContext)this.getContext()).getWebService(CertificateService.class, 0);
            if (!this.foundKeystore) {
                this.foundKeystore = certificateService.checkKeystore();
                if (!this.foundKeystore && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0424\u0430\u0439\u043b keystore.p12 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d. \u0421\u043e\u0437\u0434\u0430\u0442\u044c \u043d\u043e\u0432\u044b\u0439?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 0, 3) == 0) {
                    this.foundKeystore = certificateService.createKeystore();
                }
            }
            if (this.foundKeystore) {
                this.aliasTableModel.setData(certificateService.aliasEntryList());
                this.caCertList.setData(certificateService.caCertList());
            }
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            if (!this.foundKeystore) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d keystore");
            } else {
                new CertificateSetDialog("\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442", "").open();
            }
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            if (!this.foundKeystore) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d keystore");
                return;
            }
            AliasEntry aliasEntry = (AliasEntry)this.aliasTableModel.getSelectedRow();
            if (aliasEntry == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443");
                return;
            }
            if (JOptionPane.showConfirmDialog((Component)BGClient.getFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u0443\u044e \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u044c?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 0) == 0) {
                ((CertificateService)((ClientContext)this.getContext()).getWebService(CertificateService.class, 0)).aliasEntryDelete(aliasEntry.getAlias());
                this.performAction("refresh");
            }
        });
    }

    class CertificatePanel
    extends BGUPanel {
        private Certificate certificate;
        private String certText = null;
        private String privateKey = null;
        private JButton privateKeyData = new JButton("\u041f\u0440\u0438\u0432\u0430\u0442\u043d\u044b\u0439 \u043a\u043b\u044e\u0447");
        private JTabbedPane tabbedPane = new JTabbedPane();
        private KeyValueModel generalTableModel = new KeyValueModel("general", 200);
        private KeyValueModel subjectTableModel = new KeyValueModel("subject", 300);
        private KeyValueModel issuerTableModel = new KeyValueModel("issuer", 300);
        private BGUList<ExtensionBlock> extensionList = new BGUList();

        CertificatePanel() {
        }

        protected void jbInit() {
            this.setLayout(new GridBagLayout());
            this.add(this.getTitlePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.getTopPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.getExtensionPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.getButtonPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        }

        private JPanel getTitlePanel() {
            JLabel label = new JLabel("\u0421\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442 X509");
            label.setFont(label.getFont().deriveFont(label.getFont().getSize2D() * 1.5f));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 1, new Insets(10, 10, 10, 0), 0, 0));
            return panel;
        }

        private JPanel getTopPanel() {
            this.tabbedPane.add((Component)this.getSubjectPanel(), "Subject");
            this.tabbedPane.add((Component)this.getIssuerPanel(), "Issuer");
            Dimension dimension = new Dimension(100, 250);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setMinimumSize(dimension);
            panel.setPreferredSize(dimension);
            panel.add((Component)this.getGeneralPanel(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.tabbedPane, new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getGeneralPanel() {
            BGUTable table = new BGUTable((TableModel)((Object)this.generalTableModel));
            table.setSelectionMode(0);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("\u0411\u0430\u0437\u043e\u0432\u044b\u0435"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
            panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getSubjectPanel() {
            BGUTable table = new BGUTable((TableModel)((Object)this.subjectTableModel));
            table.setSelectionMode(0);
            Dimension dimension = new Dimension(800, 250);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setMinimumSize(dimension);
            panel.setPreferredSize(dimension);
            panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getIssuerPanel() {
            BGUTable table = new BGUTable((TableModel)((Object)this.issuerTableModel));
            table.setSelectionMode(0);
            Dimension dimension = new Dimension(800, 250);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setMinimumSize(dimension);
            panel.setPreferredSize(dimension);
            panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getExtensionPanel() {
            this.extensionList.setSelectionMode(0);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Extensions"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
            panel.add((Component)BGSwingUtilites.wrapScrollPane(this.extensionList, (int)500, (int)250), new GridBagConstraints(-1, 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.getExtensionDataPanel(), new GridBagConstraints(-1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getExtensionDataPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            return panel;
        }

        private JPanel getButtonPanel() {
            JButton certTextButton = new JButton("\u0422\u0435\u043a\u0441\u0442 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430");
            certTextButton.addActionListener(e -> {
                BGTextArea txt = new BGTextArea(40, 60);
                txt.setEditable(false);
                txt.setText(this.certText);
                JScrollPane scrollPane = new JScrollPane((Component)txt);
                txt.setCaretPosition(0);
                JOptionPane.showMessageDialog((Component)BGClient.getFrame(), scrollPane, "\u0422\u0435\u043a\u0441\u0442 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430", 1);
            });
            JButton publicKeyData = new JButton("\u041f\u0443\u0431\u043b\u0438\u0447\u043d\u044b\u0439 \u043a\u043b\u044e\u0447");
            publicKeyData.addActionListener(e -> {
                BGTextArea txt = new BGTextArea(20, 60);
                txt.setEditable(false);
                txt.setText(this.certificate.getPublicKey().toString());
                JOptionPane.showMessageDialog((Component)BGClient.getFrame(), new JScrollPane((Component)txt), "\u041f\u0443\u0431\u043b\u0438\u0447\u043d\u044b\u0439 \u043a\u043b\u044e\u0447", 1);
            });
            this.privateKeyData.addActionListener(e -> {
                BGTextArea txt = new BGTextArea(20, 60);
                txt.setEditable(false);
                txt.setText(this.privateKey);
                JOptionPane.showMessageDialog((Component)BGClient.getFrame(), new JScrollPane((Component)txt), "\u041f\u0440\u0438\u0432\u0430\u0442\u043d\u044b\u0439 \u043a\u043b\u044e\u0447", 1);
            });
            JButton signatureData = new JButton("\u041f\u043e\u0434\u043f\u0438\u0441\u044c");
            signatureData.addActionListener(e -> {
                String HEX = "0123456789ABCDEF";
                byte[] sign = ((X509Certificate)this.certificate).getSignature();
                BGTextArea txt = new BGTextArea(25, 60);
                txt.setEditable(false);
                txt.setFont(new Font("Monospaced", 0, 12));
                StringBuffer buf = new StringBuffer(((X509Certificate)this.certificate).getSigAlgName() + "\n\n0000: ");
                int len = sign.length;
                int c = 0;
                int h = 0;
                for (int i = 0; i < len; ++i) {
                    if (c == 16) {
                        c = 0;
                        buf.append("\n").append(String.format("%04x", h += 16).toUpperCase()).append(": ");
                    } else if (c == 8) {
                        buf.append("  ");
                    } else if (c != 0) {
                        buf.append(" ");
                    }
                    buf.append(HEX.charAt(sign[i] & 0xF)).append(HEX.charAt(sign[i] & 0xF));
                    ++c;
                }
                txt.setText(buf.toString());
                JOptionPane.showMessageDialog((Component)BGClient.getFrame(), new JScrollPane((Component)txt), "\u041f\u043e\u0434\u043f\u0438\u0441\u044c", 1);
            });
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)certTextButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)publicKeyData, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 0, 0), 0, 0));
            panel.add((Component)this.privateKeyData, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 0, 0), 0, 0));
            panel.add((Component)signatureData, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
            return panel;
        }

        private void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
            this.privateKeyData.setVisible(privateKey != null);
        }

        private void setCertificate(Certificate certificate) {
            this.certificate = certificate;
            if ("X.509".equals(certificate.getType())) {
                ArrayList<KeyValue> generalData = new ArrayList<KeyValue>();
                ArrayList<KeyValue> subjectData = new ArrayList<KeyValue>();
                ArrayList<KeyValue> issuerData = new ArrayList<KeyValue>();
                X509Certificate x509Certificate = (X509Certificate)certificate;
                X500Principal issuerX500Principal = x509Certificate.getIssuerX500Principal();
                X500Principal subjectX500Principal = x509Certificate.getSubjectX500Principal();
                generalData.add(new KeyValue("\u0412\u0435\u0440\u0441\u0438\u044f:", String.valueOf(x509Certificate.getVersion())));
                generalData.add(new KeyValue("\u041d\u0435\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u0435\u043d \u0434\u043e:", x509Certificate.getNotBefore().toString()));
                generalData.add(new KeyValue("\u041d\u0435\u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u0435\u043d \u043f\u043e\u0441\u043b\u0435:", x509Certificate.getNotAfter().toString()));
                generalData.add(new KeyValue("SigAlgName:", x509Certificate.getSigAlgName()));
                generalData.add(new KeyValue("SigAlgOID:", x509Certificate.getSigAlgOID()));
                generalData.add(new KeyValue("SerialNumber:", x509Certificate.getSerialNumber().toString()));
                subjectData.addAll(this.parsePrincipal(subjectX500Principal.getEncoded()));
                issuerData.addAll(this.parsePrincipal(issuerX500Principal.getEncoded()));
                this.tryCall(() -> {
                    ArrayList<ExtensionBlock> extensionBlocks = new ArrayList<ExtensionBlock>();
                    Set<String> oids = x509Certificate.getCriticalExtensionOIDs();
                    if (oids != null) {
                        for (String oid : oids) {
                            extensionBlocks.add(new ExtensionBlock(CertificateManagerPanel.this, oid, true, ByteBuffer.wrap(x509Certificate.getExtensionValue(oid))));
                        }
                    }
                    if ((oids = x509Certificate.getNonCriticalExtensionOIDs()) != null) {
                        for (String oid : oids) {
                            extensionBlocks.add(new ExtensionBlock(CertificateManagerPanel.this, oid, false, ByteBuffer.wrap(x509Certificate.getExtensionValue(oid))));
                        }
                    }
                    this.extensionList.setData(extensionBlocks);
                });
                this.certText = certificate.toString();
                this.generalTableModel.setData(generalData);
                this.subjectTableModel.setData(subjectData);
                this.issuerTableModel.setData(issuerData);
            }
        }

        private List<KeyValue> parsePrincipal(byte[] principalBytes) {
            ArrayList<KeyValue> values = new ArrayList<KeyValue>();
            Ans1Block root = new Ans1Block(ByteBuffer.wrap(principalBytes));
            if (root.getBlockTagId() == 16 && !root.isBlockSingle()) {
                for (Ans1Block set : this.ans1BloclList(ByteBuffer.wrap(root.getBlockBytes()))) {
                    for (Ans1Block sequence : this.ans1BloclList(ByteBuffer.wrap(set.getBlockBytes()))) {
                        ByteBuffer sequenceByteBuffer = ByteBuffer.wrap(sequence.getBlockBytes());
                        Ans1Block obj = new Ans1Block(sequenceByteBuffer);
                        Ans1Block val = new Ans1Block(sequenceByteBuffer);
                        values.add(new KeyValue(obj.toString(), val.toString()));
                    }
                }
            }
            return values;
        }

        public List<Ans1Block> ans1BloclList(ByteBuffer byteBuffer) {
            ArrayList<Ans1Block> list = new ArrayList<Ans1Block>();
            while (byteBuffer.hasRemaining()) {
                list.add(new Ans1Block(byteBuffer));
            }
            return list;
        }
    }

    class AliasTableModel
    extends BGTableModel<AliasEntry> {
        public AliasTableModel() {
            super(AliasTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u0410\u043b\u0438\u0430\u0441", 100, 150, -1, "alias", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0422\u0438\u043f", 150, 150, 150, "entryType", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0432", 150, 150, 150, "chainSize", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }
    }

    class CertificateSetDialog
    extends BGEditorDialog<String> {
        private BGTextField alias;
        private BGTextArea cerText;
        private BGTextArea keyText;
        private BGSelectFilePanel fileChooser;

        public CertificateSetDialog(String title, String data) {
            super(title, (Object)data);
            this.alias = new BGTextField(40);
            this.cerText = new BGTextArea(20, 50);
            this.keyText = new BGTextArea(20, 50);
            this.fileChooser = new BGSelectFilePanel();
        }

        public void doDialogPanel() {
            this.alias.setHorizontalAlignment(0);
            this.panel.add((Component)this.getAliasFilePanel(), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0421\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442 (\u0446\u0435\u043f\u043e\u0447\u043a\u0430) \u0432 PEM \u0444\u043e\u0440\u043c\u0430\u0442\u0435:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
            this.panel.add((Component)new JScrollPane((Component)this.cerText), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 10), 0, 0));
            this.panel.add((Component)new JLabel("\u041f\u0440\u0438\u0432\u0430\u0442\u043d\u044b\u0439 \u043a\u043b\u044e\u0447 \u0432 PEM \u0444\u043e\u0440\u043c\u0430\u0442\u0435:"), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 0, 0), 0, 0));
            this.panel.add((Component)new JScrollPane((Component)this.keyText), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 10, 0, 0), 0, 0));
        }

        private JPanel getAliasFilePanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0410\u043b\u0438\u0430\u0441:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)this.alias, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b \u0438\u043b\u0438 \u0441\u043a\u043e\u043f\u0438\u0440\u0443\u0439\u0442\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u0432 \u043f\u043e\u043b\u044f \u043d\u0438\u0436\u0435:"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 0, 0), 0, 0));
            panel.add((Component)this.fileChooser, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 20, 0, 0), 0, 0));
            return panel;
        }

        public boolean doApply() throws Exception {
            if (this.fileChooser.getSelectedFile() != null) {
                Path path = this.fileChooser.getSelectedFile().toPath();
                byte[] bytes = Files.readAllBytes(path);
                if (path.getFileName().toString().endsWith(".p12")) {
                    String pswd = JOptionPane.showInputDialog("\u041f\u0430\u0440\u043e\u043b\u044c");
                    ((CertificateService)((ClientContext)CertificateManagerPanel.this.getContext()).getWebService(CertificateService.class, 0)).certificateSetP12(Base64.getEncoder().encodeToString(bytes), pswd);
                    CertificateManagerPanel.this.performAction("refresh");
                    return true;
                }
            }
            if (Utils.isBlankString((String)this.alias.getText())) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0430\u043b\u0438\u0430\u0441");
                return false;
            }
            if (Utils.isBlankString((String)this.cerText.getText())) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442 (\u0446\u0435\u043f\u043e\u0447\u043a\u0443)");
                return false;
            }
            ((CertificateService)((ClientContext)CertificateManagerPanel.this.getContext()).getWebService(CertificateService.class, 0)).certificateSet(this.alias.getText(), "X.509", this.keyText.getText(), this.cerText.getText());
            CertificateManagerPanel.this.performAction("refresh");
            return true;
        }
    }

    public class ExtensionBlock
    extends Ans1Block
    implements GuiTitlable {
        private String oid = "";
        private boolean critical = false;

        public ExtensionBlock(CertificateManagerPanel this$0, String oid, boolean critical, ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.oid = oid;
            this.critical = critical;
        }

        public String getGuiTitle() {
            return this.oid + " [critical=" + this.critical + "]";
        }

        @Override
        public String toString() {
            return OidMap.oidMap.getOrDefault(this.oid, "unknown") + " [OID=" + this.oid + "; Criticality=" + this.critical + "]";
        }
    }

    class KeyValueModel
    extends BGTableModel<KeyValue> {
        public KeyValueModel(String name, int paramColumn) {
            super(name);
            this.addColumn("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", paramColumn, paramColumn, paramColumn, "key", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 150, 150, -1, "value", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        protected void initColumns() {
        }
    }
}

