/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.action;

import bitel.billing.server.ActionBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlan;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlanSearchParameters;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffPlanDao;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class ActionListTariffPlans
extends ActionBase {
    @Override
    public void doAction() throws Exception {
        int showActual = this.getIntParameter("showUsed", 2);
        List moduleIds = Utils.toIntegerList((String)this.getParameter("moduleId"));
        List labelIds = Utils.toIntegerList((String)this.getParameter("labelIds"));
        boolean contractCount = this.getBooleanParameter("contractCount", false);
        Page page = this.getPage();
        page.setPageSize(this.getIntParameter("pageSize", -1));
        Map<Integer, TariffPlanDao.TariffPlanCounts> countMap = null;
        SearchResult searchResult = new SearchResult(page);
        try (TariffPlanDao tariffPlanManager = new TariffPlanDao(this.con);){
            TariffPlanSearchParameters tariffPlanSearchParameters = new TariffPlanSearchParameters().setLabelIds(labelIds).setModuleIds(moduleIds).setShowActual(showActual).setTitleMask(this.getParameter("titleMask"));
            tariffPlanManager.searchTariffPlans((SearchResult<TariffPlan>)searchResult, tariffPlanSearchParameters);
            if (contractCount) {
                ArrayList<Integer> tariffIds = new ArrayList<Integer>();
                for (TariffPlan tariff : searchResult.getList()) {
                    tariffIds.add(tariff.getId());
                }
                countMap = tariffPlanManager.getTariffContractCount(tariffIds);
            }
        }
        Element tariffPalnList = this.createElement(this.rootNode, "tariffPlans");
        for (TariffPlan tariff : searchResult.getList()) {
            TariffPlanDao.TariffPlanCounts counts;
            Element item = this.createElement(tariffPalnList, "item");
            item.setAttribute("id", String.valueOf(tariff.getId()));
            item.setAttribute("title", tariff.getTitle());
            if (contractCount && (counts = countMap.get(tariff.getId())) != null) {
                item.setAttribute("countChild", counts.countChild.toString());
                item.setAttribute("countActive", counts.countActive.toString());
                item.setAttribute("countAll", counts.countAll.toString());
            }
            item.setAttribute("comment", tariff.getComment());
        }
        this.setPageAttribute(tariffPalnList, page);
    }
}

