/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.bean.protocol;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.modules.mps.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mps.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.mps.server.bean.Conf;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSException;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSRequest;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSResponse;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.MPSTransactionManager;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class ComepayTransactionManager
extends MPSTransactionManager {
    protected static final String TIMEPATTERN = "yyyyMMddHHmmss";
    private static final String PARAMETR_OPERATION = "operation";
    private static final String PARAMETR_ACCOUNT = "account";
    private static final String PARAMETR_SUMM = "summ";
    protected static final Pattern TRANSACTION_PATTERN = Pattern.compile("^(\\d+)\\t([\\d+\\.:\\t]+)\\t(.+)\\t(\\d+\\.*\\d*)$", 8);

    @Override
    protected MPSRequest parseRequest(Connection con, int moduleId, String mpsId, Conf.MPSSystem system, HttpServletRequest request) throws MPSException {
        char type;
        MPSRequest req = new MPSRequest(con, moduleId, mpsId, request, system);
        String actionString = request.getParameter(PARAMETR_OPERATION);
        req.parameters.put(PARAMETR_OPERATION, actionString);
        if ("check".equals(actionString)) {
            req.setAction(1);
        } else if ("payment".equals(actionString)) {
            req.setAction(2);
        }
        req.setRawNumber(request.getParameter(PARAMETR_ACCOUNT));
        req.parameters.put(PARAMETR_ACCOUNT, req.getRawNumber());
        if (system.osmpPrefix && req.getRawNumber() != null && req.getRawNumber().length() > 1 && req.getRawNumber().charAt(1) == '_' && Character.isDigit((int)(type = req.getRawNumber().charAt(0)))) {
            req.setType(Character.getNumericValue((int)type));
            req.setNumber(req.getRawNumber().substring(2));
        } else {
            req.setNumber(req.getRawNumber());
            req.setType(0);
        }
        req.setSum(Utils.parseBigDecimal((String)request.getParameter("sum"), (BigDecimal)BigDecimal.ZERO));
        req.parameters.put(PARAMETR_SUMM, request.getParameter("sum"));
        req.setTransId(request.getParameter("id_payment"));
        req.setTime(TimeUtils.parseDate((String)request.getParameter("date"), (String)TIMEPATTERN));
        return req;
    }

    @Override
    protected void checkValid(Conf.MPSSystem system, MPSRequest req, Connection con) throws MPSException {
        switch (req.getAction()) {
            case 1: {
                if (req.getNumber() == null || req.getNumber().length() <= 0) {
                    throw new MPSException(2);
                }
                if (system.numberPattern != null && !system.numberPattern.matcher(req.getNumber()).matches()) {
                    throw new MPSException(13);
                }
                if (system.extDontCheckSum || req.getSum().compareTo(BigDecimal.ZERO) >= 0) break;
                throw new MPSException(8);
            }
            case 2: {
                if (req.getNumber() == null || req.getNumber().length() <= 0 || req.getSum() == null || req.getTransId() == null || this.parseBigInteger(req.getTransId()).compareTo(BigInteger.ZERO) <= 0 || req.getTime() == null) {
                    throw new MPSException(2);
                }
                if (!system.extDontCheckSum && req.getSum().compareTo(BigDecimal.ZERO) <= 0) {
                    throw new MPSException(8);
                }
                if (system.numberPattern == null || system.numberPattern.matcher(req.getNumber()).matches()) break;
                throw new MPSException(13);
            }
        }
        super.checkValid(system, req, con);
    }

    @Override
    protected byte[] processRequest(Connection con, int moduleId, String mpsId, Conf conf, Conf.MPSSystem system, HttpServletRequest httpRequest, HttpServletResponse response) {
        MPSResponse mpsResponse = new MPSResponse(moduleId, mpsId, response);
        mpsResponse.setResult(0);
        try {
            if (system == null || !system.mode) {
                throw new MPSException(9, "\u0421\u0435\u0440\u0432\u0438\u0441 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u043d\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442");
            }
            MPSRequest request = this.parseRequest(con, moduleId, mpsId, system, httpRequest);
            mpsResponse.setAction(request.getAction());
            mpsResponse.setTransId(request.getTransId());
            mpsResponse.setTime(request.getTime());
            mpsResponse.setNumber(request.getNumber());
            mpsResponse.getParameters().clear();
            mpsResponse.getParameters().putAll(request.parameters);
            mpsResponse.setSum(request.getSum());
            this.checkValid(system, request, con);
            switch (request.getAction()) {
                case 1: {
                    if (request.getSum().compareTo(system.minSumm) >= 0 && request.getSum().compareTo(system.maxSumm) <= 0) {
                        mpsResponse.setSum(request.getSum());
                        Contract contract = this.actionCheck(request);
                        mpsResponse.setMessage(this.getComment(system, conf, con, contract));
                        break;
                    }
                    throw new MPSException(8, "\u0412\u0432\u0435\u0434\u0435\u043d\u0430 \u043d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430. \u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0435\u0436 \u0441\u043e\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442 " + String.valueOf(system.minSumm) + " " + Setup.getSetup().get("client.gui.currency.title.medium", "\u0440\u0443\u0431.;") + " \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 - " + String.valueOf(system.maxSumm) + " " + Setup.getSetup().get("client.gui.currency.title.medium", "\u0440\u0443\u0431."));
                }
                case 2: {
                    Transaction transaction = this.getTransactionByTransId(con, moduleId, mpsId, request.getTransId(), request.getTime());
                    if (transaction != null && !transaction.getStatus().equals(TransactionStatus.PAYMENT_PAYED.getCode())) {
                        mpsResponse.setResult(599);
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u0435\u0441\u0442\u044c \u0432 \u0431\u0430\u0437\u0435, \u043d\u043e \u0431\u044b\u043b \u043e\u0442\u043c\u0435\u043d\u0435\u043d");
                        break;
                    }
                    if (transaction == null) {
                        Contract contract = this.actionCheck(request);
                        this.checkTime(request);
                        transaction = this.addTransaction(con, moduleId, mpsId, system, contract.getId(), request.getTime(), request.getSum(), request.getTransId(), request.getRawNumber(), request.getType(), system.title);
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u043f\u0440\u0438\u043d\u044f\u0442 \u043d\u0430: " + this.getComment(system, conf, con, contract));
                    } else {
                        mpsResponse.setResult(516);
                        mpsResponse.setTime(transaction.getTime());
                        Contract contract = this.getContractById(con, transaction.getContractId());
                        if (contract != null) {
                            mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u043f\u0440\u0438\u043d\u044f\u0442 \u043d\u0430: " + this.getComment(system, conf, con, contract));
                        }
                    }
                    mpsResponse.setId(transaction.getId());
                    mpsResponse.setSum(transaction.getSum());
                    mpsResponse.setLocalTime(transaction.getLocalTime());
                }
            }
        }
        catch (MPSException ex) {
            this.processError(ex, mpsResponse);
        }
        catch (Exception e) {
            this.processError(new MPSException(-1), mpsResponse);
            e.printStackTrace();
        }
        return this.getResponse(con, system, mpsResponse);
    }

    @Override
    protected void processError(MPSException ex, MPSResponse response) {
        switch (ex.error) {
            case 2: {
                response.setResult(508);
                response.setMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
                break;
            }
            case 3: {
                response.setResult(504);
                response.setMessage(ex.message);
                break;
            }
            case 6: {
                response.setResult(506);
                response.setMessage(ex.message);
                break;
            }
            case 8: {
                response.setResult(501);
                response.setMessage("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430");
                break;
            }
            case -1: {
                response.setResult(599);
                response.setMessage("\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430");
                break;
            }
            case 9: {
                response.setResult(503);
                response.setMessage(ex.message);
                break;
            }
            case 4: {
                response.setResult(516);
                response.setMessage(ex.message);
                break;
            }
            case 13: {
                response.setResult(500);
                response.setMessage(ex.message);
            }
        }
    }

    @Override
    protected byte[] getResponse(Connection con, Conf.MPSSystem system, MPSResponse response) {
        Document doc = this.documentBuilder.newDocument();
        Element rootNode = doc.createElement("response");
        doc.appendChild(rootNode);
        Element el = XMLUtils.createElement((Element)rootNode, (String)PARAMETR_OPERATION);
        Object parameterOperation = response.getParameters().get(PARAMETR_OPERATION);
        if (parameterOperation != null) {
            el.setTextContent(parameterOperation.toString());
        }
        if (response.getAction() == 1) {
            el.setTextContent("check");
        } else if (response.getAction() == 2) {
            el.setTextContent("payment");
        }
        if (response.getAction() == 2) {
            if (response.getTransId() != null) {
                XMLUtils.createElement((Element)rootNode, (String)"id_payment").setTextContent(response.getTransId());
            }
            if (response.getId() != 0L) {
                XMLUtils.createElement((Element)rootNode, (String)"ext-id_payment").setTextContent(String.valueOf(response.getId()));
            }
            if (response.getTime() != null) {
                XMLUtils.createElement((Element)rootNode, (String)"date").setTextContent(TimeUtils.format((Date)response.getTime(), (String)TIMEPATTERN));
            }
        }
        el = XMLUtils.createElement((Element)rootNode, (String)"sum");
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        DecimalFormat df = new DecimalFormat("########0.0000", dfs);
        if (response.getSum() != null || response.getSum().compareTo(BigDecimal.ZERO) == 0) {
            el.setTextContent(df.format(response.getSum()));
        } else {
            Object summ = response.getParameters().get(PARAMETR_SUMM);
            el.setTextContent(summ != null ? summ.toString() : "null");
        }
        el = XMLUtils.createElement((Element)rootNode, (String)"result");
        if (response.getResult() != 0) {
            el.setAttribute("fatal", "true");
            el.setTextContent(String.valueOf(response.getResult()));
        } else {
            el.setTextContent(String.valueOf(response.getResult()));
        }
        if (response.getMessage() != null) {
            el = XMLUtils.createElement((Element)rootNode, (String)"ext-description");
            el.setTextContent(response.getMessage());
        }
        el = XMLUtils.createElement((Element)rootNode, (String)PARAMETR_ACCOUNT);
        Object account = response.getParameters().get(PARAMETR_ACCOUNT);
        el.setTextContent(account != null ? account.toString() : "null");
        for (Map.Entry<String, String> e : this.getResponseAttributes(con, system, response).entrySet()) {
            el = XMLUtils.createElement((Element)rootNode, (String)e.getKey());
            el.setTextContent(e.getValue());
        }
        return this.xmlSerialize(doc);
    }

    @Override
    protected List<Transaction> getTransactionListFromFile(Conf.MPSSystem system, String file) {
        ArrayList<Transaction> result = new ArrayList<Transaction>();
        Matcher match = TRANSACTION_PATTERN.matcher(file);
        while (match.find()) {
            char type;
            String number = match.group(3);
            Transaction transaction = new Transaction().setTransId(Utils.parseLong((String)match.group(1), (long)0L)).setTime(TimeUtils.parseDate((String)match.group(2), (String)"dd.MM.yyyy\tHH:mm:ss")).setRawNumber(number).setSum(Utils.parseBigDecimal((String)match.group(4), (BigDecimal)BigDecimal.ZERO)).setStatus(TransactionStatus.PAYMENT_PAYED.getCode());
            if (system.osmpPrefix && number != null && number.length() > 1 && number.charAt(1) == '_' && Character.isDigit((int)(type = number.charAt(0)))) {
                transaction.setType(Character.getNumericValue((int)type));
                transaction.setNumber(number.substring(2));
            } else {
                transaction.setNumber(number);
            }
            result.add(transaction);
        }
        return result;
    }

    private static class ErrorCode {
        protected static final int ANSWER_SUCCESS = 0;
        protected static final int ANSWER_ERR_CONTRACT_ID = 500;
        protected static final int ANSWER_ERR_REQUEST_PARAM = 501;
        protected static final int ANSWER_ERR_PAYMENT_REJECTED = 502;
        protected static final int ANSWER_ERR_OFF = 503;
        protected static final int ANSWER_ERR_CONTRACT_NOT_FOUND = 504;
        protected static final int ANSWER_ERR_DATE = 506;
        protected static final int ANSWER_ERR_REQUEST = 508;
        protected static final int ANSWER_ERR_TIMEDOUT = 509;
        protected static final int ANSWER_ERR_PAYSYS_BALANCE = 511;
        protected static final int ANSWER_ERR_TEST_CONTRACT_ID = 513;
        protected static final int ANSWER_ERR_OVERLAP_PAYMENT = 516;
        protected static final int ANSWER_ERR_HOMEOP = 517;
        protected static final int ANSWER_ERR_CONTRACT_ACCOUNT = 518;
        protected static final int ANSWER_ERR_CONTRACT_ACCOUNT_BLOCKED = 534;
        protected static final int ANSWER_ERR_CONTRACT_ACCOUNT_BLOCKED_GO = 535;
        protected static final int ANSWER_ERR_UNKNOWN = 599;

        private ErrorCode() {
        }
    }
}

