/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.service;

import jakarta.jws.WebService;
import java.util.HashMap;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostGroup;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.forpost.ForpostTMCAO;
import ru.bitel.bgbilling.modules.smarthouse.common.service.ForpostGroupService;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ForpostManager;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ResponseId;
import ru.bitel.bgbilling.modules.smarthouse.server.api.forpost.ResponseStatus;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.forpost.ForpostAccountDao;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.forpost.ForpostGroupDao;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.smarthouse.common.service.ForpostGroupService")
public class ForpostGroupServiceImpl
extends AbstractService
implements ForpostGroupService {
    public SearchResult<ForpostTMCAO<ForpostGroup>> searchForpostGroups(String[] sort, Page page) throws BGException {
        SearchResult searchResult = new SearchResult(page);
        searchResult.setSort(sort);
        try (ForpostGroupDao forpostGroupDao = new ForpostGroupDao(this.getConnection(), this.moduleId);){
            forpostGroupDao.searchForpostGroups((SearchResult<ForpostTMCAO<ForpostGroup>>)searchResult);
        }
        return searchResult;
    }

    public SearchResult<ForpostGroup> searchForpostAccountGroups(int accountId) throws BGException {
        SearchResult searchResult = new SearchResult();
        try (ForpostGroupDao forpostGroupDao = new ForpostGroupDao(this.getConnection(), this.moduleId);){
            forpostGroupDao.searchForpostAccountGroups((SearchResult<ForpostGroup>)searchResult, accountId);
        }
        return searchResult;
    }

    public void doSync() throws BGException {
        this.tryCall(() -> {
            if ("test".equals(this.getModuleSetup().get("forpost.mode", ""))) {
                throw new BGMessageException("\u0412\u043a\u043b\u044e\u0447\u0435\u043d \u0442\u0435\u0441\u0442\u043e\u0432\u044b\u0439 \u0440\u0435\u0436\u0438\u043c, \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u043d\u0435 \u043f\u0440\u043e\u0432\u043e\u0434\u0438\u0442\u0441\u044f");
            }
            try (ForpostAccountDao forpostAccountDao = new ForpostAccountDao(this.getConnection(), this.moduleId);
                 ForpostGroupDao forpostGroupDao = new ForpostGroupDao(this.getConnection(), this.moduleId);){
                ForpostManager forpostManager = new ForpostManager(this.moduleId);
                for (int accountId : forpostAccountDao.getIds()) {
                    forpostGroupDao.doSync(accountId, forpostManager.getAccountGroups(null, null, accountId, null, null, null));
                }
            }
        });
    }

    public void doSyncForpostGroups(int accountId) throws BGException {
    }

    public ForpostGroup getDefaultForpostGroup() throws BGException {
        return new ForpostGroup();
    }

    public int addForpostGroup(ForpostGroup forpostGroup) throws BGException {
        return (Integer)this.tryReturn(() -> {
            ForpostGroup localForpostGroup = forpostGroup;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("Name", localForpostGroup.getName());
            params.put("AccountID", String.valueOf(localForpostGroup.getAccountId()));
            if (localForpostGroup.getParentId() > 0) {
                params.put("ParentID", String.valueOf(localForpostGroup.getParentId()));
            }
            try (ForpostGroupDao forpostGroupDao = new ForpostGroupDao(this.getConnection(), this.moduleId);){
                ForpostManager forpostManager = new ForpostManager(this.moduleId);
                ResponseId responseId = forpostManager.addAccountGroup(params);
                if (responseId.getErrorCode() > 0) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseId.getErrorCode() + " - " + responseId.getError());
                }
                int groupId = responseId.getId();
                for (ForpostGroup remoteForpostGroup : new ForpostManager(this.moduleId).getAccountGroups(groupId, null, null, null, null, null)) {
                    if (groupId != remoteForpostGroup.getId()) continue;
                    remoteForpostGroup.setId(groupId);
                    remoteForpostGroup.setParentId(localForpostGroup.getParentId());
                    remoteForpostGroup.setName(localForpostGroup.getName());
                    localForpostGroup = remoteForpostGroup;
                }
                forpostGroupDao.update(localForpostGroup);
                Integer n = groupId;
                return n;
            }
        });
    }

    public void updateForpostGroup(ForpostGroup forpostGroup) throws BGException {
    }

    public void updateForpostGroupParam(int forpostGroupId, String name, String value) throws BGException {
        this.tryCall(() -> {
            try (ForpostGroupDao forpostGroupDao = new ForpostGroupDao(this.getConnection(), this.moduleId);){
                ForpostGroup forpostGroup = forpostGroupDao.getForpostGroup(forpostGroupId);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("ID", String.valueOf(forpostGroup.getId()));
                params.put(name, value);
                switch (name) {
                    case "Name": {
                        forpostGroup.setName(value);
                        break;
                    }
                    case "ParentID": {
                        forpostGroup.setParentId(Utils.parseInt((String)value));
                        break;
                    }
                    default: {
                        forpostGroup.put(name, (Object)value);
                    }
                }
                ForpostManager forpostManager = new ForpostManager(this.moduleId);
                ResponseId responseId = forpostManager.editAccountGroup(forpostGroup.getId(), forpostGroup.getName(), forpostGroup.getParentId());
                if (responseId.getErrorCode() > 0) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseId.getErrorCode() + " - " + responseId.getError());
                }
                forpostGroupDao.update(forpostGroup);
            }
        });
    }

    public void deleteForpostGroup(int id) throws BGException {
        this.tryCall(() -> {
            try (ForpostGroupDao forpostGroupDao = new ForpostGroupDao(this.getConnection(), this.moduleId);){
                ForpostManager forpostManager = new ForpostManager(this.moduleId);
                ResponseStatus responseStatus = forpostManager.deleteAccountGroup(id);
                if (responseStatus.getErrorCode() > 0) {
                    if (responseStatus.getErrorCode() == 1) {
                        // empty if block
                    }
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 #" + responseStatus.getErrorCode() + " - " + responseStatus.getError());
                }
                forpostGroupDao.deleteForpostGroup(id);
            }
        });
    }

    public void deleteForpostAccountGroups(int accountId) throws BGException {
    }
}

