/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean.range;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceCostMapRange;
import ru.bitel.bgbilling.modules.voice.common.dto.VoiceCostMapRangeItem;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;

public class VoiceCostMapRangeDao
extends AbstractIdDao<VoiceCostMapRange> {
    public VoiceCostMapRangeDao(Connection con, int moduleId) {
        super(con, "voice_cost_map_range", moduleId);
    }

    public List<VoiceCostMapRange> list(int costMapId, Date onDate) throws SQLException {
        return this.list("cost_map_id=? AND (date_from IS NULL OR date_from <= ?) AND (date_to IS NULL OR date_to >= ?)", null, new Object[]{costMapId, onDate, onDate});
    }

    public List<VoiceCostMapRangeItem> items(int costMapId, Date onDate) throws SQLException {
        ArrayList<VoiceCostMapRangeItem> items = new ArrayList<VoiceCostMapRangeItem>();
        String query = "SELECT * FROM " + this.tableName + " AS cm LEFT JOIN voice_geographic_range_" + this.moduleId + " AS r ON r.id=cm.range_id WHERE cost_map_id=? AND (date_from IS NULL OR date_from <= ?) AND ( date_to IS NULL OR date_to >= ? )";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, costMapId);
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)onDate));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)onDate));
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    items.add(new VoiceCostMapRangeItem().setId(rs.getInt("cm.id")).setRangeId(rs.getInt("cm.range_id")).setRangeFrom(rs.getLong("r.codeFrom")).setRangeTo(rs.getLong("r.codeTo")).setDestinationId(rs.getInt("r.destinationId")).setMobileId(rs.getString("r.mobileId")).setDateFrom((Date)rs.getDate("cm.date_from")).setCost(rs.getBigDecimal("cm.cost")).setDateTo((Date)rs.getDate("cm.date_to")).setComment(rs.getString("cm.comment")));
                }
            }
        }
        return items;
    }

    protected VoiceCostMapRange getFromRS(ResultSet rs) throws SQLException {
        return new VoiceCostMapRange().setId(rs.getInt("id")).setCostMapId(rs.getInt("cost_map_id")).setRangeId(rs.getInt("range_id")).setDateFrom(TimeUtils.convertDateToLocalDate((Date)rs.getDate("date_from"))).setDateTo(TimeUtils.convertDateToLocalDate((Date)rs.getDate("date_to"))).setRangeCost(rs.getBigDecimal("cost")).setComment(rs.getString("comment"));
    }

    protected void updateImpl(VoiceCostMapRange voiceCostMapRange) throws SQLException {
        String querySet = "cost_map_id=?, range_id=?, date_from=?, date_to=?, cost=?, comment=?";
        try (PreparedStatement ps = this.prepareStatement((Idable)voiceCostMapRange, querySet);){
            int index = 1;
            ps.setInt(index++, voiceCostMapRange.getCostMapId());
            ps.setInt(index++, voiceCostMapRange.getRangeId());
            ps.setDate(index++, TimeUtils.convertLocalDateToSqlDate((LocalDate)voiceCostMapRange.getDateFrom()));
            ps.setDate(index++, TimeUtils.convertLocalDateToSqlDate((LocalDate)voiceCostMapRange.getDateTo()));
            ps.setBigDecimal(index++, voiceCostMapRange.getRangeCost());
            ps.setString(index++, voiceCostMapRange.getComment());
            this.executeUpdate((Id)voiceCostMapRange, index, ps);
        }
    }
}

