/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client.admin;

import bitel.billing.module.common.BGBorderFactory;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.bill.client.directory.AttributePanel;
import ru.bitel.bgbilling.modules.bill.client.directory.BillLinkPanel;
import ru.bitel.bgbilling.modules.bill.client.directory.BillPositionPanel;
import ru.bitel.bgbilling.modules.bill.client.directory.DocTypePanel;
import ru.bitel.bgbilling.modules.bill.client.directory.InvoicePositionPanel;
import ru.bitel.bgbilling.modules.bill.client.directory.NumerationPoolPanel;
import ru.bitel.bgbilling.modules.bill.client.directory.organization.OrganizationAccountManagerPanel;

public class ServiceConfigDirectoryPanel
extends ServiceConfigTabbedPanel {
    private DefaultListModel<DirectoryListItem> listModel = new DefaultListModel();
    private JList<DirectoryListItem> directoryList = new JList<DirectoryListItem>(this.listModel);
    private JPanel editorContainer = new JPanel(new GridBagLayout());
    private BGSplitPaneNoBorder splitPanel = new BGSplitPaneNoBorder(1, (Component)new JScrollPane(this.directoryList), (Component)this.editorContainer, 300L);

    public ServiceConfigDirectoryPanel() {
        this.jbInit();
    }

    private void jbInit() {
        this.directoryList.setBorder(BGBorderFactory.createEmptyBorder());
        this.directoryList.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                this.showDir();
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)this.splitPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void initDirectories() {
        if (this.listModel.size() == 0) {
            this.listModel.addElement(new DirectoryListItem(OrganizationAccountManagerPanel.class, "\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u0438 \u0431\u0430\u043d\u043a\u043e\u0432\u0441\u043a\u0438\u0435 \u0441\u0447\u0435\u0442\u0430"));
            this.listModel.addElement(new DirectoryListItem(DocTypePanel.class, "\u0422\u0438\u043f\u044b \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432"));
            this.listModel.addElement(new DirectoryListItem(AttributePanel.class, "\u0422\u0438\u043f\u044b \u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u043e\u0432"));
            this.listModel.addElement(new DirectoryListItem(InvoicePositionPanel.class, "\u041f\u043e\u0437\u0438\u0446\u0438\u0438 \u0423\u041f\u0414, \u0421\u0447\u0435\u0442-\u0444\u0430\u043a\u0442\u0443\u0440, \u0410\u043a\u0442\u043e\u0432"));
            this.listModel.addElement(new DirectoryListItem(BillPositionPanel.class, "\u041f\u043e\u0437\u0438\u0446\u0438\u0438 \u0421\u0447\u0435\u0442\u043e\u0432"));
            this.listModel.addElement(new DirectoryListItem(NumerationPoolPanel.class, "\u041d\u043e\u043c\u0435\u0440\u043d\u044b\u0435 \u043f\u0443\u043b\u044b"));
            this.listModel.addElement(new DirectoryListItem(BillLinkPanel.class, "\u0421\u0441\u044b\u043b\u043a\u0438"));
            this.directoryList.setSelectedValue(this.listModel.get(0), true);
            this.showDir();
        }
    }

    private void showDir() {
        DirectoryListItem listItem = this.directoryList.getSelectedValue();
        if (listItem != null) {
            this.tryCall(() -> {
                JPanel panel = listItem.getPanel();
                if (panel != null) {
                    if (panel instanceof BGPanel) {
                        ((BGPanel)panel).init(this.module, this.getModuleId());
                    }
                    int divide = this.splitPanel.getDividerLocation();
                    this.editorContainer.setVisible(false);
                    this.editorContainer.removeAll();
                    this.editorContainer.add((Component)panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                    this.editorContainer.updateUI();
                    this.editorContainer.setVisible(true);
                    this.splitPanel.setDividerLocation(divide);
                    if (panel instanceof BGPanel) {
                        ((BGPanel)panel).trySetData();
                    } else if (panel instanceof BGUPanel) {
                        ((BGUPanel)panel).performAction("refresh");
                    }
                }
            });
        }
    }

    public void setData() {
        this.initDirectories();
        this.performActionToSelectPanel("refresh");
    }

    public void deleteItem() {
        this.performActionToSelectPanel("delete");
    }

    public void editItem() {
        this.performActionToSelectPanel("edit");
    }

    public void newItem() {
        this.performActionToSelectPanel("new");
    }

    private void performActionToSelectPanel(String act) {
        DirectoryListItem item = this.directoryList.getSelectedValue();
        if (item != null && item.panel != null && item.panel.isVisible()) {
            if (item.panel instanceof BGPanel) {
                switch (act) {
                    case "delete": {
                        ((BGPanel)item.panel).deleteItem();
                        break;
                    }
                    case "new": {
                        ((BGPanel)item.panel).newItem();
                        break;
                    }
                    case "edit": {
                        ((BGPanel)item.panel).editItem();
                        break;
                    }
                    case "refresh": {
                        ((BGPanel)item.panel).trySetData();
                    }
                }
            } else {
                ((BGUPanel)item.panel).performAction(act);
            }
        }
    }

    private class DirectoryListItem {
        private String title;
        private JPanel panel;
        private Class<?> panelClass;

        public DirectoryListItem(Class<?> panelClass, String title) {
            this.panelClass = panelClass;
            this.title = title;
        }

        public JPanel getPanel() throws BGException {
            if (this.panel == null) {
                ServiceConfigDirectoryPanel.this.tryCall(() -> {
                    this.panel = this.panelClass.asSubclass(JPanel.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                });
            }
            return this.panel;
        }

        public String toString() {
            return this.title;
        }
    }
}

