/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cloudpayments.server.action.web;

import bitel.billing.server.ActionResultContentType;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Date;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractPaymentAction;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.cloudpayments.common.bean.Transaction;
import ru.bitel.bgbilling.modules.cloudpayments.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.cloudpayments.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.cloudpayments.server.bean.Constants;
import ru.bitel.bgbilling.modules.cloudpayments.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.cloudpayments.server.event.CloudPaymentsCheckEvent;
import ru.bitel.common.model.SearchResult;

@WebAction(title="CloudPaymets")
public class ActionDoTransaction
extends AbstractPaymentAction {
    public ActionDoTransaction() {
        super("cloudpayments");
    }

    @WebOperation(title="\u041e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430")
    public void execute() throws Exception {
        if (this.context.getRequest().getParameter("check") != null) {
            EventProcessor.getInstance().publish((Event)new CloudPaymentsCheckEvent(this.moduleId, this.contractId, false));
        }
        super.execute();
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws Exception {
        this.paymentForm(this.moduleName, Constants.class, AutopaymentManager.class);
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws Exception {
        SearchParam searchParam = new SearchParam().setContractId(this.contractId).setStatus(this.getStatus((AbstractTransactionStatus)TransactionStatus.ALL)).setSort(new String[]{"createDate:1", "transactionDate:1"}).setPage(this.getPage());
        SearchResult searchResult = new SearchResult(searchParam);
        new TransactionManager(this.con, this.moduleId).searchTransaction(searchResult, searchParam);
        this.setResultParam("transactions", searchResult.getList());
        this.requestDispatcher("include", "payment_transactions");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436")
    public void pay() throws Exception {
        super.pay();
        super.payCheckSum();
        Transaction transaction = new Transaction().setSum(this.sum).setContractId(this.contractId).setCreateDate(new Date()).setAutopayment(false);
        try (Connection con = this.setup.getDBConnection(true);){
            new TransactionManager(con, this.moduleId).update(transaction);
        }
        String contractTitle = this.getContractTitle();
        this.setResultParam("publicId", this.moduleSetup.get("cloudpayments.public.id", "test_api_00000000000000000000001"));
        this.setResultParam("description", this.moduleSetup.get("cloudpayments.description", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contractTitle));
        this.setResultParam("amount", this.sum);
        this.setResultParam("accountId", contractTitle);
        this.setResultParam("invoiceId", transaction.getId());
        this.setResultParam("contractId", this.contractId);
        this.setResultParam("email", this.customerAddress);
        this.setResultParam("contentType", ActionResultContentType.json);
    }

    public void autopayment() throws Exception {
        super.autopayment();
        this.autopaymentImpl("cloudpayments", new AutopaymentManager(this.con, this.moduleId), Constants.class);
    }

    protected void autopaymentRegisterOrder(BigDecimal sum, String customerAddress) throws Exception {
    }

    protected void autopaymentRedirect(boolean redirect) throws Exception {
        if (redirect) {
            this.setResultParam("publicId", this.moduleSetup.get("cloudpayments.public.id", "test_api_00000000000000000000001"));
            this.setResultParam("contentType", ActionResultContentType.json);
        } else {
            this.execute();
        }
    }
}

