/*
 * Decompiled with CFR 0.152.
 */
package ru.atol.drivers10.fptr;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Arrays;

class WindowsRegistry {
    WindowsRegistry() {
    }

    public static String readRegistry(String location, String key) {
        try {
            String jvmArch = System.getProperty("os.arch").equals("x86") ? "32" : "64";
            String archEnv = System.getenv("PROCESSOR_ARCHITECTURE");
            String wow64ArchEnv = System.getenv("PROCESSOR_ARCHITEW6432");
            String realArch = archEnv.endsWith("64") || wow64ArchEnv != null && wow64ArchEnv.endsWith("64") ? "64" : "32";
            String reg = "C:\\Windows\\System32\\reg.exe";
            if (jvmArch.equals("32") && realArch.equals("64")) {
                reg = "C:\\Windows\\SysWOW64\\reg.exe";
            }
            Process process = Runtime.getRuntime().exec(reg + " query " + '\"' + location + "\" /v " + key);
            StreamReader reader = new StreamReader(process.getInputStream());
            reader.start();
            process.waitFor();
            reader.join();
            String[] parsed = reader.getResult().split("\\s+");
            StringBuilder result = new StringBuilder();
            for (int i = Arrays.asList(parsed).indexOf(key) + 2; i < parsed.length; ++i) {
                result.append(parsed[i]).append(" ");
            }
            return result.toString().trim();
        }
        catch (Exception exception) {
            return "";
        }
    }

    static class StreamReader
    extends Thread {
        private InputStream is;
        private StringWriter sw = new StringWriter();

        StreamReader(InputStream is) {
            this.is = is;
        }

        @Override
        public void run() {
            try {
                int c;
                while ((c = this.is.read()) != -1) {
                    this.sw.write(c);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        String getResult() {
            return this.sw.toString();
        }
    }
}

