/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.common;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import ru.bitel.common.model.Period;

public class TimeUtils {
    public static final String[] monthNames = new String[]{"\u044f\u043d\u0432\u0430\u0440\u044c", "\u0444\u0435\u0432\u0440\u0430\u043b\u044c", "\u043c\u0430\u0440\u0442", "\u0430\u043f\u0440\u0435\u043b\u044c", "\u043c\u0430\u0439", "\u0438\u044e\u043d\u044c", "\u0438\u044e\u043b\u044c", "\u0430\u0432\u0433\u0443\u0441\u0442", "\u0441\u0435\u043d\u0442\u044f\u0431\u0440\u044c", "\u043e\u043a\u0442\u044f\u0431\u0440\u044c", "\u043d\u043e\u044f\u0431\u0440\u044c", "\u0434\u0435\u043a\u0430\u0431\u0440\u044c"};
    public static final String[] monthNamesRod = new String[]{"\u044f\u043d\u0432\u0430\u0440\u044f", "\u0444\u0435\u0432\u0440\u0430\u043b\u044f", "\u043c\u0430\u0440\u0442\u0430", "\u0430\u043f\u0440\u0435\u043b\u044f", "\u043c\u0430\u044f", "\u0438\u044e\u043d\u044f", "\u0438\u044e\u043b\u044f", "\u0430\u0432\u0433\u0443\u0441\u0442\u0430", "\u0441\u0435\u043d\u0442\u044f\u0431\u0440\u044f", "\u043e\u043a\u0442\u044f\u0431\u0440\u044f", "\u043d\u043e\u044f\u0431\u0440\u044f", "\u0434\u0435\u043a\u0430\u0431\u0440\u044f"};
    public static final String[] weekDayName = new String[]{"\u041f\u043d.", "\u0412\u0442.", "\u0421\u0440.", "\u0427\u0442.", "\u041f\u0442.", "\u0421\u0431.", "\u0412\u0441."};
    public static final String DATE_FORMAT_PATTERN_YYYY_MM_DD = "yyyy-MM-dd";
    public static final String DATE_FORMAT_PATTERN_YYYY_MM_DD_HHMMSS = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_PATTERN_DDMMYYYY = "dd.MM.yyyy";
    public static final String DATE_FORMAT_PATTERN_DDMMYYYY_HHMMSS = "dd.MM.yyyy HH:mm:ss";
    public static final String DATE_FORMAT_PATTERN_DDMMYYYY_HHMM = "dd.MM.yyyy HH:mm";

    public static final int getDayOfWeekMask(Calendar calendar) {
        return 1 << (calendar.get(7) - 2 + 7) % 7;
    }

    public static final int getDayOfMonthMask(Calendar calendar) {
        return 1 << calendar.get(5) - 1;
    }

    public static final int getHourOfDayMask(Calendar calendar) {
        return 1 << calendar.get(11);
    }

    public static final int getMonthOfYearMask(Calendar calendar) {
        return 1 << calendar.get(2);
    }

    public static final long getMinuteMask(Calendar calendar) {
        return 1L << calendar.get(12);
    }

    public static final boolean checkMasks(Calendar calendar, int n, int n2, int n3, int n4) {
        boolean bl = true;
        if (n > 0) {
            boolean bl2 = bl = (n & TimeUtils.getHourOfDayMask(calendar)) > 0;
        }
        if (bl && n2 > 0) {
            boolean bl3 = bl = (n2 & TimeUtils.getDayOfWeekMask(calendar)) > 0;
        }
        if (bl && n4 > 0) {
            boolean bl4 = bl = (n4 & TimeUtils.getDayOfMonthMask(calendar)) > 0;
        }
        if (bl && n3 > 0) {
            bl = (n3 & TimeUtils.getMonthOfYearMask(calendar)) > 0;
        }
        return bl;
    }

    public static final boolean checkMasks(Calendar calendar, int n, int n2, int n3, int n4, long l) {
        boolean bl = TimeUtils.checkMasks(calendar, n, n2, n3, n4);
        n = bl ? 1 : 0;
        if (bl && l > 0L) {
            n = (l & TimeUtils.getMinuteMask(calendar)) > 0L ? 1 : 0;
        }
        return n != 0;
    }

    public static final String convertCalendarToDateString(Calendar object) {
        if ((object = TimeUtils.format((Calendar)object, DATE_FORMAT_PATTERN_YYYY_MM_DD)) == null) {
            object = "0000-00-00";
        }
        return object;
    }

    public static final String convertCalendarToDateTimeString(Calendar object) {
        if ((object = TimeUtils.format((Calendar)object, "yyyy-MM-dd HH:00:00")) == null) {
            object = "0000-00-00 00:00:00";
        }
        return object;
    }

    public static final String format(Date date, String string) {
        if (date == null) {
            return "";
        }
        return TimeUtils.getDateFormat(string).format(date);
    }

    public static final String format(Date date, String string, TimeZone timeZone) {
        if (date == null) {
            return "";
        }
        return TimeUtils.getDateFormat(string, timeZone).format(date);
    }

    public static final String format(Date date, DateFormat dateFormat) {
        if (date == null) {
            return "";
        }
        return dateFormat.format(date);
    }

    public static final String format(Calendar calendar, String string) {
        if (calendar == null) {
            return "";
        }
        return TimeUtils.getDateFormat(string).format(calendar.getTime());
    }

    public static final String format(Calendar calendar, DateFormat dateFormat) {
        if (calendar == null) {
            return "";
        }
        return dateFormat.format(calendar.getTime());
    }

    public static final String formatTimestamp(Timestamp timestamp, String string) {
        String string2 = "";
        if (timestamp != null && string != null) {
            string2 = TimeUtils.getDateFormat(string).format(new java.sql.Date(timestamp.getTime()));
        }
        return string2;
    }

    public static final String formatDate(Calendar calendar) {
        return TimeUtils.format(calendar, DATE_FORMAT_PATTERN_DDMMYYYY);
    }

    public static final String formatDate(Date date) {
        return TimeUtils.format(date, DATE_FORMAT_PATTERN_DDMMYYYY);
    }

    public static final String formatSQLDate(Date date) {
        return TimeUtils.format(date, DATE_FORMAT_PATTERN_YYYY_MM_DD);
    }

    public static final String formatSQLDate(Calendar calendar) {
        return TimeUtils.format(calendar, DATE_FORMAT_PATTERN_YYYY_MM_DD);
    }

    public static final String formatPeriod(Calendar calendar, Calendar calendar2) {
        return TimeUtils.formatPeriod(calendar != null ? calendar.getTime() : null, calendar2 != null ? calendar2.getTime() : null);
    }

    public static final String formatPeriod(Date date, Date date2) {
        return (date != null ? TimeUtils.formatDate(date) : "\u2026") + "-" + (date2 != null ? TimeUtils.formatDate(date2) : "\u2026");
    }

    public static final String formatPeriod(Period period) {
        return TimeUtils.formatPeriod(period.getDateFrom(), period.getDateTo());
    }

    public static final String formatPeriodWithTime(Date date, Date date2) {
        return (date != null ? TimeUtils.formatFullDate(date) : "\u2026") + " - " + (date2 != null ? TimeUtils.formatFullDate(date2) : "\u2026");
    }

    public static final String formatPeriodWithTime(Period period) {
        return TimeUtils.formatPeriodWithTime(period.getDateFrom(), period.getDateTo());
    }

    public static String formatFullDate(Date serializable) {
        String string = "";
        if (serializable != null) {
            try {
                string = TimeUtils.getDateFormat(DATE_FORMAT_PATTERN_DDMMYYYY_HHMMSS).format((Date)serializable);
            }
            catch (Exception exception) {
                serializable = exception;
                exception.printStackTrace();
            }
        }
        return string;
    }

    public static final String formatDeltaTime(long l) {
        int n = (int)(l / 86400L);
        int n2 = (int)((l -= (long)(n * 86400)) / 3600L);
        int n3 = (int)((l -= (long)(n2 * 3600)) / 60L);
        int n4 = (int)(l -= (long)(n3 * 60));
        StringBuffer stringBuffer = new StringBuffer(30);
        DecimalFormat decimalFormat = new DecimalFormat("00");
        stringBuffer.append(n);
        stringBuffer.append(" d ");
        stringBuffer.append(decimalFormat.format(n2));
        stringBuffer.append(":");
        stringBuffer.append(decimalFormat.format(n3));
        stringBuffer.append(":");
        stringBuffer.append(decimalFormat.format(n4));
        return stringBuffer.toString();
    }

    public static final Date convertCalendarToDate(Calendar calendar) {
        if (calendar != null) {
            return calendar.getTime();
        }
        return null;
    }

    public static final Date convertSqlDateToDate(java.sql.Date date) {
        Date date2 = null;
        if (date != null) {
            date2 = new Date(date.getTime());
        }
        return date2;
    }

    public static Date parseDate(String string, String string2) {
        return TimeUtils.parseDate(string, TimeUtils.getDateFormat(string2));
    }

    public static Date parseDate(String string, String string2, TimeZone timeZone) {
        return TimeUtils.parseDate(string, TimeUtils.getDateFormat(string2, timeZone));
    }

    public static Date parseDate(String string, DateFormat dateFormat) {
        Date date = null;
        if (string != null && dateFormat != null) {
            try {
                date = dateFormat.parse(string);
            }
            catch (Exception exception) {}
        }
        return date;
    }

    public static final Calendar convertDateToCalendar(Date date) {
        GregorianCalendar gregorianCalendar = null;
        if (date != null) {
            gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
        }
        return gregorianCalendar;
    }

    public static final Calendar convertStringToCalendar(String string) {
        Calendar calendar = null;
        if (string != null && string.length() > 0 && !"00.00.0000".equals(string) && (calendar = TimeUtils.convertStringToCalendar(string, DATE_FORMAT_PATTERN_DDMMYYYY)) == null) {
            calendar = TimeUtils.convertStringToCalendar(string, DATE_FORMAT_PATTERN_YYYY_MM_DD);
        }
        return calendar;
    }

    public static final Date convertStringToDate(String string) {
        Date date = TimeUtils.convertStringToDate(string, DATE_FORMAT_PATTERN_DDMMYYYY);
        if (date == null) {
            date = TimeUtils.convertStringToDate(string, DATE_FORMAT_PATTERN_YYYY_MM_DD);
        }
        return date;
    }

    public static final Calendar convertStringToCalendar(String string, String object) {
        GregorianCalendar gregorianCalendar = null;
        if (string != null && object != null) {
            try {
                object = new SimpleDateFormat((String)object);
                gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(((DateFormat)object).parse(string));
            }
            catch (ParseException parseException) {}
        }
        return gregorianCalendar;
    }

    public static final Date convertStringToDate(String string, String object) {
        Date date = null;
        if (string != null && object != null) {
            try {
                object = new SimpleDateFormat((String)object);
                date = ((DateFormat)object).parse(string);
            }
            catch (ParseException parseException) {}
        }
        return date;
    }

    public static final Calendar convertFullStringToCalendar(String string) {
        return TimeUtils.convertStringToCalendar(string, "dd.MM.yyyy HH':00:00'");
    }

    public static final Calendar convertTimestampToCalendar(Timestamp timestamp) {
        GregorianCalendar gregorianCalendar = null;
        if (timestamp != null) {
            gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeInMillis(timestamp.getTime());
        }
        return gregorianCalendar;
    }

    public static final Date convertTimestampToDate(Timestamp timestamp) {
        Date date = null;
        if (timestamp != null) {
            date = new Date(timestamp.getTime());
        }
        return date;
    }

    public static Calendar parseCalendar(String object, String object2) {
        if ((object = TimeUtils.parseDate((String)object, (String)object2)) != null) {
            object2 = new GregorianCalendar();
            ((Calendar)object2).setTime((Date)object);
            return object2;
        }
        return null;
    }

    public static Calendar parseCalendar(String object, DateFormat dateFormat) {
        GregorianCalendar gregorianCalendar = null;
        if ((object = TimeUtils.parseDate((String)object, dateFormat)) != null) {
            gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime((Date)object);
        }
        return gregorianCalendar;
    }

    public static final Calendar clear_MIN_MIL_SEC(Calendar calendar) {
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        return calendar;
    }

    public static final Calendar clear_HOUR_MIN_MIL_SEC(Calendar calendar) {
        TimeUtils.clear_MIN_MIL_SEC(calendar);
        calendar.set(11, 0);
        return calendar;
    }

    public static final Date clear_HOUR_MIN_MIL_SEC(Date comparable) {
        comparable = TimeUtils.convertDateToCalendar((Date)comparable);
        TimeUtils.clear_MIN_MIL_SEC((Calendar)comparable);
        ((Calendar)comparable).set(11, 0);
        return TimeUtils.convertCalendarToDate(comparable);
    }

    public static final Date clear_MILLISECOND(Date comparable) {
        comparable = TimeUtils.convertDateToCalendar(comparable);
        ((Calendar)comparable).set(14, 0);
        return TimeUtils.convertCalendarToDate((Calendar)comparable);
    }

    public static final Calendar getEndDay(Calendar calendar) {
        calendar = (Calendar)calendar.clone();
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 0);
        return calendar;
    }

    public static final Date getEndDay(Date date) {
        return TimeUtils.getEndDay(TimeUtils.convertDateToCalendar(date)).getTime();
    }

    public static final Calendar getStartMonth(Calendar calendar) {
        calendar = (Calendar)calendar.clone();
        calendar.set(5, 1);
        return calendar;
    }

    public static final Date getStartMonth(Date date) {
        return TimeUtils.getStartMonth(TimeUtils.convertDateToCalendar(date)).getTime();
    }

    public static final Date getEndMonth(Date date) {
        return TimeUtils.getEndMonth(TimeUtils.convertDateToCalendar(date)).getTime();
    }

    public static final Calendar getEndMonth(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.set(5, calendar.getActualMaximum(5));
        return calendar2;
    }

    public static final Calendar convertSqlDateToCalendar(java.sql.Date date) {
        return TimeUtils.convertDateToCalendar(TimeUtils.convertSqlDateToDate(date));
    }

    public static final Calendar getNextDay(Calendar calendar) {
        calendar = (Calendar)calendar.clone();
        TimeUtils.moveToStartNextDay(calendar);
        return calendar;
    }

    public static final Calendar getNextMonth(Calendar calendar) {
        Calendar calendar2 = null;
        if (calendar != null) {
            calendar2 = (Calendar)calendar.clone();
            calendar2.add(2, 1);
            calendar2.set(11, 0);
            calendar2.set(12, 0);
            calendar2.set(13, 0);
            calendar2.set(14, 0);
        }
        return calendar2;
    }

    public static final Date getNextMonth(Date date) {
        return TimeUtils.convertCalendarToDate(TimeUtils.getNextMonth(TimeUtils.convertDateToCalendar(date)));
    }

    public static final Calendar getPrevDay(Calendar calendar) {
        calendar = (Calendar)calendar.clone();
        calendar.add(6, -1);
        return calendar;
    }

    public static final Date getPrevDay(Date date) {
        return TimeUtils.convertCalendarToDate(TimeUtils.getPrevDay(TimeUtils.convertDateToCalendar(date)));
    }

    public static final Date getNextDay(Date date) {
        return TimeUtils.convertCalendarToDate(TimeUtils.getNextDay(TimeUtils.convertDateToCalendar(date)));
    }

    public static final java.sql.Date convertCalendarToSqlDate(Calendar calendar) {
        java.sql.Date date = null;
        if (calendar != null) {
            date = new java.sql.Date(calendar.getTimeInMillis());
        }
        return date;
    }

    public static final java.sql.Date convertDateToSqlDate(Date date) {
        if (date != null) {
            return new java.sql.Date(date.getTime());
        }
        return null;
    }

    public static final java.sql.Date convertSQLDate(String string) {
        java.sql.Date date = null;
        if (string != null) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT_PATTERN_DDMMYYYY);
                date = new java.sql.Date(simpleDateFormat.parse(string).getTime());
            }
            catch (Exception exception) {}
        }
        return date;
    }

    public static final Timestamp convertCalendarToTimestamp(Calendar calendar) {
        Timestamp timestamp = null;
        if (calendar != null) {
            timestamp = new Timestamp(calendar.getTimeInMillis());
        }
        return timestamp;
    }

    public static final Timestamp convertDateToTimestamp(Date date) {
        Timestamp timestamp = null;
        if (date != null) {
            timestamp = new Timestamp(date.getTime());
        }
        return timestamp;
    }

    public static final Timestamp convertDateToTimestampSeconds(Date date) {
        if (date != null) {
            return new Timestamp(date.getTime() / 1000L * 1000L);
        }
        return null;
    }

    public static final Timestamp convertLongToTimestamp(long l) {
        return new Timestamp(l);
    }

    public static final Timestamp convertLongToTimestamp(Long l) {
        Timestamp timestamp = null;
        if (l != null) {
            timestamp = new Timestamp(l);
        }
        return timestamp;
    }

    public static final DateFormat getDateFormat(String object, TimeZone timeZone) {
        try {
            object = new SimpleDateFormat((String)object);
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            object = new SimpleDateFormat(DATE_FORMAT_PATTERN_DDMMYYYY);
        }
        if (timeZone != null) {
            ((DateFormat)object).setTimeZone(timeZone);
        }
        return object;
    }

    public static final DateFormat getDateFormat(String string) {
        return TimeUtils.getDateFormat(string, null);
    }

    public static final int daysDelta(Calendar calendar, Calendar calendar2) {
        calendar = (Calendar)calendar.clone();
        TimeUtils.clear_HOUR_MIN_MIL_SEC(calendar);
        calendar2 = (Calendar)calendar2.clone();
        TimeUtils.clear_HOUR_MIN_MIL_SEC(calendar2);
        long l = calendar.getTimeInMillis();
        long l2 = calendar2.getTimeInMillis();
        int n = (int)(l / 86400000L);
        int n2 = (int)(l2 / 86400000L);
        return n2 - n;
    }

    public static final int daysDelta(Date date, Date date2) {
        return TimeUtils.daysDelta(TimeUtils.convertDateToCalendar(date), TimeUtils.convertDateToCalendar(date2));
    }

    public static final int hourDelta(Calendar calendar, Calendar calendar2) {
        long l = (calendar2.getTimeInMillis() - calendar.getTimeInMillis()) / 1000L;
        return (int)(l / 3600L);
    }

    public static final int monthsDelta(Date date, Date date2) {
        return TimeUtils.monthsDelta(TimeUtils.convertDateToCalendar(date), TimeUtils.convertDateToCalendar(date2));
    }

    public static final int monthsDelta(Calendar calendar, Calendar calendar2) {
        return (calendar2.get(1) - calendar.get(1)) * 12 + (calendar2.get(2) - calendar.get(2));
    }

    public static final float getPart(long l, long l2, long l3, long l4) {
        if (l == 0L || l < l3) {
            l = l3;
        }
        if (l2 == 0L || l4 < l2) {
            l2 = l4;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(l);
        gregorianCalendar2.setTimeInMillis(l2);
        int n = TimeUtils.daysDelta(gregorianCalendar, gregorianCalendar2) + 1;
        gregorianCalendar.setTimeInMillis(l3);
        gregorianCalendar2.setTimeInMillis(l4);
        float f = (float)n / (float)(TimeUtils.daysDelta(gregorianCalendar, gregorianCalendar2) + 1);
        return f;
    }

    public static final float getPart(Calendar calendar, Calendar calendar2, Calendar calendar3, Calendar calendar4) {
        if (calendar == null || TimeUtils.dateBefore(calendar, calendar3)) {
            calendar = calendar3;
        }
        if (calendar2 == null || TimeUtils.dateBefore(calendar4, calendar2)) {
            calendar2 = calendar4;
        }
        int n = TimeUtils.daysDelta(calendar, calendar2) + 1;
        float f = (float)n / (float)(TimeUtils.daysDelta(calendar3, calendar4) + 1);
        return f;
    }

    public static boolean dateBefore(Calendar calendar, Calendar calendar2) {
        if (calendar != null && calendar2 != null) {
            if (calendar.get(1) == calendar2.get(1)) {
                return calendar.get(6) < calendar2.get(6);
            }
            return calendar.get(1) < calendar2.get(1);
        }
        return false;
    }

    public static boolean dateBefore(Date date, Date date2) {
        return TimeUtils.dateBefore(TimeUtils.convertDateToCalendar(date), TimeUtils.convertDateToCalendar(date2));
    }

    public static boolean dateEqual(Calendar calendar, Calendar calendar2) {
        return calendar == calendar2 || calendar != null && calendar2 != null && calendar.get(6) == calendar2.get(6) && calendar.get(1) == calendar2.get(1);
    }

    public static boolean dateEqual(Date date, Date date2) {
        return TimeUtils.dateEqual(TimeUtils.convertDateToCalendar(date), TimeUtils.convertDateToCalendar(date2));
    }

    public static boolean dateHourEqual(Calendar calendar, Calendar calendar2) {
        return TimeUtils.dateEqual(calendar, calendar2) && calendar.get(11) == calendar2.get(11);
    }

    public static boolean dateBeforeOrEq(Calendar calendar, Calendar calendar2) {
        return TimeUtils.dateBefore(calendar, calendar2) || TimeUtils.dateEqual(calendar, calendar2);
    }

    public static boolean dateBeforeOrEq(Date date, Date date2) {
        return TimeUtils.dateBeforeOrEq(TimeUtils.convertDateToCalendar(date), TimeUtils.convertDateToCalendar(date2));
    }

    public static final boolean dateInRange(Calendar calendar, Calendar calendar2, Calendar calendar3) {
        return !(calendar == null || calendar2 != null && !TimeUtils.dateBeforeOrEq(calendar2, calendar) || calendar3 != null && !TimeUtils.dateBeforeOrEq(calendar, calendar3));
    }

    public static final boolean dateInRange(Date date, Date date2, Date date3) {
        return !(date == null || date2 != null && !TimeUtils.dateBeforeOrEq(date2, date) || date3 != null && !TimeUtils.dateBeforeOrEq(date, date3));
    }

    public static final boolean dateInRangeWithTime(Date date, Date date2, Date date3) {
        boolean bl = false;
        if (date != null) {
            bl = true;
            if (date2 != null) {
                boolean bl2 = bl = date2.getTime() <= date.getTime();
            }
            if (bl && date3 != null) {
                bl = date.getTime() <= date3.getTime();
            }
        }
        return bl;
    }

    public static final boolean dateInPeriod(Date date, Period period) {
        return !(date == null || period == null || period.getDateFrom() != null && period.getDateFrom().getTime() > date.getTime() || period.getDateTo() != null && date.getTime() > period.getDateTo().getTime());
    }

    public static final boolean periodInRange(Calendar calendar, Calendar calendar2, Calendar calendar3, Calendar calendar4) {
        boolean bl = calendar3 == null || calendar != null && TimeUtils.dateBeforeOrEq(calendar3, calendar);
        if (bl) {
            bl = calendar4 == null || calendar2 != null && TimeUtils.dateBeforeOrEq(calendar2, calendar4);
        }
        return bl;
    }

    public static final boolean periodInRange(Date date, Date date2, Date date3, Date date4) {
        boolean bl = date3 == null || date != null && TimeUtils.dateBeforeOrEq(date3, date);
        if (bl) {
            bl = date4 == null || date2 != null && TimeUtils.dateBeforeOrEq(date2, date4);
        }
        return bl;
    }

    public static final void moveToEndOfMonth(Calendar calendar) {
        if (calendar != null) {
            calendar.set(5, calendar.getActualMaximum(5));
        }
    }

    public static final void moveToStartNextDay(Calendar calendar) {
        if (calendar != null) {
            calendar.add(6, 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
        }
    }

    public static final Date moveToEndDay(Date date) {
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            TimeUtils.moveToEndDay(calendar);
            return calendar.getTime();
        }
        return null;
    }

    public static final void moveToEndDay(Calendar calendar) {
        if (calendar != null) {
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
        }
    }

    public static void clearCalendarHour(Calendar calendar) {
        if (calendar != null) {
            calendar.clear(14);
            calendar.clear(13);
            calendar.clear(12);
            calendar.set(11, 0);
        }
    }

    public static Date nowPlusPeriod(int n, int n2) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(n, n2);
        return calendar.getTime();
    }

    public static Calendar plusPeriod(Calendar calendar, int n, int n2) {
        calendar = (Calendar)calendar.clone();
        calendar.add(n, n2);
        return calendar;
    }

    public static Date plusPeriod(Date date, int n, int n2) {
        return TimeUtils.convertCalendarToDate(TimeUtils.plusPeriod(TimeUtils.convertDateToCalendar(date), n, n2));
    }

    public static boolean checkDateIntervalsIntersection(Date date, Date date2, Date date3, Date date4) {
        if (date == null && date2 == null || date3 == null && date4 == null) {
            return true;
        }
        date = date == null ? TimeUtils.convertStringToDate("01.01.0001") : date;
        date2 = date2 == null ? TimeUtils.convertStringToDate("31.12.9999") : date2;
        date3 = date3 == null ? TimeUtils.convertStringToDate("01.01.0001") : date3;
        Date date5 = date4 = date4 == null ? TimeUtils.convertStringToDate("31.12.9999") : date4;
        return TimeUtils.dateInRange(date, date3, date4) || TimeUtils.dateInRange(date2, date3, date4) || TimeUtils.dateInRange(date3, date, date2) || TimeUtils.dateInRange(date4, date, date2);
    }

    public static int compare(Calendar calendar, Calendar calendar2, int n) {
        int n2 = TimeUtils.a(calendar, calendar2, 1);
        if (n2 != 0 || n == 1) {
            return n2;
        }
        if (n == 3) {
            return TimeUtils.a(calendar, calendar2, 3);
        }
        if (n == 6) {
            return TimeUtils.a(calendar, calendar2, 6);
        }
        n2 = TimeUtils.a(calendar, calendar2, 2);
        if (n2 != 0 || n == 2) {
            return n2;
        }
        if (n == 4) {
            return TimeUtils.a(calendar, calendar2, 4);
        }
        n2 = TimeUtils.a(calendar, calendar2, 5);
        if (n2 != 0 || n == 5 || n == 5 || n == 7 || n == 8) {
            return n2;
        }
        n2 = TimeUtils.a(calendar, calendar2, 11);
        if (n2 != 0 || n == 10 || n == 11) {
            return n2;
        }
        n2 = TimeUtils.a(calendar, calendar2, 12);
        if (n2 != 0 || n == 12) {
            return n2;
        }
        n2 = TimeUtils.a(calendar, calendar2, 13);
        if (n2 != 0 || n == 13) {
            return n2;
        }
        if (n == 14) {
            return TimeUtils.a(calendar, calendar2, 14);
        }
        throw new IllegalArgumentException("Invalid field: " + n);
    }

    private static int a(Calendar calendar, Calendar calendar2, int n) {
        int n2 = calendar.get(n) - calendar2.get(n);
        if (n2 < 0) {
            return -1;
        }
        if (n2 > 0) {
            return 1;
        }
        return 0;
    }

    public static long clearToBeginDay(Calendar calendar) {
        Calendar calendar2 = Calendar.getInstance();
        calendar2.clear();
        calendar2.set(calendar.get(1), calendar.get(2), calendar.get(5));
        return calendar2.getTimeInMillis();
    }

    public static void floor(Calendar calendar, int n) {
        switch (n) {
            case 12: {
                calendar.set(14, 0);
                calendar.set(13, 0);
                return;
            }
            case 10: 
            case 11: {
                calendar.set(14, 0);
                calendar.set(13, 0);
                calendar.set(12, 0);
                return;
            }
            case 5: {
                calendar.set(14, 0);
                calendar.set(13, 0);
                calendar.set(12, 0);
                calendar.set(11, 0);
                return;
            }
            case 3: {
                calendar.set(14, 0);
                calendar.set(13, 0);
                calendar.set(12, 0);
                calendar.set(11, 0);
                calendar.set(7, calendar.getFirstDayOfWeek());
                return;
            }
            case 2: {
                calendar.set(14, 0);
                calendar.set(13, 0);
                calendar.set(12, 0);
                calendar.set(11, 0);
                calendar.set(5, 1);
                return;
            }
            case 1: {
                calendar.set(14, 0);
                calendar.set(13, 0);
                calendar.set(12, 0);
                calendar.set(11, 0);
                calendar.set(5, 1);
                calendar.set(2, 0);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public static String formatCount(int n, int n2) {
        switch (n) {
            case 5: {
                return MessageFormat.format("{0} {0, choice, 0#\u0434\u043d\u0435\u0439| 1#\u0434\u0435\u043d\u044c| 2#\u0434\u043d\u044f| 3#\u0434\u043d\u044f| 4#\u0434\u043d\u044f| 4<\u0434\u043d\u0435\u0439| 20<{1}}", n2, MessageFormat.format("{0, choice, 0#\u0434\u043d\u0435\u0439| 1#\u0434\u0435\u043d\u044c| 2#\u0434\u043d\u044f| 3#\u0434\u043d\u044f| 4#\u0434\u043d\u044f| 4<\u0434\u043d\u0435\u0439}", n2 % 10));
            }
            case 2: {
                return MessageFormat.format("{0} {0, choice, 0#\u043c\u0435\u0441\u044f\u0446\u0435\u0432| 1#\u043c\u0435\u0441\u044f\u0446| 2#\u043c\u0435\u0441\u044f\u0446\u0430| 3#\u043c\u0435\u0441\u044f\u0446\u0430| 4#\u043c\u0435\u0441\u044f\u0446\u0430| 4<\u043c\u0435\u0441\u044f\u0446\u0435\u0432| 20<{1}}", n2, MessageFormat.format("{0, choice, 0#\u043c\u0435\u0441\u044f\u0446\u0435\u0432| 1#\u043c\u0435\u0441\u044f\u0446| 2#\u043c\u0435\u0441\u044f\u0446\u0430| 3#\u043c\u0435\u0441\u044f\u0446\u0430| 4#\u043c\u0435\u0441\u044f\u0446\u0430| 4<\u043c\u0435\u0441\u044f\u0446\u0435\u0432}", n2 % 10));
            }
            case 10: 
            case 11: {
                return MessageFormat.format("{0} {0, choice, 0#\u0447\u0430\u0441\u043e\u0432| 1#\u0447\u0430\u0441| 2#\u0447\u0430\u0441\u0430| 3#\u0447\u0430\u0441\u0430| 4#\u0447\u0430\u0441\u0430| 4<\u0447\u0430\u0441\u043e\u0432| 20<{1}}", n2, MessageFormat.format("{0, choice, 0#\u0447\u0430\u0441\u043e\u0432| 1#\u0447\u0430\u0441| 2#\u0447\u0430\u0441\u0430| 3#\u0447\u0430\u0441\u0430| 4#\u0447\u0430\u0441\u0430| 4<\u0447\u0430\u0441\u043e\u0432}", n2 % 10));
            }
            case 12: {
                return MessageFormat.format("{0} {0, choice, 0#\u043c\u0438\u043d\u0443\u0442| 1#\u043c\u0438\u043d\u0443\u0442\u0430| 2#\u043c\u0438\u043d\u0443\u0442\u044b| 3#\u043c\u0438\u043d\u0443\u0442\u044b| 4#\u043c\u0438\u043d\u0443\u0442\u044b| 4<\u043c\u0438\u043d\u0443\u0442| 20<{1}}", n2, MessageFormat.format("{0, choice, 0#\u043c\u0438\u043d\u0443\u0442| 1#\u043c\u0438\u043d\u0443\u0442\u0430| 2#\u043c\u0438\u043d\u0443\u0442\u044b| 3#\u043c\u0438\u043d\u0443\u0442\u044b| 4#\u043c\u0438\u043d\u0443\u0442\u044b| 4<\u043c\u0438\u043d\u0443\u0442}", n2 % 10));
            }
            case 3: 
            case 4: {
                return MessageFormat.format("{0} {0, choice, 0#\u043d\u0435\u0434\u0435\u043b\u044c| 1#\u043d\u0435\u0434\u0435\u043b\u044f| 2#\u043d\u0435\u0434\u0435\u043b\u0438| 3#\u043d\u0435\u0434\u0435\u043b\u0438| 4#\u043d\u0435\u0434\u0435\u043b\u0438| 4<\u043d\u0435\u0434\u0435\u043b\u044c| 20<{1}}", n2, MessageFormat.format("{0, choice, 0#\u043d\u0435\u0434\u0435\u043b\u044c| 1#\u043d\u0435\u0434\u0435\u043b\u044f| 2#\u043d\u0435\u0434\u0435\u043b\u0438| 3#\u043d\u0435\u0434\u0435\u043b\u0438| 4#\u043d\u0435\u0434\u0435\u043b\u0438| 4<\u043d\u0435\u0434\u0435\u043b\u044c}", n2 % 10));
            }
            case 1: {
                return MessageFormat.format("{0} {0, choice, 0#\u043b\u0435\u0442| 1#\u0433\u043e\u0434| 2#\u0433\u043e\u0434\u0430| 3#\u0433\u043e\u0434\u0430| 4#\u0433\u043e\u0434\u0430| 4<\u043b\u0435\u0442| 20<{1}}", n2, MessageFormat.format("{0, choice, 0#\u043b\u0435\u0442| 1#\u0433\u043e\u0434| 2#\u0433\u043e\u0434\u0430| 3#\u0433\u043e\u0434\u0430| 4#\u0433\u043e\u0434\u0430| 4<\u043b\u0435\u0442}", n2 % 10));
            }
        }
        throw new IllegalArgumentException();
    }

    public static Date subtractHoursFromNow(int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        ((Calendar)gregorianCalendar).add(11, -n);
        return gregorianCalendar.getTime();
    }

    public static final boolean timeInRange(Date date, Date date2, Date date3) {
        return !(date == null || date2 != null && date2.compareTo(date) > 0 || date3 != null && date3.compareTo(date) < 0);
    }

    public static long rountToSeconds(long l) {
        return l / 1000L * 1000L;
    }

    public static final long convertDateToMillisFrom(Calendar calendar, Date date) {
        if (date != null) {
            calendar.setTime(date);
            TimeUtils.clear_HOUR_MIN_MIL_SEC(calendar);
            return calendar.getTimeInMillis();
        }
        return 0L;
    }

    public static final long convertDateToMillisTo(Calendar calendar, Date date) {
        if (date != null) {
            calendar.setTime(date);
            TimeUtils.clear_HOUR_MIN_MIL_SEC(calendar);
            calendar.add(5, 1);
            return calendar.getTimeInMillis() - 1L;
        }
        return 0L;
    }

    public static final Date convertMillisToDate(long l) {
        if (l == 0L) {
            return null;
        }
        return new Date(l);
    }

    public static final Calendar convertMillisToCalendar(long l) {
        return TimeUtils.convertDateToCalendar(TimeUtils.convertMillisToDate(l));
    }

    public static long hourToMillis(long l) {
        return l / 3600000L * 3600000L;
    }

    public static String formatSecondsToDayHourMinute(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(l / 60L / 60L / 24L);
        stringBuilder.append(":");
        long l2 = l % 86400L / 60L / 60L;
        if (l2 < 10L) {
            stringBuilder.append("0");
        }
        stringBuilder.append(l2);
        stringBuilder.append(":");
        long l3 = l % 3600L / 60L;
        if (l3 < 10L) {
            stringBuilder.append("0");
        }
        stringBuilder.append(l3);
        return stringBuilder.toString();
    }

    public static boolean checkMonthAndYearDates(Date comparable, Date comparable2) {
        boolean bl = false;
        if (comparable != null && comparable2 == null) {
            comparable = TimeUtils.convertDateToCalendar((Date)comparable);
            comparable2 = TimeUtils.convertDateToCalendar((Date)comparable2);
            if (((Calendar)comparable).get(1) == ((Calendar)comparable2).get(1) && ((Calendar)comparable).get(2) == ((Calendar)comparable2).get(2)) {
                bl = true;
            }
        }
        return bl;
    }
}

