/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.xml.NodeListElementIterator;

public class XMLUtils {
    private static final Logger a = Logger.getLogger(XMLUtils.class);
    protected static final Pattern slashPattern = Pattern.compile("/");

    public static final XMLInputFactory newXMLInputFactory() {
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        xMLInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
        xMLInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        xMLInputFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        xMLInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        return xMLInputFactory;
    }

    public static final BGXMLEventReader newXMLEventReader(Reader reader) {
        return XMLUtils.newXMLEventReader(XMLUtils.newXMLInputFactory(), reader);
    }

    public static final BGXMLEventReader newXMLEventReader(InputStream inputStream) {
        return XMLUtils.newXMLEventReader(XMLUtils.newXMLInputFactory(), inputStream);
    }

    public static final BGXMLEventReader newXMLEventReader(XMLInputFactory xMLInputFactory, Reader object) {
        try {
            object = xMLInputFactory.createXMLEventReader((Reader)object);
            return new ru.bitel.common.a(xMLInputFactory, (XMLEventReader)object);
        }
        catch (XMLStreamException xMLStreamException) {
            a.error((Object)xMLStreamException.getMessage(), (Throwable)xMLStreamException);
            return null;
        }
    }

    public static final BGXMLEventReader newXMLEventReader(XMLInputFactory xMLInputFactory, InputStream object) {
        try {
            object = xMLInputFactory.createXMLEventReader((InputStream)object);
            return new ru.bitel.common.a(xMLInputFactory, (XMLEventReader)object);
        }
        catch (XMLStreamException xMLStreamException) {
            a.error((Object)xMLStreamException.getMessage(), (Throwable)xMLStreamException);
            return null;
        }
    }

    public static final Document newDocument() {
        try {
            Object object = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object).setNamespaceAware(true);
            object = ((DocumentBuilderFactory)object).newDocumentBuilder();
            return ((DocumentBuilder)object).newDocument();
        }
        catch (Exception exception) {
            a.error((Object)exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    @Deprecated
    public static final Element newElement(Element element, String string) {
        return XMLUtils.createElement(element, string);
    }

    @Deprecated
    public static final Element newElement(Document document, String string) {
        return XMLUtils.createElement(document, string);
    }

    public static final Element createElement(Document document, String object) {
        object = document.createElement((String)object);
        document.appendChild((Node)object);
        return object;
    }

    public static Element createElement(Element element, String string) {
        Element element2 = null;
        if (element != null && string != null) {
            element2 = element.getOwnerDocument().createElement(string);
            element.appendChild(element2);
        }
        return element2;
    }

    public static void createTextNode(Node node, String string) {
        if (node != null && string != null) {
            node.appendChild(node.getOwnerDocument().createTextNode(string));
        }
    }

    public static Element createListElement(Element element, String string, List<?> list, Class<?> clazz) {
        return XMLUtils.createListElement(element, string, list, clazz, null);
    }

    public static Element createListElement(Element element, String string, List<?> list, Class<?> clazz, String[] stringArray) {
        return XMLUtils.createListElement(element, string, "item", list, clazz, stringArray);
    }

    public static Element createListElement(Element methodArray, String arrayList, String string, List<?> object, Class<?> object2, String[] object3) {
        Element element;
        block13: {
            element = null;
            if (methodArray == null || arrayList == null) break block13;
            element = XMLUtils.createElement((Element)methodArray, (String)((Object)arrayList));
            if (object != null) {
                if (((Class)object2).isArray()) {
                    methodArray = object.iterator();
                    while (methodArray.hasNext()) {
                        arrayList = methodArray.next();
                        Element element2 = XMLUtils.createElement(element, string);
                        if (!(arrayList instanceof String[])) continue;
                        String[] stringArray = (String[])arrayList;
                        for (int i = 0; i < ((String[])object3).length; ++i) {
                            if (i >= stringArray.length) continue;
                            element2.setAttribute((String)object3[i], stringArray[i]);
                        }
                    }
                } else {
                    Object object4;
                    Object object5;
                    methodArray = ((Class)object2).getMethods();
                    if (object3 != null && ((String[])object3).length > 0) {
                        arrayList = new ArrayList<Object>();
                        object5 = object3;
                        int n = ((String[])object3).length;
                        for (int i = 0; i < n; ++i) {
                            object3 = object5[i];
                            String string2 = "get".concat(((String)object3).substring(0, 1).toUpperCase()).concat(((String)object3).substring(1));
                            try {
                                object4 = ((Class)object2).getMethod(string2, new Class[0]);
                                if (object4 == null) continue;
                                arrayList.add(object4);
                                continue;
                            }
                            catch (Exception exception) {
                                object4 = exception;
                                exception.printStackTrace();
                            }
                        }
                        methodArray = arrayList.toArray(new Method[0]);
                    }
                    arrayList = object.iterator();
                    while (arrayList.hasNext()) {
                        object5 = arrayList.next();
                        Element element3 = XMLUtils.createElement(element, string);
                        Method[] methodArray2 = methodArray;
                        int n = methodArray.length;
                        for (int i = 0; i < n; ++i) {
                            object4 = methodArray2[i];
                            object = ((Method)object4).getName();
                            object = ((String)object).substring(3);
                            object = ((String)object).substring(0, 1).toLowerCase().concat(((String)object).substring(1));
                            try {
                                object2 = ((Method)object4).invoke(object5, null);
                                element3.setAttribute((String)object, object2 == null ? "" : object2.toString());
                                continue;
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            }
        }
        return element;
    }

    public static void setAttribute(Element element, String string, String string2) {
        if (string2 != null) {
            element.setAttribute(string, string2);
        }
    }

    public static Document parseDocument(InputStream inputStream) {
        return XMLUtils.parseDocument(inputStream, true);
    }

    public static Document parseDocument(InputStream inputStream, boolean bl) {
        return XMLUtils.parseDocument(new InputSource(inputStream), bl);
    }

    public static Document parseDocument(InputSource inputSource) {
        return XMLUtils.parseDocument(inputSource, true);
    }

    public static Document parseDocument(InputSource inputSource, boolean bl) {
        Document document;
        block3: {
            document = null;
            if (inputSource != null) {
                try {
                    Object object = DocumentBuilderFactory.newInstance();
                    ((DocumentBuilderFactory)object).setNamespaceAware(true);
                    ((DocumentBuilderFactory)object).setValidating(false);
                    object = ((DocumentBuilderFactory)object).newDocumentBuilder();
                    document = ((DocumentBuilder)object).parse(inputSource);
                }
                catch (Exception exception) {
                    if (!bl) break block3;
                    a.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }
        return document;
    }

    public static void parseDocument(InputSource inputSource, ContentHandler contentHandler) {
        try {
            Object object = SAXParserFactory.newInstance();
            object = ((SAXParserFactory)object).newSAXParser();
            object = ((SAXParser)object).getXMLReader();
            object.setContentHandler(contentHandler);
            object.parse(inputSource);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    @Deprecated
    public static Document parseDoc(String string) {
        return XMLUtils.parseDocument(new InputSource(new StringReader(string.toString())));
    }

    public static Element getElement(Document document, String string) {
        return (Element)XMLUtils.getNode(document, string);
    }

    public static Node getNode(Document document, String object) {
        if (document == null) {
            return null;
        }
        NodeList nodeList = document.getElementsByTagName((String)object);
        if (nodeList != null && nodeList.getLength() > 0) {
            object = nodeList.item(0);
        } else {
            object = document.createElement((String)object);
            document.getDocumentElement().appendChild((Node)object);
        }
        return object;
    }

    public static Element selectElement(Node node, String string) {
        return (Element)XMLUtils.selectNode(node, string);
    }

    public static Node selectNode(Node node, String string) {
        try {
            return XPathAPI.selectSingleNode((Node)node, (String)string);
        }
        catch (Exception exception) {
            a.error((Object)exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    public static Iterable<Element> selectElements(Node object, String string) {
        try {
            object = XPathAPI.selectNodeList((Node)object, (String)string);
            return XMLUtils.elements((NodeList)object);
        }
        catch (Exception exception) {
            a.error((Object)exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    public static Iterable<Element> elements(NodeList nodeList) {
        return new Iterable<Element>(nodeList){
            private /* synthetic */ NodeList a;
            {
                this.a = nodeList;
            }

            @Override
            public final Iterator<Element> iterator() {
                return new NodeListElementIterator(this.a);
            }
        };
    }

    public static String selectText(Node node, String string) {
        return XMLUtils.selectText(node, string, null);
    }

    public static String selectText(Node node, String string, String string2) {
        try {
            node = XPathAPI.selectSingleNode((Node)node, (String)string);
            if (node != null) {
                return node.getTextContent();
            }
            return string2;
        }
        catch (Exception exception) {
            a.error((Object)exception.getMessage(), (Throwable)exception);
            return string2;
        }
    }

    @Deprecated
    public static Element findElement(Node node, String string) {
        Node node2;
        for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1 || !node2.getNodeName().equals(string)) continue;
            return (Element)node2;
        }
        for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1 || (node = XMLUtils.findElement(node2, string)) == null) continue;
            return node;
        }
        return null;
    }

    public static String getAttribute(Element element, String string) {
        return XMLUtils.getAttribute(element, string, null);
    }

    public static String getAttribute(Element element, String string, String string2) {
        if (element != null && element.hasAttribute(string)) {
            return element.getAttribute(string);
        }
        return string2;
    }

    @Deprecated
    public static int getIntAttribute(Element element, String string, int n) {
        if (element.hasAttribute(string)) {
            return Utils.parseInt(element.getAttribute(string), n);
        }
        return n;
    }

    public static <E extends Enum<E>> E getEnumAttribute(Element element, String string, E e) {
        Object object = e;
        try {
            object = Enum.valueOf(e.getClass(), element.getAttribute(string));
        }
        catch (Exception exception) {}
        return object;
    }

    public static int getAttributeIntValue(Node node, String string, int n) {
        try {
            n = Integer.parseInt(XMLUtils.getAttribute((Element)node, string, null));
        }
        catch (Exception exception) {}
        return n;
    }

    @Deprecated
    public static Map<String, String> attributesToMap(Element element) {
        return XMLUtils.b(element, true);
    }

    private static Map<String, String> b(Element object, boolean bl) {
        object = object.getAttributes();
        int n = object.getLength();
        HashMap<String, String> hashMap = new HashMap<String, String>(n);
        for (int i = 0; i < n; ++i) {
            Node node = object.item(i);
            String string = node.getNodeValue();
            if (bl) {
                hashMap.put(node.getNodeName(), node.getNodeValue());
                continue;
            }
            if (string == null || string.length() <= 0) continue;
            hashMap.put(node.getNodeName(), node.getNodeValue());
        }
        return hashMap;
    }

    public static ParameterMap attributesToParameterMap(Element element) {
        return new a(element);
    }

    public static void serialize(Node node, OutputStream outputStream, String string) {
        XMLUtils.serialize(node, new StreamResult(outputStream), string);
    }

    public static void serialize(Node node, Writer writer) {
        XMLUtils.serialize(node, new StreamResult(writer), null);
    }

    public static void serialize(Node node, Writer writer, String string) {
        XMLUtils.serialize(node, new StreamResult(writer), string);
    }

    public static void serialize(Node node, Result result, String string) {
        XMLUtils.serialize(node, result, string, false);
    }

    public static void serialize(Node node, Result result, String string, boolean bl) {
        try {
            Object object = TransformerFactory.newInstance();
            object = ((TransformerFactory)object).newTransformer();
            if (bl) {
                ((Transformer)object).setOutputProperty("indent", "yes");
                ((Transformer)object).setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            }
            if (string != null) {
                ((Transformer)object).setOutputProperty("encoding", string);
            }
            ((Transformer)object).transform(new DOMSource(node), result);
            return;
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            a.error((Object)"Could not locate a factory class", (Throwable)factoryConfigurationError);
            return;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            a.error((Object)"TransformerConfigurationException", (Throwable)transformerConfigurationException);
            return;
        }
        catch (TransformerException transformerException) {
            a.error((Object)"TransformerException", (Throwable)transformerException);
            return;
        }
    }

    public static void prepareElementToSerialize(Node node) {
        Object object;
        int n;
        StringBuilder stringBuilder = new StringBuilder(100);
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = namedNodeMap.item(i);
                object = node2.getNodeValue();
                node2.setNodeValue(XMLUtils.prepareString(stringBuilder, (String)object));
            }
        }
        if (node.getNodeValue() != null) {
            node.setNodeValue(XMLUtils.prepareString(stringBuilder, node.getNodeValue()));
        }
        NodeList nodeList = node.getChildNodes();
        n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            object = nodeList.item(i);
            XMLUtils.prepareElementToSerialize((Node)object);
        }
    }

    public static String prepareString(StringBuilder stringBuilder, String string) {
        stringBuilder.setLength(0);
        for (int i = 0; i < string.length(); ++i) {
            char c;
            char c2 = c = string.charAt(i);
            if (c == '\t' || c2 == '\n' || c2 == '\r' || c2 >= ' ' && c2 <= '\ud7ff' || c2 >= '\ue000' && c2 <= '\ufffd' || c2 >= '\u10000' && c2 <= '\u10ffff') {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append("\\u");
            stringBuilder.append((int)c2);
        }
        return stringBuilder.toString();
    }

    public static void transform(Source source, Source object, Result result, String string) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        object = transformerFactory.newTransformer((Source)object);
        ((Transformer)object).transform(source, result);
        if (string != null) {
            ((Transformer)object).setOutputProperty("encoding", string);
        }
        ((Transformer)object).setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
    }

    public static List<Element> toList(Iterable<Element> object) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        object = object.iterator();
        while (object.hasNext()) {
            Element element = (Element)object.next();
            arrayList.add(element);
        }
        return arrayList;
    }

    public static String escapeXmlNotValid(StringBuilder stringBuilder, String string) {
        boolean bl = false;
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(string.length() + 10);
        } else {
            stringBuilder.setLength(0);
        }
        for (int i = 0; i < string.length(); ++i) {
            char c;
            char c2 = c = string.charAt(i);
            if (c >= ' ' && c2 <= '\ud7ff' || c2 == '\t' || c2 == '\n' || c2 == '\r' || c2 >= '\ue000' && c2 <= '\ufffd' || c2 >= '\u10000' && c2 <= '\u10ffff') {
                if (!bl) continue;
                stringBuilder.append(c);
                continue;
            }
            if (!bl) {
                bl = true;
                stringBuilder.append(string, 0, i);
            }
            stringBuilder.append("\\u");
            stringBuilder.append((int)c2);
        }
        if (!bl) {
            return string;
        }
        return stringBuilder.toString();
    }

    private static final class a
    extends ParameterMap {
        private Element a;
        private Map<String, String> b = null;

        public a(Element element) {
            assert (element != null);
            this.a = element;
        }

        @Override
        public final String get(String string, String string2) {
            if (this.b != null) {
                if ((string = this.b.get(string)) != null) {
                    return string;
                }
                return string2;
            }
            assert (this.a != null);
            if ((string = this.a.getAttribute(string)) == null || string.length() == 0) {
                return string2;
            }
            return string;
        }

        @Override
        public final Set<Map.Entry<String, String>> entrySet() {
            if (this.b != null) {
                return this.b.entrySet();
            }
            this.b = XMLUtils.b(this.a, false);
            this.a = null;
            return this.b.entrySet();
        }
    }

    public static class XMLEventReaderParameterMap
    extends ParameterMap.DefaultParameterMap {
        public XMLEventReaderParameterMap() {
            super(new HashMap<String, String>());
        }

        public void read(StartElement object) {
            this.data.clear();
            object = object.getAttributes();
            while (object.hasNext()) {
                Attribute attribute = (Attribute)object.next();
                this.data.put(attribute.getName().getLocalPart(), attribute.getValue());
            }
        }
    }

    public static class XMLStreamReaderParameterMap
    extends ParameterMap.DefaultParameterMap {
        public XMLStreamReaderParameterMap() {
            super(new HashMap<String, String>());
        }

        public void read(XMLStreamReader xMLStreamReader) {
            this.data.clear();
            int n = xMLStreamReader.getAttributeCount();
            for (int i = 0; i < n; ++i) {
                this.data.put(xMLStreamReader.getAttributeLocalName(i), xMLStreamReader.getAttributeValue(i));
            }
        }
    }

    public static interface BGXMLEventReader
    extends XMLEventReader {
        public int getCurrentDepth();

        @Deprecated
        public Iterable<StartElement> newStartElementIterator(String var1);

        public Iterable<StartElement> iterable(String var1);

        public String getAttributeValue(StartElement var1, String var2);

        public Map<String, String> getAttributes(StartElement var1);
    }
}

