/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.frk.driver.atol;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import jssc.SerialPortList;
import org.apache.log4j.Logger;
import ru.bitel.frk.driver.ICashCheckDriver;
import ru.bitel.frk.driver.atol.AtolPrinter;
import ru.bitel.frk.driver.atol.AtolPrinterType;
import ru.bitel.frk.driver.atol.PrinterAtolErrorException;
import ru.bitel.frk.driver.atol.PrinterStatus;
import ru.bitel.frk.server.DriverException;
import ru.bitel.frk.server.FrkException;
import ru.bitel.frk.server.NotImplementedException;
import ru.bitel.frk.server.PrinterConnectException;
import ru.bitel.frk.server.PrinterErrorException;
import ru.bitel.frk.utils.BGByteBuffer;
import ru.bitel.frk.utils.CheckLine;
import ru.bitel.frk.utils.FrkUtils;
import ru.bitel.frk.utils.SerialParameters;

public class Driver
implements ICashCheckDriver {
    private SerialParameters a = new SerialParameters();
    private static final Logger b = Logger.getLogger(Driver.class);
    private AtolPrinterType c = AtolPrinterType.UNKNOWN;
    private int d = 0;
    private boolean e = false;
    private boolean f = false;

    @Override
    public void setConfig(Map<String, String> map) throws Exception {
        this.a.setFlowControlIn(0);
        this.a.setFlowControlOut(0);
        this.a.setDatabits(8);
        this.a.setStopbits(1);
        this.a.setParity(0);
        if (map.containsKey("portName")) {
            this.a.setPortName(map.get("portName"));
        }
        if (map.containsKey("baudRate")) {
            this.a.setBaudRate(map.get("baudRate"));
        }
        if (map.containsKey("type")) {
            try {
                this.c = AtolPrinterType.valueOf(map.get("type"));
            }
            catch (Exception exception) {
                throw new Exception("parameter 'type' error (" + map.get("type") + ")");
            }
        } else {
            throw new Exception("parameter 'type' must be specified");
        }
        if (map.containsKey("accessPassword")) {
            this.d = FrkUtils.parseInt(map.get("accessPassword"));
        }
        this.e = FrkUtils.parseBoolean(map.get("cutterDisabled"), this.e);
        this.f = FrkUtils.parseBoolean(map.get("cutterForceManual"), this.f);
    }

    @Override
    public synchronized void touchDriver() throws Exception {
        Object object;
        StringBuilder charSequence2 = new StringBuilder();
        String[] stringArray = SerialPortList.getPortNames();
        charSequence2.append("available serial ports:\n");
        Object[] objectArray = stringArray;
        int nArray = stringArray.length;
        for (int nArray2 = 0; nArray2 < nArray; ++nArray2) {
            object = objectArray[nArray2];
            charSequence2.append((String)object).append("\n");
        }
        if (stringArray.length <= 0) {
            charSequence2.append("not available com ports!\n");
        }
        b.debug((Object)charSequence2.toString());
        objectArray = new int[]{1200, 2400, 4800, 9600, 14400, 38400, 57600, 115200};
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        object = new int[]{8};
        int[] nArray4 = new int[]{1};
        int[] nArray5 = new int[]{0};
        SerialParameters serialParameters = new SerialParameters();
        AtolPrinter atolPrinter = new AtolPrinter(serialParameters, AtolPrinterType.UNKNOWN, 0L, 0L, b);
        for (String string : stringArray) {
            serialParameters.setPortName(string);
            Object[] objectArray2 = objectArray;
            for (int i = 0; i < 8; ++i) {
                String object2 = objectArray2[i];
                serialParameters.setBaudRate((int)object2);
                int[] nArray6 = nArray2;
                for (int j = 0; j <= 0; ++j) {
                    Object n2 = nArray6[j];
                    serialParameters.setFlowControlIn((int)n2);
                    int[] nArray7 = nArray3;
                    for (int k = 0; k <= 0; ++k) {
                        n2 = nArray7[k];
                        serialParameters.setFlowControlOut((int)n2);
                        Object object3 = object;
                        for (int i2 = 0; i2 <= 0; ++i2) {
                            n2 = object3[i2];
                            serialParameters.setDatabits((int)n2);
                            int[] nArray8 = nArray4;
                            for (int i3 = 0; i3 <= 0; ++i3) {
                                n2 = nArray8[i3];
                                serialParameters.setStopbits((int)n2);
                                int[] nArray9 = nArray5;
                                for (int i4 = 0; i4 <= 0; ++i4) {
                                    String throwable;
                                    int stringBuilder = nArray9[i4];
                                    serialParameters.setParity(stringBuilder);
                                    StringBuilder stringBuilder2 = new StringBuilder();
                                    stringBuilder2.append(serialParameters.getPortName()).append(",BR:").append(serialParameters.getBaudRateString()).append(",DB:").append(serialParameters.getDatabitsString()).append(",SB:").append(serialParameters.getStopbitsString()).append(",P:").append(serialParameters.getParityString());
                                    try {
                                        atolPrinter.open();
                                        throwable = atolPrinter.touch();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable = "device touch error: " + throwable2.toString();
                                    }
                                    finally {
                                        atolPrinter.close();
                                    }
                                    stringBuilder2.append(" -> ").append(throwable).append("\n");
                                    b.debug((Object)stringBuilder2.toString());
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void shutdown() {
    }

    @Override
    public String getStatus() {
        return "portName=" + this.a.getPortName() + ", baudRate=" + this.a.getBaudRate() + ", printerType=" + (Object)((Object)this.c);
    }

    @Override
    public synchronized void buzzer(String string) throws PrinterAtolErrorException, PrinterConnectException, DriverException {
        int n = FrkUtils.parseInt(string);
        try (AtolPrinter atolPrinter = new AtolPrinter(this.a, this.c, this.d, n, b);){
            atolPrinter.open();
            atolPrinter.buzzer();
            return;
        }
    }

    @Override
    public synchronized String name(String string) throws PrinterConnectException, PrinterErrorException, DriverException {
        String string2;
        int n = FrkUtils.parseInt(string);
        try (AtolPrinter atolPrinter = new AtolPrinter(this.a, this.c, this.d, n, b);){
            atolPrinter.open();
            string2 = atolPrinter.getName();
        }
        return string2;
    }

    @Override
    public synchronized String status(String string) throws PrinterConnectException, PrinterErrorException, DriverException {
        Object object;
        int n = FrkUtils.parseInt(string);
        try (AtolPrinter atolPrinter = new AtolPrinter(this.a, this.c, this.d, n, b);){
            atolPrinter.open();
            object = atolPrinter.getStatus();
            PrinterStatus printerStatus = object;
            object = this;
            StringBuffer stringBuffer = new StringBuffer(1024);
            stringBuffer.append("\u041a\u0430\u0441\u0441\u0438\u0440: ").append(printerStatus.a);
            stringBuffer.append("\n\u041d\u043e\u043c\u0435\u0440 \u0432 \u0437\u0430\u043b\u0435: ").append(printerStatus.b);
            stringBuffer.append("\n\u041f\u043e\u043a\u0430\u0437\u0430\u043d\u0438\u044f \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0438\u0445 \u0447\u0430\u0441\u043e\u0432 \u041a\u041a\u041c: ").append(printerStatus.datetime);
            stringBuffer.append("\n\u041a\u041a\u041c \u0444\u0438\u0441\u043a\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d\u0430: ").append(printerStatus.isFiscal ? "\u0434\u0430" : "\u043d\u0435\u0442");
            stringBuffer.append("\n\u0421\u043c\u0435\u043d\u0430 \u043e\u0442\u043a\u0440\u044b\u0442\u0430: ").append(printerStatus.isDayOpen ? "\u0434\u0430" : "\u043d\u0435\u0442");
            stringBuffer.append("\n\u0414\u0435\u043d\u0435\u0436\u043d\u044b\u0439 \u044f\u0449\u0438\u043a \u043e\u0442\u043a\u0440\u044b\u0442: ").append(printerStatus.isCashBoxNotOpen ? "\u043d\u0435\u0442" : "\u0434\u0430");
            stringBuffer.append("\n\u0412\u0435\u0441\u043e\u0432\u043e\u0439 \u0434\u0430\u0442\u0447\u0438\u043a \u0427\u041b: ").append(printerStatus.isWeightPaperHave ? "\u0435\u0441\u0442\u044c \u0431\u0443\u043c\u0430\u0433\u0430" : "\u043d\u0435\u0442 \u0431\u0443\u043c\u0430\u0433\u0438");
            if (!((Driver)object).c.isSensorPaperWeight()) {
                stringBuffer.append(" (\u043c\u043e\u0434\u0435\u043b\u044c \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0434\u0430\u0442\u0447\u0438\u043a\u0430)");
            }
            stringBuffer.append("\n\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u0434\u0430\u0442\u0447\u0438\u043a\u0430 \u043a\u0440\u044b\u0448\u043a\u0438: \u043a\u0440\u044b\u0448\u043a\u0430 ").append(printerStatus.isCoverOpen ? "\u043e\u0442\u043a\u0440\u044b\u0442\u0430" : "\u0437\u0430\u043a\u0440\u044b\u0442\u0430");
            if (!((Driver)object).c.isSensorCover()) {
                stringBuffer.append(" (\u043c\u043e\u0434\u0435\u043b\u044c \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0434\u0430\u0442\u0447\u0438\u043a\u0430)");
            }
            stringBuffer.append("\n\u041d\u0430\u043f\u0440\u044f\u0436\u0435\u043d\u0438\u0435 \u0431\u0430\u0442\u0430\u0440\u0435\u0439\u043a\u0438: ").append(printerStatus.isBatteriesLow ? "\u041d\u0418\u0417\u041a\u041e" : "\u043d\u043e\u0440\u043c\u0430\u043b\u044c\u043d\u043e");
            if (!((Driver)object).c.isSensorBatteries()) {
                stringBuffer.append(" (\u043c\u043e\u0434\u0435\u043b\u044c \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0434\u0430\u0442\u0447\u0438\u043a\u0430)");
            }
            stringBuffer.append("\n\u0417\u0430\u0432\u043e\u0434\u0441\u043a\u043e\u0439 \u043d\u043e\u043c\u0435\u0440: ").append(printerStatus.serial);
            stringBuffer.append("\n\u041c\u043e\u0434\u0435\u043b\u044c: ").append(printerStatus.modelName);
            stringBuffer.append("\n\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 (\u0440\u0435\u0436\u0438\u043c): ").append(printerStatus.mode.toString());
            stringBuffer.append("\n\u041d\u043e\u043c\u0435\u0440 \u0447\u0435\u043a\u0430 (\u043d\u043e\u043c\u0435\u0440 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e+1): ").append(printerStatus.checkNumber);
            stringBuffer.append("\n\u041d\u043e\u043c\u0435\u0440 \u0441\u043c\u0435\u043d\u044b (\u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u0437\u0430\u043a\u0440\u044b\u0442\u043e\u0439): ").append(printerStatus.dayNumber);
            stringBuffer.append("\n\u0421\u0443\u043c\u043c\u0430 \u0447\u0435\u043a\u0430: ").append(FrkUtils.formatMDE(printerStatus.checkSum));
            stringBuffer.append("\n\u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u0434\u0435\u0441\u044f\u0442\u0438\u0447\u043d\u043e\u0439 \u0442\u043e\u0447\u043a\u0438: ").append(printerStatus.decimalDot);
            stringBuffer.append("\n\u041d\u043e\u043c\u0435\u0440 \u043f\u043e\u0440\u0442\u0430 \u041a\u041a\u041c: ").append(printerStatus.port);
            stringBuffer.append("\n\u0421\u0443\u043c\u043c\u0430 \u043d\u0430\u043b\u0438\u0447\u043d\u044b\u0445: ").append(FrkUtils.formatMDE(printerStatus.c));
            stringBuffer.append("\n\u0421\u0443\u043c\u043c\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e \u0441\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u0438\u0442\u043e\u0433\u0430 \u043f\u0440\u043e\u0434\u0430\u0436: ").append(FrkUtils.formatMDE(printerStatus.d));
            object = stringBuffer.toString();
        }
        return object;
    }

    @Override
    public synchronized String check(String ... object) throws PrinterConnectException, PrinterAtolErrorException, DriverException {
        Exception exception;
        AtolPrinter atolPrinter;
        BigDecimal bigDecimal;
        block16: {
            int n = FrkUtils.parseInt(object[0]);
            Object object2 = FrkUtils.processCommandCheckClientsumma(object[1]);
            bigDecimal = ((FrkUtils.CommandCheckClientsumma)object2).summa;
            object2 = ((FrkUtils.CommandCheckClientsumma)object2).typ;
            BigDecimal bigDecimal2 = new BigDecimal(100);
            b.debug((Object)("Driver: check(clientsumma=" + bigDecimal + "):"));
            Object object3 = new ArrayList<CheckLine>();
            object = FrkUtils.processCommandCheckParameters((String[])object, object3, b);
            object = ((FrkUtils.CommandCheckParameters)object).totalPositionSumma;
            if (bigDecimal.compareTo((BigDecimal)object) < 0) {
                throw new PrinterAtolErrorException("\u0414\u0435\u043d\u0435\u0433 \u0432\u043d\u0435\u0441\u0435\u043d\u043e (" + bigDecimal.toPlainString() + ") \u043c\u0435\u043d\u044c\u0448\u0435 \u0441\u0443\u043c\u043c\u044b \u0447\u0435\u043a\u0430 (" + ((BigDecimal)object).toPlainString() + ")");
            }
            atolPrinter = new AtolPrinter(this.a, this.c, this.d, n, b);
            exception = null;
            try {
                atolPrinter.open();
                atolPrinter.openCheck();
                object3 = object3.iterator();
                while (object3.hasNext()) {
                    CheckLine checkLine = (CheckLine)object3.next();
                    if (checkLine.getSumma() == null) {
                        atolPrinter.a(checkLine.getText());
                        continue;
                    }
                    atolPrinter.sale(checkLine.getSumma().multiply(bigDecimal2).longValue(), 1000L, checkLine.getDivision(), checkLine.getText());
                }
                atolPrinter.closeCheck(bigDecimal.multiply(bigDecimal2).longValue(), object2 != null ? (Integer)object2 : 1);
                if (!this.f) break block16;
                atolPrinter.cut();
            }
            catch (Exception exception2) {
                object3 = exception2;
                exception = exception2;
                if (atolPrinter.testOnOpenCheckAndNulled()) {
                    exception = new PrinterAtolErrorException("\u0427\u0435\u043a \u0431\u044b\u043b \u0430\u043d\u043d\u0443\u043b\u0438\u0440\u043e\u0432\u0430\u043d \u0432\u0432\u0438\u0434\u0443 \u043e\u0448\u0438\u0431\u043a\u0438: " + exception.toString());
                }
                atolPrinter.close();
                if (exception instanceof PrinterConnectException) {
                    throw (PrinterConnectException)exception;
                }
                if (exception instanceof PrinterAtolErrorException) {
                    throw (PrinterAtolErrorException)exception;
                }
                throw new PrinterAtolErrorException(exception.toString());
            }
            catch (Throwable throwable) {
                if (atolPrinter.testOnOpenCheckAndNulled()) {
                    exception = new PrinterAtolErrorException("\u041f\u043e\u0441\u043b\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u0447\u0435\u043a \u043e\u0441\u0442\u0430\u043b\u0441\u044f \u043e\u0442\u043a\u0440\u044b\u0442. \u0427\u0435\u043a \u0431\u044b\u043b \u0430\u043d\u043d\u0443\u043b\u0438\u0440\u043e\u0432\u0430\u043d.");
                }
                atolPrinter.close();
                if (exception != null) {
                    if (exception instanceof PrinterConnectException) {
                        throw (PrinterConnectException)exception;
                    }
                    if (exception instanceof PrinterAtolErrorException) {
                        throw (PrinterAtolErrorException)exception;
                    }
                    throw new PrinterAtolErrorException(exception.toString());
                }
                throw throwable;
            }
        }
        if (atolPrinter.testOnOpenCheckAndNulled()) {
            exception = new PrinterAtolErrorException("\u041f\u043e\u0441\u043b\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u0447\u0435\u043a \u043e\u0441\u0442\u0430\u043b\u0441\u044f \u043e\u0442\u043a\u0440\u044b\u0442. \u0427\u0435\u043a \u0431\u044b\u043b \u0430\u043d\u043d\u0443\u043b\u0438\u0440\u043e\u0432\u0430\u043d.");
        }
        atolPrinter.close();
        if (exception != null) {
            if (exception instanceof PrinterConnectException) {
                throw (PrinterConnectException)exception;
            }
            throw (PrinterAtolErrorException)exception;
        }
        return bigDecimal.subtract((BigDecimal)object).toPlainString();
    }

    @Override
    public synchronized void xreport(String string) throws PrinterConnectException, PrinterErrorException, DriverException {
        int n = FrkUtils.parseInt(string);
        try (AtolPrinter atolPrinter = new AtolPrinter(this.a, this.c, this.d, n, b);){
            atolPrinter.open();
            atolPrinter.xreport(1);
            if (this.f) {
                atolPrinter.cut();
            }
            return;
        }
    }

    @Override
    public synchronized void divreport(String string) throws PrinterConnectException, PrinterErrorException, DriverException {
        int n = FrkUtils.parseInt(string);
        try (AtolPrinter atolPrinter = new AtolPrinter(this.a, this.c, this.d, n, b);){
            atolPrinter.open();
            atolPrinter.xreport(2);
            if (this.f) {
                atolPrinter.cut();
            }
            return;
        }
    }

    @Override
    public synchronized void zreport(String string) throws PrinterConnectException, PrinterErrorException, DriverException {
        int n = FrkUtils.parseInt(string);
        try (AtolPrinter atolPrinter = new AtolPrinter(this.a, this.c, this.d, n, b);){
            atolPrinter.open();
            atolPrinter.zreport();
            if (this.f) {
                atolPrinter.cut();
            }
            return;
        }
    }

    @Override
    public synchronized void printtext(String ... stringArray) throws PrinterErrorException, PrinterConnectException, DriverException {
        int n = FrkUtils.parseInt(stringArray[0]);
        try (AtolPrinter atolPrinter = new AtolPrinter(this.a, this.c, this.d, n, b);){
            atolPrinter.open();
            for (int i = 1; i < stringArray.length; ++i) {
                if ("!CUT%)".equals(stringArray[i]) && !this.e) {
                    atolPrinter.cut();
                    continue;
                }
                atolPrinter.a(stringArray[i]);
            }
            return;
        }
    }

    @Override
    public synchronized String purecommand(String string, String object) throws PrinterConnectException, PrinterErrorException, DriverException {
        int n = FrkUtils.parseInt(string);
        String string2 = "?";
        try (AtolPrinter atolPrinter = new AtolPrinter(this.a, this.c, this.d, n, b);){
            atolPrinter.open();
            object = atolPrinter.pureCmd((String)object);
            if (object != null) {
                string2 = ((BGByteBuffer)object).toString();
            }
        }
        return string2;
    }

    @Override
    public synchronized void repeatcheck(String string) throws NotImplementedException {
        throw new NotImplementedException();
    }

    @Override
    public synchronized String checkreturn(String ... stringArray) throws NotImplementedException {
        throw new NotImplementedException();
    }

    @Override
    public synchronized String returnscheck(String string, String object, String string2, String string3) throws PrinterConnectException, PrinterAtolErrorException, DriverException {
        int n = FrkUtils.parseInt(string);
        object = new BigDecimal(string2);
        try (AtolPrinter atolPrinter = new AtolPrinter(this.a, this.c, this.d, n, b);){
            atolPrinter.open();
            atolPrinter.openCheck();
            atolPrinter.saleBack(((BigDecimal)object).multiply(new BigDecimal(100)).longValue(), 1000L, string3);
            atolPrinter.closeCheck(0L, 1);
            if (this.f) {
                atolPrinter.cut();
            }
        }
        return "(\u0441\u0443\u043c\u043c\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430: " + string2 + ")";
    }

    @Override
    public synchronized String closecheck_fix(String string, String string2) throws NotImplementedException {
        throw new NotImplementedException();
    }

    @Override
    public synchronized void continueprint(String string) throws NotImplementedException {
        throw new NotImplementedException();
    }

    @Override
    public synchronized void cancelcheck(String string) throws FrkException {
        throw new NotImplementedException();
    }

    @Override
    public void openday(String string) throws FrkException {
        int n = FrkUtils.parseInt(string);
        try (AtolPrinter atolPrinter = new AtolPrinter(this.a, this.c, this.d, n, b);){
            atolPrinter.open();
            atolPrinter.openDay("\u041e\u0442\u043a\u0440\u044b\u0442\u0438\u0435 \u0441\u043c\u0435\u043d\u044b");
            return;
        }
    }
}

