/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.frk.driver.shtrih2;

import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import jssc.SerialPortList;
import org.apache.log4j.Logger;
import ru.bitel.frk.driver.ICashCheckDriver;
import ru.bitel.frk.driver.shtrih2.PrinterShtrihErrorException;
import ru.bitel.frk.driver.shtrih2.PrinterStatus;
import ru.bitel.frk.driver.shtrih2.ShtrihFRKPrinter;
import ru.bitel.frk.server.DriverException;
import ru.bitel.frk.server.NotImplementedException;
import ru.bitel.frk.server.PrinterConnectException;
import ru.bitel.frk.utils.BGByteBuffer;
import ru.bitel.frk.utils.CheckLine;
import ru.bitel.frk.utils.FrkUtils;
import ru.bitel.frk.utils.SerialParameters;

public class Driver
implements ICashCheckDriver {
    private SerialParameters a = new SerialParameters();
    private int b = 100;
    private static final Logger c = Logger.getLogger(Driver.class);
    private int d = 1000;
    private int e = 20;
    private boolean f = false;
    private boolean g = false;
    private boolean h = false;
    private int i = -1;
    public final Charset OFD_TAG_ENCODING__LOCAL = Charset.forName("cp866");

    @Override
    public void setConfig(Map<String, String> map) {
        if (map.containsKey("portName")) {
            this.a.setPortName(map.get("portName"));
        }
        if (map.containsKey("baudRate")) {
            this.a.setBaudRate(map.get("baudRate"));
        }
        if (map.containsKey("flowControlIn")) {
            this.a.setFlowControlIn(map.get("flowControlIn"));
        }
        if (map.containsKey("flowControlOut")) {
            this.a.setFlowControlOut(map.get("flowControlOut"));
        }
        if (map.containsKey("databits")) {
            this.a.setDatabits(map.get("databits"));
        }
        if (map.containsKey("stopbits")) {
            this.a.setStopbits(map.get("stopbits"));
        }
        if (map.containsKey("parity")) {
            this.a.setParity(map.get("parity"));
        }
        this.b = FrkUtils.parseInt(map.get("oneByteTimeout"), this.b);
        this.d = FrkUtils.parseInt(map.get("waitNoprintTimeout"), this.d);
        this.e = FrkUtils.parseInt(map.get("waitNoprintNumtry"), this.e);
        this.f = FrkUtils.parseBoolean(map.get("cutterDisabled"), this.f);
        this.g = FrkUtils.parseBoolean(map.get("cutterForceManual"), this.g);
        this.h = FrkUtils.parseBoolean(map.get("buzzerOnCheck"), this.h);
        this.i = FrkUtils.parseInt(map.get("sno"), this.i);
    }

    @Override
    public synchronized void touchDriver() {
        Object object;
        StringBuilder charSequence2 = new StringBuilder();
        String[] stringArray = SerialPortList.getPortNames();
        charSequence2.append("available serial ports:\n");
        Object[] objectArray = stringArray;
        int nArray = stringArray.length;
        for (int nArray2 = 0; nArray2 < nArray; ++nArray2) {
            object = objectArray[nArray2];
            charSequence2.append((String)object).append("\n");
        }
        if (stringArray.length <= 0) {
            charSequence2.append("not available com ports!\n");
        }
        c.debug((Object)charSequence2.toString());
        objectArray = new int[]{2400, 4800, 9600, 19200, 38400, 57600, 115200};
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        object = new int[]{8};
        int[] nArray4 = new int[]{1};
        int[] nArray5 = new int[]{0};
        SerialParameters serialParameters = new SerialParameters();
        ShtrihFRKPrinter shtrihFRKPrinter = new ShtrihFRKPrinter(serialParameters, this.b, 0L, c);
        for (String string : stringArray) {
            serialParameters.setPortName(string);
            Object[] objectArray2 = objectArray;
            for (int i = 0; i < 7; ++i) {
                String object2 = objectArray2[i];
                serialParameters.setBaudRate((int)object2);
                int[] nArray6 = nArray2;
                for (int j = 0; j <= 0; ++j) {
                    Object n2 = nArray6[j];
                    serialParameters.setFlowControlIn((int)n2);
                    int[] nArray7 = nArray3;
                    for (int k = 0; k <= 0; ++k) {
                        n2 = nArray7[k];
                        serialParameters.setFlowControlOut((int)n2);
                        Object object3 = object;
                        for (int i2 = 0; i2 <= 0; ++i2) {
                            n2 = object3[i2];
                            serialParameters.setDatabits((int)n2);
                            int[] nArray8 = nArray4;
                            for (int i3 = 0; i3 <= 0; ++i3) {
                                n2 = nArray8[i3];
                                serialParameters.setStopbits((int)n2);
                                int[] nArray9 = nArray5;
                                for (int i4 = 0; i4 <= 0; ++i4) {
                                    int stringBuilder = nArray9[i4];
                                    serialParameters.setParity(stringBuilder);
                                    StringBuilder stringBuilder2 = new StringBuilder();
                                    stringBuilder2.append(serialParameters.getPortName()).append(",BR:").append(serialParameters.getBaudRateString()).append(",DB:").append(serialParameters.getDatabitsString()).append(",SB:").append(serialParameters.getStopbitsString()).append(",P:").append(serialParameters.getParityString());
                                    String string2 = shtrihFRKPrinter._touch();
                                    stringBuilder2.append(" -> ").append(string2).append("\n");
                                    c.debug((Object)stringBuilder2.toString());
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public synchronized void buzzer(String string) throws PrinterShtrihErrorException, PrinterConnectException, DriverException {
        int n = FrkUtils.parseInt(string);
        try (ShtrihFRKPrinter shtrihFRKPrinter = new ShtrihFRKPrinter(this.a, this.b, n, c);){
            shtrihFRKPrinter.open();
            shtrihFRKPrinter.buzzer();
            return;
        }
    }

    @Override
    public synchronized void printtext(String ... stringArray) throws PrinterShtrihErrorException, PrinterConnectException, DriverException {
        int n = FrkUtils.parseInt(stringArray[0]);
        try (ShtrihFRKPrinter shtrihFRKPrinter = new ShtrihFRKPrinter(this.a, this.b, n, c);){
            shtrihFRKPrinter.open();
            shtrihFRKPrinter._waitToNoPrint(this.d, this.e);
            for (int i = 1; i < stringArray.length; ++i) {
                if ("!CUT%)".equals(stringArray[i]) && !this.f) {
                    shtrihFRKPrinter.a();
                    continue;
                }
                shtrihFRKPrinter.a(stringArray[i], false);
            }
            return;
        }
    }

    @Override
    public synchronized String name(String string) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        String string2;
        int n = FrkUtils.parseInt(string);
        try (ShtrihFRKPrinter shtrihFRKPrinter = new ShtrihFRKPrinter(this.a, this.b, n, c);){
            shtrihFRKPrinter.open();
            string2 = shtrihFRKPrinter.getName();
        }
        return string2;
    }

    @Override
    public synchronized String status(String string) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        int n = FrkUtils.parseInt(string);
        StringBuffer stringBuffer = new StringBuffer(1024);
        try (ShtrihFRKPrinter shtrihFRKPrinter = new ShtrihFRKPrinter(this.a, this.b, n, c);){
            shtrihFRKPrinter.open();
            PrinterStatus printerStatus = shtrihFRKPrinter.getStatusShort();
            stringBuffer.append("\u041f\u043e\u0440\u044f\u0434\u043a\u043e\u0432\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ");
            stringBuffer.append(printerStatus.operatorNum);
            stringBuffer.append("\n\u0420\u0443\u043b\u043e\u043d \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u043e\u0433\u043e \u0436\u0443\u0440\u043d\u0430\u043b\u0430: ");
            stringBuffer.append(printerStatus.rulonOpJournal != false ? "\u0435\u0441\u0442\u044c" : "\u043d\u0435\u0442");
            stringBuffer.append("\n\u0420\u0443\u043b\u043e\u043d \u0447\u0435\u043a\u043e\u0432\u043e\u0439 \u043b\u0435\u043d\u0442\u044b: ");
            stringBuffer.append(printerStatus.rulonVoucherTape != false ? "\u0435\u0441\u0442\u044c" : "\u043d\u0435\u0442");
            stringBuffer.append("\n\u042d\u041a\u041b\u0417: ");
            stringBuffer.append(printerStatus.haveEKLZ != false ? "\u0435\u0441\u0442\u044c" : "\u043d\u0435\u0442");
            stringBuffer.append("\n\u041e\u043f\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0434\u0430\u0442\u0447\u0438\u043a \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u043e\u0433\u043e \u0436\u0443\u0440\u043d\u0430\u043b\u0430: ");
            stringBuffer.append(printerStatus.paperOpJournal != false ? "\u0431\u0443\u043c\u0430\u0433\u0430 \u0435\u0441\u0442\u044c" : "\u0431\u0443\u043c\u0430\u0433\u0438 \u043d\u0435\u0442");
            stringBuffer.append("\n\u041e\u043f\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0434\u0430\u0442\u0447\u0438\u043a \u0447\u0435\u043a\u043e\u0432\u043e\u0439 \u043b\u0435\u043d\u0442\u044b: ");
            stringBuffer.append(printerStatus.paperVoucherTape != false ? "\u0431\u0443\u043c\u0430\u0433\u0430 \u0435\u0441\u0442\u044c" : "\u0431\u0443\u043c\u0430\u0433\u0438 \u043d\u0435\u0442");
            stringBuffer.append("\n\u0420\u044b\u0447\u0430\u0433 \u0442\u0435\u0440\u043c\u043e\u0433\u043e\u043b\u043e\u0432\u043a\u0438 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0439 \u043b\u0435\u043d\u0442\u044b: ");
            stringBuffer.append(printerStatus.leverPrintheadControlTape != false ? "\u043e\u043f\u0443\u0449\u0435\u043d" : "\u043f\u043e\u0434\u043d\u044f\u0442");
            stringBuffer.append("\n\u0420\u044b\u0447\u0430\u0433 \u0442\u0435\u0440\u043c\u043e\u0433\u043e\u043b\u043e\u0432\u043a\u0438 \u0447\u0435\u043a\u043e\u0432\u043e\u0439 \u043b\u0435\u043d\u0442\u044b: ");
            stringBuffer.append(printerStatus.leverPrintheadVoucherTape != false ? "\u043e\u043f\u0443\u0449\u0435\u043d" : "\u043f\u043e\u0434\u043d\u044f\u0442");
            stringBuffer.append("\n\u041a\u0440\u044b\u0448\u043a\u0430 \u043a\u043e\u0440\u043f\u0443\u0441\u0430 \u0424\u0420: ");
            stringBuffer.append(printerStatus.coverCorpsFR != false ? "\u043f\u043e\u0434\u043d\u044f\u0442\u0430" : "\u043e\u043f\u0443\u0449\u0435\u043d\u0430");
            stringBuffer.append("\n\u0414\u0435\u043d\u0435\u0436\u043d\u044b\u0439 \u044f\u0449\u0438\u043a: ");
            stringBuffer.append(printerStatus.moneyBox != false ? "\u043e\u0442\u043a\u0440\u044b\u0442" : "\u0437\u0430\u043a\u0440\u044b\u0442");
            stringBuffer.append("\n\u042d\u041a\u041b\u0417 \u043f\u043e\u0447\u0442\u0438 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0430: ");
            stringBuffer.append(printerStatus.filledEKLZ != false ? "\u0434\u0430" : "\u043d\u0435\u0442");
            stringBuffer.append("\n\u0420\u0435\u0436\u0438\u043c \u0424\u0420: ");
            stringBuffer.append("#" + printerStatus.modeNumString() + " : " + printerStatus.modeString());
            stringBuffer.append("\n\u041f\u043e\u0434\u0440\u0435\u0436\u0438\u043c \u0424\u0420: ");
            stringBuffer.append("#" + printerStatus.submode + " : " + printerStatus.submodeString());
            stringBuffer.append("\n\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0439 \u0432 \u0447\u0435\u043a\u0435: ");
            stringBuffer.append(printerStatus.operationCount);
            stringBuffer.append("\n\u041d\u0430\u043f\u0440\u044f\u0436\u0435\u043d\u0438\u0435 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e\u0439 \u0431\u0430\u0442\u0430\u0440\u0435\u0438: ");
            stringBuffer.append(printerStatus.voltageBackupBattery);
            stringBuffer.append("\n\u041d\u0430\u043f\u0440\u044f\u0436\u0435\u043d\u0438\u0435 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u043f\u0438\u0442\u0430\u043d\u0438\u044f: ");
            stringBuffer.append(printerStatus.voltagePowerSource);
            stringBuffer.append("\n\u041a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438 \u0424\u041f: ");
            stringBuffer.append(printerStatus.errorFP);
            stringBuffer.append("\n\u041a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438 \u042d\u041a\u041b\u0417: ");
            stringBuffer.append(printerStatus.errorEKLZ);
        }
        return stringBuffer.toString();
    }

    @Override
    public synchronized void xreport(String string) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        int n = FrkUtils.parseInt(string);
        try (ShtrihFRKPrinter shtrihFRKPrinter = new ShtrihFRKPrinter(this.a, this.b, n, c);){
            shtrihFRKPrinter.open();
            shtrihFRKPrinter._waitToNoPrint(this.d, this.e);
            shtrihFRKPrinter.xreport();
            if (this.g) {
                shtrihFRKPrinter.a();
            }
            return;
        }
    }

    @Override
    public synchronized void divreport(String string) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        int n = FrkUtils.parseInt(string);
        try (ShtrihFRKPrinter shtrihFRKPrinter = new ShtrihFRKPrinter(this.a, this.b, n, c);){
            shtrihFRKPrinter.open();
            shtrihFRKPrinter._waitToNoPrint(this.d, this.e);
            shtrihFRKPrinter.divreport();
            if (this.g) {
                shtrihFRKPrinter.a();
            }
            return;
        }
    }

    @Override
    public synchronized void zreport(String string) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        int n = FrkUtils.parseInt(string);
        try (ShtrihFRKPrinter shtrihFRKPrinter = new ShtrihFRKPrinter(this.a, this.b, n, c);){
            shtrihFRKPrinter.open();
            shtrihFRKPrinter._waitToNoPrint(this.d, this.e);
            shtrihFRKPrinter.zreport();
            if (this.g) {
                shtrihFRKPrinter.a();
            }
            return;
        }
    }

    public String _check(int n, String ... object) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        ShtrihFRKPrinter.CloseCheckReturn closeCheckReturn;
        Serializable serializable = new ArrayList<CheckLine>();
        FrkUtils.CommandCheckParameters commandCheckParameters = FrkUtils.processCommandCheckParameters((String[])object, serializable, c);
        int n2 = FrkUtils.parseInt((String)object[0]);
        object = FrkUtils.processCommandCheckClientsumma((String)object[1]);
        BigDecimal bigDecimal = n == 1 ? ((FrkUtils.CommandCheckClientsumma)object).summa : BigDecimal.ZERO;
        object = ((FrkUtils.CommandCheckClientsumma)object).typ;
        BigDecimal bigDecimal2 = new BigDecimal(100);
        c.debug((Object)("Driver: check/checkreturn(clientsumma=" + bigDecimal + ",type=" + n + "):"));
        Integer n3 = commandCheckParameters.tax;
        Integer n4 = commandCheckParameters.payMethod;
        Integer n5 = commandCheckParameters.payObject;
        if (n == 1 && bigDecimal.compareTo(commandCheckParameters.totalPositionSumma) < 0) {
            throw new PrinterShtrihErrorException("\u0414\u0435\u043d\u0435\u0433 \u0432\u043d\u0435\u0441\u0435\u043d\u043e (" + bigDecimal.toPlainString() + ") \u043c\u0435\u043d\u044c\u0448\u0435 \u0441\u0443\u043c\u043c\u044b \u0447\u0435\u043a\u0430 (" + commandCheckParameters.totalPositionSumma.toPlainString() + ")");
        }
        try (ShtrihFRKPrinter shtrihFRKPrinter = new ShtrihFRKPrinter(this.a, this.b, n2, c);){
            int n6;
            shtrihFRKPrinter.open();
            shtrihFRKPrinter._waitToNoPrint(this.d, this.e);
            if (n3 != null) {
                n3.intValue();
            }
            if (commandCheckParameters.onlyElCheck && (n6 = shtrihFRKPrinter.readTableByte(17, 1, 7)) == 0) {
                shtrihFRKPrinter.writeTableByte(17, 1, 7, 1);
            }
            for (CheckLine object2 : serializable) {
                int n7;
                if (object2.getSumma() == null) {
                    shtrihFRKPrinter.a(object2.getText(), true);
                    continue;
                }
                serializable = object2.payMethod != null ? object2.payMethod : n4;
                Integer n8 = object2.payObject != null ? object2.payObject : n5;
                Integer n9 = n3;
                long l = object2.getSumma().multiply(bigDecimal2).longValue();
                int n10 = object2.getDivision();
                String string = object2.getText();
                if (n9 == null) {
                    n7 = 0;
                } else {
                    n9.intValue();
                    n7 = n9;
                }
                shtrihFRKPrinter.saleV2(n, 1000000L, l, n10, string, n7, serializable != null ? (Integer)serializable : 0, n8 != null ? n8 : 0);
                if (n != 2) continue;
                bigDecimal = bigDecimal.add(object2.getSumma());
            }
            if (commandCheckParameters.customerEmail != null) {
                shtrihFRKPrinter.sendTLV(1008, commandCheckParameters.customerEmail.getBytes(this.OFD_TAG_ENCODING__LOCAL));
            }
            if (commandCheckParameters.cashierName != null) {
                shtrihFRKPrinter.sendTLV(1021, commandCheckParameters.cashierName.getBytes(this.OFD_TAG_ENCODING__LOCAL));
            }
            if (commandCheckParameters.cashierINN != null) {
                shtrihFRKPrinter.sendTLV(1203, commandCheckParameters.cashierINN.getBytes(this.OFD_TAG_ENCODING__LOCAL));
            }
            for (Map.Entry entry : commandCheckParameters.customTags.entrySet()) {
                serializable = entry.getValue();
                if (serializable instanceof byte[]) {
                    shtrihFRKPrinter.sendTLV((Integer)entry.getKey(), (byte[])serializable);
                    continue;
                }
                if (serializable instanceof Long) {
                    shtrihFRKPrinter.sendTLV((Integer)entry.getKey(), new byte[]{((Long)serializable).byteValue()});
                    continue;
                }
                if (!(serializable instanceof String)) continue;
                shtrihFRKPrinter.sendTLV((Integer)entry.getKey(), ((String)((Object)serializable)).getBytes(Charset.forName("cp866")));
            }
            long l = bigDecimal.multiply(bigDecimal2).longValue();
            int n11 = object == null || (Integer)object == 1 ? 1 : ((Integer)object == 2 ? 2 : (Integer)object);
            if (n11 <= 0 || n11 > 16) {
                throw new DriverException("payment type must be 1..16");
            }
            if (this.i < 0 || this.i > 5) {
                throw new DriverException("sno must be 0..5");
            }
            closeCheckReturn = shtrihFRKPrinter.closeCheckExV2(l, n11, "", this.i);
            if (this.h) {
                shtrihFRKPrinter.buzzer();
            }
            if (this.g) {
                shtrihFRKPrinter.a();
            }
        }
        return String.valueOf(closeCheckReturn.a / 100L) + "." + String.valueOf(closeCheckReturn.a % 100L);
    }

    @Override
    public synchronized String check(String ... stringArray) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        return this._check(1, stringArray);
    }

    @Override
    public synchronized String checkreturn(String ... stringArray) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        return this._check(2, stringArray);
    }

    @Override
    public synchronized String returnscheck(String string, String string2, String string3, String string4) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        throw new NotImplementedException();
    }

    @Override
    public synchronized String closecheck_fix(String string, String object) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        long l;
        int n = FrkUtils.parseInt(string);
        ShtrihFRKPrinter shtrihFRKPrinter = new ShtrihFRKPrinter(this.a, this.b, n, c);
        object = FrkUtils.parseBigDecimal((String)object);
        long l2 = ((BigDecimal)object).multiply(new BigDecimal(100)).longValue();
        try {
            shtrihFRKPrinter.open();
            shtrihFRKPrinter._waitToNoPrint(this.d, this.e);
            l = shtrihFRKPrinter.closeCheck(l2, 0L, 0L, 0L, 0, "\u044d\u043a\u0441\u0442\u0440\u0435\u043d\u043d\u043e\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u0447\u0435\u043a\u0430", 0, 0, 0, 0);
            if (this.h) {
                shtrihFRKPrinter.buzzer();
            }
            if (this.g) {
                shtrihFRKPrinter.a();
            }
        }
        finally {
            shtrihFRKPrinter.close();
        }
        return String.valueOf(l / 100L) + "." + String.valueOf(l % 100L);
    }

    @Override
    public synchronized void continueprint(String string) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        int n = FrkUtils.parseInt(string);
        try (ShtrihFRKPrinter shtrihFRKPrinter = new ShtrihFRKPrinter(this.a, this.b, n, c);){
            shtrihFRKPrinter.open();
            shtrihFRKPrinter._waitToNoPrint(this.d, this.e);
            shtrihFRKPrinter.continuePrint();
            if (this.g) {
                shtrihFRKPrinter.a();
            }
            return;
        }
    }

    @Override
    public synchronized String purecommand(String string, String object) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        int n = FrkUtils.parseInt(string);
        String string2 = "?";
        try (ShtrihFRKPrinter shtrihFRKPrinter = new ShtrihFRKPrinter(this.a, this.b, n, c);){
            shtrihFRKPrinter.open();
            object = shtrihFRKPrinter.pureCmd((String)object);
            if (object != null) {
                string2 = ((BGByteBuffer)object).toString();
            }
        }
        return string2;
    }

    @Override
    public synchronized void repeatcheck(String string) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        int n = FrkUtils.parseInt(string);
        try (ShtrihFRKPrinter shtrihFRKPrinter = new ShtrihFRKPrinter(this.a, this.b, n, c);){
            shtrihFRKPrinter.open();
            shtrihFRKPrinter._waitToNoPrint(this.d, this.e);
            shtrihFRKPrinter.repeatDoc();
            if (this.g) {
                shtrihFRKPrinter.a();
            }
            return;
        }
    }

    @Override
    public synchronized void cancelcheck(String string) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        int n = FrkUtils.parseInt(string);
        try (ShtrihFRKPrinter shtrihFRKPrinter = new ShtrihFRKPrinter(this.a, this.b, n, c);){
            shtrihFRKPrinter.open();
            shtrihFRKPrinter.cancelCheck();
            return;
        }
    }

    @Override
    public void shutdown() {
    }

    @Override
    public String getStatus() {
        return "portName=" + this.a.getPortName() + ", baudRate = " + this.a.getBaudRate();
    }

    @Override
    public void openday(String string) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        int n = FrkUtils.parseInt(string);
        try (ShtrihFRKPrinter shtrihFRKPrinter = new ShtrihFRKPrinter(this.a, this.b, n, c);){
            shtrihFRKPrinter.open();
            shtrihFRKPrinter._waitToNoPrint(this.d, this.e);
            shtrihFRKPrinter.openDay();
            return;
        }
    }
}

