<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:xalan="http://xml.apache.org/xalan"
	xmlns:utils="ru.bitel.common.Utils"
	xmlns:common="http://common.bitel.ru"
	version="1.0">

	<xsl:output method="html" encoding="UTF-8" indent="yes" />
	
	<xsl:decimal-format name="summa" decimal-separator="." grouping-separator=" "/>

	<xsl:template match="/">
		<html>
			<head></head>
			<body>
				<center>
					<xsl:call-template name="head" />
					<br />
					<xsl:call-template name="table" />
				</center>
			</body>
		</html>
	</xsl:template>

	<xsl:template name="head">
		<h2>
			Отчет по сессиям
			<br />
			Договор:&#160;<xsl:value-of select="/data/@contractTitle" />(<xsl:value-of select="/data/@comment" />)
		</h2>
		<br />
		<xsl:value-of select="/data/@service" />
		&#160;Период с:
		<xsl:value-of select="/data/@dateFrom" />
		по
		<xsl:value-of select="/data/@dateTo" />
	</xsl:template>

	<xsl:template name="table">
		<table width="100%" border="1" cellspacing="0" cellpadding="3">
			<tr bgcolor="#f0f0f0">
				<td>Устройство</td>
				<td>Порт</td>
				<td>Сервис</td>
				<td>C номера/На номер</td>
				<td>IP</td>
				<td>Время входа</td>
				<td>Время выхода</td>
				<td>Активность</td>
				<td>Сумма, руб.</td>
				<td>Статус</td>
				<xsl:for-each select="/data/trafficTypes/data/item">
					<td>
						<xsl:value-of select="@title" />
					</td>
				</xsl:for-each>
			</tr>
			<xsl:for-each select="/data/common:result/data/item">
			<xsl:variable name="count" select="position()"/>
			<tr>
				<td><xsl:value-of select="@deviceId" /></td>
				<td><xsl:value-of select="@devicePort" /></td>
				<td>
					<xsl:variable name="serviceId">
						<xsl:value-of select="@servId" />
					</xsl:variable>
		
					<xsl:for-each select="/data/servs/data/item">
						<xsl:if test="@id=$serviceId">
							<xsl:value-of select="@title" />
						</xsl:if>
					</xsl:for-each>
				</td>
				<td>
					<xsl:if test="@cdsId">
						<xsl:value-of select="@cdsId" />
						/
						<xsl:value-of select="@cnsId" />
					</xsl:if>
		
				</td>
				<td><xsl:value-of select="@ip" /></td>
				<td><xsl:value-of select="@start" /></td>
				<td><xsl:value-of select="@stop" /></td>
				<td><xsl:value-of select="@last" /></td>
				<td><xsl:value-of select="@cost" /></td>
				<td><xsl:value-of select="@statusName" /></td>
				
				<xsl:variable name="session" select="."/>
		
				<xsl:for-each select="/data/trafficTypes/data/item">
					<td>
					<xsl:variable name="typeId"><xsl:value-of select="@id"/></xsl:variable>
					<xsl:variable name="val" select="$session/trafficMap/entry[key/text()=$typeId]/value/text() + sum($session/children/child/trafficMap/entry[key/text()=$typeId]/value/text())"/>
					
					<xsl:choose>
						<xsl:when test="$val!=$val or $val=''">0</xsl:when>
						<xsl:when test="$typeId=0"><xsl:value-of select="utils:formatSessionTime( $val )"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="format-number(($val), '### ### #####0', 'summa')"/></xsl:otherwise>
					</xsl:choose>
					</td>
				</xsl:for-each>
			</tr>
		</xsl:for-each>
 		<tr>
			<td colspan="7">Итого сессий:&#160;<xsl:value-of select="/data/common:result/attributes/item[@key='totalCount']/value"/></td>	
			<td></td>	
			<td><xsl:value-of select="/data/common:result/attributes/item[@key='totalCost']/value"/></td>
			<td>&#160;</td>			
			
			
			<xsl:for-each select="/data/trafficTypes/data/item">
				<td>
				<xsl:variable name="typeId"><xsl:value-of select="@id"/></xsl:variable>
				<xsl:variable name="val" select="number(/data/common:result/attributes/item[@key='totalTraffics']/value/data/entry[key=$typeId]/value)"/>
				
				<xsl:choose>
					<xsl:when test="$val!=$val or $val=''">0</xsl:when>
					<xsl:when test="$typeId=0"><xsl:value-of select="utils:formatSessionTime( $val )"/></xsl:when>
					<xsl:otherwise><xsl:value-of select="format-number(($val), '### ### #####0', 'summa')"/></xsl:otherwise>
				</xsl:choose>
				</td>
			</xsl:for-each>
		</tr>
		</table>
	</xsl:template>

</xsl:stylesheet>