package ru.bitel.bgbilling.modules.inet.dyn.device.misc;

import java.util.Set;

import org.apache.log4j.Logger;

import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.modules.inet.access.sa.ServiceActivatorAdapter;
import ru.bitel.bgbilling.modules.inet.access.sa.ServiceActivatorEvent;
import ru.bitel.bgbilling.modules.inet.access.sa.event.InetSaAccountingEvent;
import ru.bitel.bgbilling.modules.inet.access.sa.event.InetSaOptionsModifyEvent;
import ru.bitel.bgbilling.modules.inet.access.sa.event.InetSaStateModifyEvent;
import ru.bitel.bgbilling.modules.inet.api.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.api.common.bean.InetDevice;
import ru.bitel.bgbilling.modules.inet.api.common.bean.InetDeviceType;
import ru.bitel.bgbilling.modules.inet.api.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.api.common.bean.InetSession;
import ru.bitel.bgbilling.modules.inet.api.common.bean.InetSessionLog;
import ru.bitel.bgbilling.modules.inet.api.server.bean.InetDeviceMap;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class RecipientListServiceActivator
	extends ServiceActivatorAdapter
{
	private static final Logger logger = Logger.getLogger( RecipientListServiceActivator.class );

	private int moduleId;

	private Set<Integer> deviceIds;

	private final EventProcessor eventProcessor = EventProcessor.getInstance();

	@Override
	public Object init( Setup setup, int moduleId, InetDevice device, InetDeviceType deviceType, ParameterMap config )
		throws Exception
	{
		this.moduleId = moduleId;

		this.deviceIds = Utils.toIntegerSet( config.get( "sa.recipientList.deviceIds", null ) );

		int rootDeviceId = config.getInt( "sa.recipientList.rootDeviceId", 0 );
		InetDeviceMap.InetDeviceMapItem rootDevice = InetDeviceMap.getInstance( moduleId ).get( rootDeviceId );
		if( rootDevice != null )
		{
			this.deviceIds.addAll( rootDevice.getDescendantIds() );
		}

		this.deviceIds.remove( device.getId() );

		return null;
	}

	@Override
	public Object connectionModify( final ServiceActivatorEvent e )
		throws Exception
	{
		logger.info( "connectionModify" );

		final int contractId = e.getInetServRuntime().contractRuntime.contractId;
		final int inetServId = e.getInetServId();
		final long connectionId = e.getConnection().getId();

		if( e.getNewState() == InetServ.STATE_DISABLE )
		{
			for( Integer deviceId : this.deviceIds )
			{
				InetSaStateModifyEvent stateModifyEvent = new InetSaStateModifyEvent( moduleId, contractId, 0, deviceId,
				                                                                      inetServId, connectionId,
																					  InetServ.STATE_DISABLE, e.getAccessCode(), false, true );
				stateModifyEvent.setOldOptions( e.getOldOptions() );
				
				eventProcessor.publish( stateModifyEvent );
			}
		}
		else if( e.getOldState() != InetServ.STATE_ENABLE && e.getNewState() == InetServ.STATE_ENABLE )
		{
			for( Integer deviceId : this.deviceIds )
			{
				InetSaStateModifyEvent stateModifyEvent = new InetSaStateModifyEvent( moduleId, contractId, 0, deviceId,
				                                                                      inetServId, connectionId,
																					  InetServ.STATE_ENABLE, e.getAccessCode(), false, true );
				stateModifyEvent.setOldOptions( e.getOldOptions() );

				eventProcessor.publish( stateModifyEvent );
			}
		}
		else
		{
			for( Integer deviceId : this.deviceIds )
			{
				InetSaOptionsModifyEvent optionsModifyEvent = new InetSaOptionsModifyEvent( moduleId, contractId, 0, deviceId,
				                                                                            inetServId, connectionId,
																							e.getNewOptions(), true );
				optionsModifyEvent.setOldOptions( e.getOldOptions() );

				eventProcessor.publish( optionsModifyEvent );
			}
		}

		return null;
	}

	@Override
	public Object onAccountingStart( ServiceActivatorEvent e )
		throws Exception
	{
		logger.info( "onAccountingStart" );

		final InetServ inetServ = e.getInetServRuntime().getInetServ();

		InetSessionLog log = new InetSessionLog( e.getConnection(), new InetSession() );

		for( Integer deviceId : this.deviceIds )
		{
			InetConnection connection = new InetConnection( log );
			connection.setDeviceId( deviceId );
			connection.setDeviceState( e.getConnection().getDeviceState() );
			connection.setDeviceOptions( e.getConnection().getDeviceOptions() );

			eventProcessor.publish( new InetSaAccountingEvent( moduleId, inetServ.getContractId(), connection, InetSaAccountingEvent.TYPE_START ) );
		}

		return null;
	}

	@Override
	public Object onAccountingStop( ServiceActivatorEvent e )
		throws Exception
	{
		logger.info( "onAccountingStop" );

		final InetServ inetServ = e.getInetServRuntime().getInetServ();

		InetSessionLog log = new InetSessionLog( e.getConnection(), new InetSession() );

		for( Integer deviceId : this.deviceIds )
		{
			InetConnection connection = new InetConnection( log );
			connection.setDeviceId( deviceId );
			connection.setDeviceState( e.getConnection().getDeviceState() );
			connection.setDeviceOptions( e.getConnection().getDeviceOptions() );

			eventProcessor.publish( new InetSaAccountingEvent( moduleId, inetServ.getContractId(), connection, InetSaAccountingEvent.TYPE_STOP ) );
		}

		return null;
	}
}
