/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.web.startup;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.TilesException;
import org.apache.tiles.factory.AbstractTilesContainerFactory;
import org.apache.tiles.servlet.context.ServletTilesApplicationContext;
import org.apache.tiles.servlet.context.ServletUtil;
import org.apache.tiles.startup.BasicTilesInitializer;
import org.apache.tiles.startup.TilesInitializer;

public class TilesListener
implements ServletContextListener {
    protected final Log log = LogFactory.getLog(TilesListener.class);
    protected TilesInitializer initializer = this.createTilesInitializer();

    public void contextInitialized(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        this.initializer.initialize((TilesApplicationContext)new ServletTilesApplicationContext(servletContext));
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        try {
            ServletUtil.setContainer(servletContext, null);
        }
        catch (TilesException e) {
            this.log.warn((Object)"Unable to remove tiles container from service.", (Throwable)e);
        }
    }

    protected TilesInitializer createTilesInitializer() {
        return new BasicTilesInitializer();
    }

    protected TilesContainer createContainer(ServletContext context) {
        ServletTilesApplicationContext applicationContext = new ServletTilesApplicationContext(context);
        AbstractTilesContainerFactory factory = AbstractTilesContainerFactory.getTilesContainerFactory((TilesApplicationContext)applicationContext);
        return factory.createContainer((TilesApplicationContext)applicationContext);
    }
}

