/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server;

import bitel.billing.common.VersionInfo;
import bitel.billing.server.Server;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.kernel.application.server.Application;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.bootstrap.Shutdown;

public class AdminPortListener
implements Runnable {
    private Logger logger = Logger.getLogger(AdminPortListener.class);
    private Setup setup;
    private DatagramSocket socket;

    public AdminPortListener() {
        int port = Utils.parseInt(System.getProperty("ru.bitel.common.bootstrap.adminPort"), 0);
        this.logger.info((Object)("Starting listen admin port " + port));
        try {
            this.socket = new DatagramSocket(port);
        }
        catch (Exception ex) {
            this.logger.error((Object)("Port " + port + " is busy!!! [" + ex.getMessage() + "]"));
            System.exit(1);
        }
    }

    public AdminPortListener(Setup setup, int port) {
        this.setup = setup;
        if (port <= 0) {
            port = Utils.parseInt(System.getProperty("ru.bitel.common.bootstrap.adminPort"), 0);
        }
        if (port <= 0 && setup != null) {
            port = setup.getInt("port.admin", 2005);
        }
        this.logger.info((Object)("Starting listen admin port " + port));
        try {
            this.socket = new DatagramSocket(port);
        }
        catch (Exception ex) {
            this.logger.error((Object)("Port " + port + " is busy!!! [" + ex.getMessage() + "]"));
            System.exit(1);
        }
        this.start();
    }

    public void setSetupData(Setup setup) {
        this.setup = setup;
    }

    @Override
    public void run() {
        byte[] buffer = new byte[100];
        byte[] data = null;
        while (true) {
            try {
                while (true) {
                    final DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                    this.socket.receive(packet);
                    data = packet.getData();
                    String command = new String(data, 0, packet.getLength(), "ISO-8859-1").trim();
                    this.logger.info((Object)("Admin command: " + command));
                    if (command.equals("stop")) {
                        Shutdown.addOnShutdown(new Shutdown.OnShutdown(){

                            @Override
                            public void onShutdown() {
                                try {
                                    AdminPortListener.this.sendResponse("OK stopping..", packet);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        });
                        System.exit(0);
                        continue;
                    }
                    if (command.equals("status")) {
                        this.sendResponse(this.getStatus(), packet);
                        continue;
                    }
                    if (command.equals("conpool")) {
                        this.sendResponse(this.setup.getPoolStackTrace(), packet);
                        continue;
                    }
                    String result = Application.executeCommonCommand(command);
                    if (result != null) {
                        this.sendResponse(result, packet);
                        continue;
                    }
                    this.sendResponse("Unknown admin command: " + command, packet);
                }
            }
            catch (Exception ex) {
                this.logger.error((Object)("AdminPortListener error " + ex.getMessage()));
                continue;
            }
            break;
        }
    }

    private void sendResponse(String responseStr, DatagramPacket inPacket) throws Exception {
        int MAX_SIZE = 65533;
        if (responseStr.length() > MAX_SIZE) {
            responseStr = responseStr.substring(0, MAX_SIZE);
        }
        byte[] responseBytes = responseStr.getBytes("ISO-8859-1");
        DatagramPacket response = new DatagramPacket(responseBytes, responseBytes.length, inPacket.getAddress(), inPacket.getPort());
        this.socket.send(response);
    }

    private String getStatus() {
        StringBuffer status = new StringBuffer();
        VersionInfo vi = VersionInfo.getVersionInfo("server");
        status.append("BGBillingServer v ");
        status.append(vi.getVersionString());
        status.append("\n");
        status.append(ServerUtils.uptimeStatus(Server.START_TIME));
        status.append("\n");
        status.append(Utils.memoryStatus());
        if (this.setup != null) {
            status.append("\n");
            status.append(this.setup.getPoolStatus());
        }
        return status.toString();
    }

    public void start() {
        new Thread((Runnable)this, "AdminPortListener").start();
    }
}

