/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.action;

import bitel.billing.server.admin.action.base.ActionBase;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.task.server.TaskCache;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class ActionGetScheduledTaskInfo
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        int id = this.getIntParameter("id", -1);
        if (id > 0) {
            String query = "SELECT st.mm, st.dm, st.dw, st.hh, st.min, st.class_id, st.class, st.module_id, st.prior, st.status, st.comment, st.date1, st.date2, st.params, sc.class FROM scheduled_tasks AS st LEFT JOIN scheduled_class AS sc ON st.class_id=sc.id WHERE st.id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Element element = this.createElement(this.rootNode, "task");
                element.setAttribute("mm", Utils.unpackValues(rs.getLong("st.mm"), 1));
                element.setAttribute("dm", Utils.unpackValues(rs.getLong("st.dm"), 1));
                element.setAttribute("dw", Utils.unpackValues(rs.getLong("st.dw"), 1));
                element.setAttribute("hh", Utils.unpackValues(rs.getLong("st.hh"), 0));
                element.setAttribute("min", Utils.unpackValues(rs.getLong("st.min"), 0));
                String classId = rs.getString("st.class");
                if (Utils.isBlankString(classId)) {
                    classId = rs.getString("sc.class");
                }
                element.setAttribute("class_id", classId);
                Element params = this.createElement(element, "params");
                StringTokenizer st = new StringTokenizer(rs.getString("st.params"), "\r\n");
                HashMap<String, String> paramsMap = new HashMap<String, String>();
                while (st.hasMoreTokens()) {
                    String keyValue = st.nextToken();
                    Element row = this.createElement(params, "row");
                    XMLUtils.createTextNode(row, keyValue);
                    if (!keyValue.contains("=")) continue;
                    String[] values = keyValue.split("=");
                    paramsMap.put(values[0], values[1]);
                }
                String moduleId = rs.getString("st.module_id");
                if (Utils.isBlankString(moduleId)) {
                    moduleId = paramsMap.containsKey("mid") ? (String)paramsMap.get("mid") : (TaskCache.getInstance().isKernelTask(classId) ? "0" : TaskCache.getInstance().getPluginUid(classId));
                }
                element.setAttribute("module_id", moduleId);
                element.setAttribute("prior", rs.getString("st.prior"));
                element.setAttribute("status", rs.getString("st.status"));
                element.setAttribute("comment", rs.getString("st.comment"));
                element.setAttribute("date1", TimeUtils.formatDate(rs.getDate("st.date1")));
                element.setAttribute("date2", TimeUtils.formatDate(rs.getDate("st.date2")));
            }
            rs.close();
            ps.close();
        }
    }
}

