/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;

public class ContractParameterGroupManager {
    public static final String TABLE_CONTRACT_PARAMETER_GROUP = "contract_parameter_group";
    protected Connection con = null;
    protected DefaultServerSetup setup = null;

    public ContractParameterGroupManager(Connection connection) {
        this.con = connection;
    }

    public ContractParameterGroupManager(Connection connection, DefaultServerSetup setup) {
        this.con = connection;
        this.setup = setup;
    }

    public void deleteAllParameterInGroup(int groupId) {
        try {
            PreparedStatement ps = null;
            StringBuilder query = new StringBuilder("DELETE FROM ");
            query.append(TABLE_CONTRACT_PARAMETER_GROUP);
            query.append(" WHERE gid=?");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, groupId);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addParameterInGroup(int groupId, List<Integer> pids) {
        try {
            PreparedStatement ps = null;
            StringBuilder query = new StringBuilder("INSERT INTO ");
            query.append(TABLE_CONTRACT_PARAMETER_GROUP);
            query.append(" SET gid=?, pid=?");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, groupId);
            for (Integer pid : pids) {
                ps.setInt(2, pid);
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Set<Integer> getParameterSetInGroup(int groupId) throws BGException {
        HashSet<Integer> parameterSet = new HashSet<Integer>();
        try {
            StringBuilder query = new StringBuilder("SELECT pid FROM ").append(TABLE_CONTRACT_PARAMETER_GROUP).append(" WHERE gid=").append(groupId);
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query.toString());
            while (rs.next()) {
                parameterSet.add(new Integer(rs.getInt(1)));
            }
            rs.close();
            st.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return parameterSet;
    }
}

