/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.bgsecure.bean;

import bitel.billing.server.admin.bgsecure.bean.RestrictionMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;

public class MenuRestrictManager {
    private Connection con;

    public MenuRestrictManager(Connection con) {
        this.con = con;
    }

    public Map<String, Boolean> getMenuRestrictionsForUser(int uid) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        try {
            String query = "SELECT menu_id, hidden FROM user_menu WHERE uid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, uid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String key = rs.getString(1);
                Boolean value = rs.getBoolean(2);
                if (result.containsKey(key)) {
                    result.remove(key);
                }
                result.put(key, value);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public Map<String, Boolean> getMenuRestrictionsForGroup(int gid) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        try {
            String query = "SELECT menu_id, hidden FROM bgs_group_menu WHERE gid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, gid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String key = rs.getString(1);
                Boolean value = rs.getBoolean(2);
                if (result.containsKey(key)) {
                    result.remove(key);
                }
                result.put(key, value);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public void addGroupMenuRestriction(int gid, String menu, boolean hide) {
        try {
            String query = "INSERT INTO bgs_group_menu VALUES(?,?,?)";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, gid);
            ps.setString(2, menu);
            ps.setBoolean(3, hide);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteGroupMenuRestriction(int gid, String menu) {
        try {
            String query = "DELETE FROM bgs_group_menu WHERE gid=? AND menu_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, gid);
            ps.setString(2, menu);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addUserMenuRestriction(int uid, String menu, boolean hide) {
        try {
            String query = "INSERT INTO user_menu VALUES(?,?,?)";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, uid);
            ps.setString(2, menu);
            ps.setBoolean(3, hide);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteUserMenuRestriction(int uid, String menu) {
        try {
            String query = "DELETE FROM user_menu WHERE uid=? AND menu_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, uid);
            ps.setString(2, menu);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public RestrictionMap getMenuAccessListForUser(int userID) {
        RestrictionMap result = new RestrictionMap();
        try {
            String query = "SELECT bug.gid, gm.menu_id, hidden FROM bgs_user_group as bug LEFT JOIN bgs_group_menu as gm ON bug.gid=gm.gid LEFT JOIN user ON bug.uid=user.id WHERE user.id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, userID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Integer groupId = rs.getInt(1);
                String key = rs.getString(2);
                Boolean value = rs.getBoolean(3);
                result.put(groupId, key, value);
            }
            rs.close();
            ps.close();
            query = "SELECT menu_id, hidden FROM user_menu WHERE uid=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, userID);
            rs = ps.executeQuery();
            while (rs.next()) {
                String key = rs.getString(1);
                Boolean value = rs.getBoolean(2);
                result.put(key, value);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }
}

