/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.resource.action;

import bitel.billing.server.admin.resource.action.base.ActionBase;
import bitel.billing.server.admin.resource.bean.NumberResource;
import bitel.billing.server.admin.resource.bean.NumberResourceManager;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionNumberResourceAdd
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        int categoryId = this.getIntParameter("category_id", 0);
        String numbers = this.getParameter("numbers");
        Calendar date = TimeUtils.convertDateToCalendar(this.getDateParameter("date"));
        if (this.mid <= 0 || categoryId < 0 || Utils.isBlankString(numbers) || date == null) {
            throw new BGIllegalArgumentException();
        }
        List<String> numberList = this.parseNumberResources(numbers);
        if (numberList != null) {
            NumberResourceManager resourceManager = new NumberResourceManager(this.con, this.mid);
            Map<String, List<NumberResource>> resourceMap = resourceManager.getNumberResourceMap();
            for (String number : numberList) {
                List<NumberResource> existResource = resourceMap.get(number);
                if (existResource == null) continue;
                for (NumberResource res : existResource) {
                    if (!TimeUtils.dateInRange(date, TimeUtils.convertDateToCalendar(res.getDateFrom()), TimeUtils.convertDateToCalendar(res.getDateTo()))) continue;
                    throw new BGMessageException("\u041d\u043e\u043c\u0435\u0440 " + number + " \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u043d\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u0443\u044e \u0434\u0430\u0442\u0443");
                }
            }
            for (String number : numberList) {
                NumberResource resource = new NumberResource();
                resource.setCategoryId(categoryId);
                resource.setDateFrom(TimeUtils.convertCalendarToDate(date));
                resource.setNumber(number);
                resourceManager.updateResource(resource);
            }
        }
    }
}

