/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.call.action;

import bitel.billing.server.call.action.base.ActionBase;
import bitel.billing.server.call.bean.Login;
import bitel.billing.server.call.bean.LoginManager;
import bitel.billing.server.util.MonthForRecalc;
import java.sql.SQLException;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;

public class ActionMoveLogin
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        int lid = this.getIntParameter("lid", 0);
        int cidTo = this.getIntParameter("cid_to", -1);
        if (this.mid <= 0 || lid <= 0 || this.cid <= 0 || cidTo <= 0) {
            throw new BGIllegalArgumentException();
        }
        LoginManager loginManage = this.getLoginManager();
        if (loginManage.hasActiveSessions(lid)) {
            throw new BGMessageException("\u0423 \u043b\u043e\u0433\u0438\u043d\u0430 \u0435\u0441\u0442\u044c \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0435 \u0441\u0435\u0441\u0441\u0438\u0438, \u043f\u0435\u0440\u0435\u043d\u043e\u0441 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d.");
        }
        Login login = loginManage.getLoginById(lid);
        if (login == null) {
            throw new BGMessageException("\u041b\u043e\u0433\u0438\u043d \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.");
        }
        try {
            MonthForRecalc months = new MonthForRecalc();
            months.addPeriod(login.getDate1(), login.getDate2());
            loginManage.moveLogin(login, this.cid, cidTo, 0, this.userID);
            loginManage.recalcAfterMove(months, this.cid, cidTo);
        }
        catch (BGException e) {
            throw new BGException(e.toString());
        }
    }
}

